<?php
/**
 * Style One
 * @package WordPress
 * @subpackage Gauch
*/
	if ( ! function_exists( 'gauch_nav_area' ) ) {
		function gauch_nav_area() {
			global $gauch_opt;

			// Main site logo
			if(isset($gauch_opt['main_logo']['url'])):
				$logo 	= $gauch_opt['main_logo']['url'];
			else:
				$logo	= '';
			endif;

			// Logo for mobile device
			if(isset($gauch_opt['mobile_logo']['url'])):
				$mobile_logo 	= $gauch_opt['mobile_logo']['url'];
			else:
				$mobile_logo	= '';
			endif;

			// Header Info
			if( isset( $gauch_opt['header_btn'] ) ):
				$header_btn 		= $gauch_opt['header_btn'];
				$header_btn_link 	= $gauch_opt['header_btn_link'];
			else:
				$header_btn 		= '';
			endif;

			$hide_top_header = isset( $gauch_opt['hide_top_header'] ) ? $gauch_opt['hide_top_header'] : true;
			$top_header_placeholder = isset( $gauch_opt['top_header_placeholder'] ) ? $gauch_opt['top_header_placeholder'] : '';
			$call_number = isset( $gauch_opt['call_number'] ) ? $gauch_opt['call_number'] : '';
			$call_number_link = isset( $gauch_opt['call_number_link'] ) ? $gauch_opt['call_number_link'] : '';
			$hide_top_header_social = isset( $gauch_opt['hide_top_header_social'] ) ? $gauch_opt['hide_top_header_social'] : '';

			$hide_adminbar = 'gauch-hide-adminbar';

			if( function_exists('acf_add_options_page') ) {
				$nav_width    = get_field( 'navigation_width' );
				if( is_home() ) {
					$post_page_id  = get_option( 'page_for_posts' );
					$nav_width    = get_field( 'navigation_width', $post_page_id);
				}
				
				if ( class_exists( 'WooCommerce' ) ){
					if( is_shop() ) {
						$post_page_id  = get_option( 'woocommerce_shop_page_id' );
						$nav_width    = get_field( 'navigation_width', $post_page_id);
					}
				}

				$hide_top_header = get_field('hide_top_header');
			}else {
				$nav_width = 'container';

				$hide_top_header = false;
			}

			if ( $nav_width == 'container-fluid' ) {
				$con_class = 'container-fluid';
			} else {
				$con_class = 'container';
			}

			?>
			<header class="header-area top_header_<?php echo esc_attr($hide_top_header); ?> <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>">
				<?php if($hide_top_header != true): ?>
					<div class="top-header-area">
						<div class="<?php echo esc_attr($con_class); ?>">
							<div class="row align-items-center">
								<div class="col-lg-7 col-md-6">
									<div class="top-header-start d-flex align-items-center">
										<a class="logo d-inline-block <?php if(!has_nav_menu('primary')){echo esc_attr__('logo-without-menu', 'gauch');} ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">
											<?php if( $logo != '' ): ?>
												<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
											<?php else: ?>
												<h2><?php bloginfo( 'name' ); ?></h2>
											<?php endif; ?>
										</a>

										<?php if($top_header_placeholder): ?>
											<form role="search" method="get" id="searchform1" action="<?php echo esc_url( home_url( '/' ) ); ?>" class="search-box">
												<label><i class="ri-search-line"></i></label>
												<input type="search" class="input-search" placeholder="<?php echo esc_attr( $top_header_placeholder ); ?>" value="<?php echo get_search_query(); ?>" name="s" id="s" required>
											</form>
										<?php endif; ?>
									</div>
								</div>
								<div class="col-lg-5 col-md-6">
									<div class="top-header-end">
										<div class="d-flex align-items-center justify-content-end">
											<?php if($call_number): ?>
												<div class="number">
													<a href="<?php echo esc_url( $call_number_link ); ?>" class="d-flex align-items-center"><i class="ri-phone-line"></i> <?php echo esc_html( $call_number ); ?></a>
												</div>
											<?php endif; ?>

											<?php if($hide_top_header_social): ?>
												<ul class="social-links">
													<?php gauch_social_link(); ?>
												</ul>
											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endif; ?>

				<div  class="navbar-area">
					<div class="gauch-responsive-nav">
						<div class="container">
							<div class="gauch-responsive-menu">
								<div class="logo">
									<a href="<?php echo esc_url( home_url( '/' ) );?>">
										<?php if( $mobile_logo != '' ): ?>
											<img src="<?php echo esc_url( $mobile_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
										<?php elseif( $logo != '' ): ?>
											<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
										<?php else: ?>
											<h2><?php bloginfo( 'name' ); ?></h2>
										<?php endif; ?>
									</a>
								</div>
							</div>
						</div>
					</div>

					<div class="navbar navbar-expand-md navbar-light">
						<div class="<?php echo esc_attr($con_class); ?>">

							<?php if($hide_top_header == true): ?>
								<a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
									<?php if( $logo != '' ): ?>
										<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
									<?php else: ?>
										<h2><?php bloginfo( 'name' ); ?></h2>
									<?php endif; ?>
								</a>
							<?php endif; ?>
							<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
								<?php
								$primary_nav_arg = [
									'menu'            => 'primary',
									'theme_location'  => 'primary',
									'container'       => null,
									'menu_class'      => 'navbar-nav',
									'depth'           => 3,
									'walker'          => new Gauch_Bootstrap_Navwalker(),
									'fallback_cb'     => 'Gauch_Bootstrap_Navwalker::fallback',
								];

								if(has_nav_menu('primary')){
									wp_nav_menu($primary_nav_arg);
								}
								?>
								<div class="others-option">
									<?php if($header_btn): ?>
										<a href="<?php echo esc_url( $header_btn_link ); ?>" class="default-btn style-two"><span class="<?php echo esc_attr($gauch_opt['header_btn_icon']); ?>"></span><?php echo esc_html($header_btn); ?></a>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</header>
			<?php
		}
	}

	// Navbar Style 2
	if ( ! function_exists( 'gauch_nav_area2' ) ) {
		function gauch_nav_area2() {
			global $gauch_opt;

			// Main site logo
			if(isset($gauch_opt['main_logo']['url'])):
				$logo 	= $gauch_opt['main_logo']['url'];
			else:
				$logo	= '';
			endif;

			// Logo for mobile device
			if(isset($gauch_opt['mobile_logo']['url'])):
				$mobile_logo 	= $gauch_opt['mobile_logo']['url'];
			else:
				$mobile_logo	= '';
			endif;

			// Header Info
			if( isset( $gauch_opt['header_btn'] ) ):
				$header_btn 		= $gauch_opt['header_btn'];
				$header_btn_link 	= $gauch_opt['header_btn_link'];
			else:
				$header_btn 		= '';
			endif;

			$hide_top_header        = isset( $gauch_opt['hide_top_header'] ) ? $gauch_opt['hide_top_header'] : true;
			$call_number            = isset( $gauch_opt['call_number'] ) ? $gauch_opt['call_number'] : '';
			$call_number_link       = isset( $gauch_opt['call_number_link'] ) ? $gauch_opt['call_number_link'] : '';
			$email_address          = isset( $gauch_opt['email_address'] ) ? $gauch_opt['email_address'] : '';
			$email_address_link     = isset( $gauch_opt['email_address_link'] ) ? $gauch_opt['email_address_link'] : '';
			$hide_top_header_social = isset( $gauch_opt['hide_top_header_social'] ) ? $gauch_opt['hide_top_header_social'] : '';

			$hide_adminbar = 'gauch-hide-adminbar';

			if( function_exists('acf_add_options_page') ) {
				$nav_width    = get_field( 'navigation_width' );
				if( is_home() ) {
					$post_page_id  = get_option( 'page_for_posts' );
					$nav_width    = get_field( 'navigation_width', $post_page_id);
				}

				if ( class_exists( 'WooCommerce' ) ){
					if( is_shop() ) {
						$post_page_id  = get_option( 'woocommerce_shop_page_id' );
						$nav_width    = get_field( 'navigation_width', $post_page_id);
					}
				}

				$hide_top_header = get_field('hide_top_header');
			}else {
				$nav_width       = 'container';
				$hide_top_header = false;
			}

			if ( $nav_width == 'container-fluid' ) {
				$con_class = 'container-fluid';
			} else {
				$con_class = 'container';
			}

			?>

			<?php if($hide_top_header != true): ?>
				<div class="top-header-black-area">
					<div class="<?php echo esc_attr($con_class); ?>">
						<div class="row align-items-center">
							<div class="col-lg-7 col-md-6">
								<ul class="top-header-black-info">
									<?php if($call_number): ?>
										<li>
											<i class="ri-phone-line"></i>
											<a href="<?php echo esc_url( $call_number_link ); ?>"> <?php echo esc_html( $call_number ); ?></a>
										</li>
									<?php endif; ?>
									<?php if($email_address != ''): ?>
										<li>
											<i class="ri-mail-line"></i>
											<a href="<?php echo esc_url( $email_address_link ); ?>"> <?php echo esc_html( $email_address ); ?></a>
										</li>
									<?php endif; ?>
								</ul>
							</div>
							
							<div class="col-lg-5 col-md-6">
								<?php if($hide_top_header_social): ?>
									<ul class="top-header-black-social-links">
										<?php gauch_social_link(); ?>
									</ul>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			<?php endif; ?>

			<div class="navbar-area navbar-area-with-position-relative  <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>">
				<div class="gauch-responsive-nav">
					<div class="container">
						<div class="gauch-responsive-menu">
							<div class="logo">
								<a href="<?php echo esc_url( home_url( '/' ) );?>">
									<?php if( $mobile_logo != '' ): ?>
										<img src="<?php echo esc_url( $mobile_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
									<?php elseif( $logo != '' ): ?>
										<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
									<?php else: ?>
										<h2><?php bloginfo( 'name' ); ?></h2>
									<?php endif; ?>
								</a>
							</div>
						</div>
					</div>
				</div>

				<div class="navbar navbar-expand-md navbar-light">
					<div class="<?php echo esc_attr($con_class); ?>">

						<a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<?php if( $logo != '' ): ?>
								<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
							<?php else: ?>
								<h2><?php bloginfo( 'name' ); ?></h2>
							<?php endif; ?>
						</a>
						<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
							<?php
							$primary_nav_arg = [
								'menu'            => 'primary',
								'theme_location'  => 'primary',
								'container'       => null,
								'menu_class'      => 'navbar-nav m-auto',
								'depth'           => 3,
								'walker'          => new Gauch_Bootstrap_Navwalker(),
								'fallback_cb'     => 'Gauch_Bootstrap_Navwalker::fallback',
							];

							if(has_nav_menu('primary')){
								wp_nav_menu($primary_nav_arg);
							}
							?>
							<?php if($header_btn): ?>
								<div class="others-option">
									<a href="<?php echo esc_url( $header_btn_link ); ?>" class="default-btn style-two"><span class="<?php echo esc_attr($gauch_opt['header_btn_icon']); ?>"></span><?php echo esc_html($header_btn); ?></a>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>

			<?php
		}
	}

	// Navbar Style 3
	if ( ! function_exists( 'gauch_nav_area3' ) ) {
		function gauch_nav_area3() {
			global $gauch_opt;

			// Main site logo
			if(isset($gauch_opt['main_logo']['url'])):
				$logo 	= $gauch_opt['main_logo']['url'];
			else:
				$logo	= '';
			endif;

			// Logo for mobile device
			if(isset($gauch_opt['mobile_logo']['url'])):
				$mobile_logo 	= $gauch_opt['mobile_logo']['url'];
			else:
				$mobile_logo	= '';
			endif;

			// Header Info
			if( isset( $gauch_opt['header_btn'] ) ):
				$header_btn 		= $gauch_opt['header_btn'];
				$header_btn_link 	= $gauch_opt['header_btn_link'];
			else:
				$header_btn 		= '';
			endif;

			$hide_top_header        = isset( $gauch_opt['hide_top_header'] ) ? $gauch_opt['hide_top_header'] : true;

			$trade_img1     = isset( $gauch_opt['trade_img1']['url'] ) ? $gauch_opt['trade_img1']['url'] : '';
			$trade_con1     = isset( $gauch_opt['trade_con1'] ) ? $gauch_opt['trade_con1'] : '';

			$trade_img2     = isset( $gauch_opt['trade_img2']['url'] ) ? $gauch_opt['trade_img2']['url'] : '';
			$trade_con2     = isset( $gauch_opt['trade_con2'] ) ? $gauch_opt['trade_con2'] : '';

			$trade_img3    = isset( $gauch_opt['trade_img3']['url'] ) ? $gauch_opt['trade_img3']['url'] : '';
			$trade_con3     = isset( $gauch_opt['trade_con3'] ) ? $gauch_opt['trade_con3'] : '';

			$trade_img4    = isset( $gauch_opt['trade_img4']['url'] ) ? $gauch_opt['trade_img4']['url'] : '';
			$trade_con4     = isset( $gauch_opt['trade_con4'] ) ? $gauch_opt['trade_con4'] : '';

			$trade_img5     = isset( $gauch_opt['trade_img5']['url'] ) ? $gauch_opt['trade_img5']['url'] : '';
			$trade_con5     = isset( $gauch_opt['trade_con5'] ) ? $gauch_opt['trade_con5'] : '';

			$trade_img6     = isset( $gauch_opt['trade_img6']['url'] ) ? $gauch_opt['trade_img6']['url'] : '';
			$trade_con6     = isset( $gauch_opt['trade_con6'] ) ? $gauch_opt['trade_con6'] : '';

			$trade_img7     = isset( $gauch_opt['trade_img7']['url'] ) ? $gauch_opt['trade_img7']['url'] : '';
			$trade_con7     = isset( $gauch_opt['trade_con7'] ) ? $gauch_opt['trade_con7'] : '';

			$trade_img8     = isset( $gauch_opt['trade_img8']['url'] ) ? $gauch_opt['trade_img8']['url'] : '';
			$trade_con8     = isset( $gauch_opt['trade_con8'] ) ? $gauch_opt['trade_con8'] : '';

			$trade_img9     = isset( $gauch_opt['trade_img9']['url'] ) ? $gauch_opt['trade_img9']['url'] : '';
			$trade_con9     = isset( $gauch_opt['trade_con9'] ) ? $gauch_opt['trade_con9'] : '';

			$hide_adminbar = 'gauch-hide-adminbar';

			if( function_exists('acf_add_options_page') ) {
				$nav_width    = get_field( 'navigation_width' );
				if( is_home() ) {
					$post_page_id  = get_option( 'page_for_posts' );
					$nav_width    = get_field( 'navigation_width', $post_page_id);
				}
				
				if ( class_exists( 'WooCommerce' ) ){
					if( is_shop() ) {
						$post_page_id  = get_option( 'woocommerce_shop_page_id' );
						$nav_width    = get_field( 'navigation_width', $post_page_id);
					}
				}

				$nav_layout    = get_field( 'choose_navigation_style' );
				if( is_home() ) {
					$post_page_id  = get_option( 'page_for_posts' );
					$nav_layout    = get_field( 'choose_navigation_style', $post_page_id);
				}
				
				if ( class_exists( 'WooCommerce' ) ){
					if( is_shop() ) {
						$post_page_id  = get_option( 'woocommerce_shop_page_id' );
						$nav_layout    = get_field( 'choose_navigation_style', $post_page_id);
					}
				}

				$hide_top_header = get_field('hide_top_header');
			}else {
				$nav_width = 'container';
				$nav_layout = 1;
				$hide_top_header = false;
			}

			if ( $nav_width == 'container-fluid' ) {
				$con_class = 'container-fluid';
			} else {
				$con_class = 'container';
			}
			if( $nav_layout == 4 ) :
				$navcolor = ' with-black-color ';
			else:
				$navcolor = ' with-ehite-color ';
			endif;
			?>

			<?php if($hide_top_header != true): ?>
				<div class="value-trade-area">
					<div class="<?php echo esc_attr($con_class); ?>">
						<div class="value-trade-slides owl-carousel owl-theme">
							<?php if( $trade_con1 != '' || $trade_img1 != '' ) : ?>
								<div class="value-trade-card">
									<?php if( $trade_img1 != ''  ) : ?>
										<img src="<?php echo esc_url( $trade_img1 ); ?> " alt="<?php echo esc_attr__('image','gauch'); ?>">
									<?php endif; ?>
									<h3><?php echo wp_kses( $trade_con1, 'gauchallowedhtml' ); ?></h3>
								</div>
							<?php endif; ?>
							<?php if( $trade_con2 != '' || $trade_img2 != '' ) : ?>
								<div class="value-trade-card">
									<?php if( $trade_img2 != ''  ) : ?>
										<img src="<?php echo esc_url( $trade_img2); ?> " alt="<?php echo esc_attr__('image','gauch'); ?>">
									<?php endif; ?>
									<h3><?php echo wp_kses( $trade_con2, 'gauchallowedhtml' ); ?></h3>
								</div>
							<?php endif; ?>
							<?php if( $trade_con3 != '' || $trade_img3 != '' ) : ?>
								<div class="value-trade-card">
									<?php if( $trade_img3 != ''  ) : ?>
										<img src="<?php echo esc_url( $trade_img3 ); ?> " alt="<?php echo esc_attr__('image','gauch'); ?>">
									<?php endif; ?>
									<h3><?php echo wp_kses( $trade_con3, 'gauchallowedhtml' ); ?></h3>
								</div>
							<?php endif; ?>
							<?php if( $trade_con4 != '' || $trade_img4 != '' ) : ?>
								<div class="value-trade-card">
									<?php if( $trade_img4 != ''  ) : ?>
										<img src="<?php echo esc_url( $trade_img4 ); ?> " alt="<?php echo esc_attr__('image','gauch'); ?>">
									<?php endif; ?>
									<h3><?php echo wp_kses( $trade_con4, 'gauchallowedhtml' ); ?></h3>
								</div>
							<?php endif; ?>
							<?php if( $trade_con5 != '' || $trade_img5 != '' ) : ?>
								<div class="value-trade-card">
									<?php if( $trade_img5 != ''  ) : ?>
										<img src="<?php echo esc_url( $trade_img5 ); ?> " alt="<?php echo esc_attr__('image','gauch'); ?>">
									<?php endif; ?>
									<h3><?php echo wp_kses( $trade_con5, 'gauchallowedhtml' ); ?></h3>
								</div>
							<?php endif; ?>
							<?php if( $trade_con6 != '' || $trade_img6 != '' ) : ?>
								<div class="value-trade-card">
									<?php if( $trade_img6 != ''  ) : ?>
										<img src="<?php echo esc_url( $trade_img6 ); ?> " alt="<?php echo esc_attr__('image','gauch'); ?>">
									<?php endif; ?>
									<h3><?php echo wp_kses( $trade_con6, 'gauchallowedhtml' ); ?></h3>
								</div>
							<?php endif; ?>
							<?php if( $trade_con7 != '' || $trade_img7 != '' ) : ?>
								<div class="value-trade-card">
									<?php if( $trade_img7 != ''  ) : ?>
										<img src="<?php echo esc_url( $trade_img7 ); ?> " alt="<?php echo esc_attr__('image','gauch'); ?>">
									<?php endif; ?>
									<h3><?php echo wp_kses( $trade_con7, 'gauchallowedhtml' ); ?></h3>
								</div>
							<?php endif; ?>
							<?php if( $trade_con8 != '' || $trade_img8 != '' ) : ?>
								<div class="value-trade-card">
									<?php if( $trade_img8 != ''  ) : ?>
										<img src="<?php echo esc_url( $trade_img8 ); ?> " alt="<?php echo esc_attr__('image','gauch'); ?>">
									<?php endif; ?>

									<h3><?php echo wp_kses( $trade_con8, 'gauchallowedhtml' ); ?></h3>
								</div>
							<?php endif; ?>
							<?php if( $trade_con9 != '' || $trade_img9 != '' ) : ?>
								<div class="value-trade-card">
									<?php if( $trade_img9 != ''  ) : ?>
										<img src="<?php echo esc_url( $trade_img9 ); ?> " alt="<?php echo esc_attr__('image','gauch'); ?>">
									<?php endif; ?>

									<h3><?php echo wp_kses( $trade_con9, 'gauchallowedhtml' ); ?></h3>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			<?php endif; ?>

			<div class="navbar-area navbar-area-with-position-relative <?php echo esc_attr($navcolor); ?> <?php if ( is_user_logged_in() ) { echo esc_attr( $hide_adminbar ); } ?>">
				<div class="gauch-responsive-nav">
					<div class="container">
						<div class="gauch-responsive-menu">
							<div class="logo">
								<a href="<?php echo esc_url( home_url( '/' ) );?>">
									<?php if( $mobile_logo != '' ): ?>
										<img src="<?php echo esc_url( $mobile_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
									<?php elseif( $logo != '' ): ?>
										<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
									<?php else: ?>
										<h2><?php bloginfo( 'name' ); ?></h2>
									<?php endif; ?>
								</a>
							</div>
						</div>
					</div>
				</div>

				<nav class="navbar navbar-expand-md navbar-light">
					<div class="<?php echo esc_attr($con_class); ?>">

						<a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<?php if( $logo != '' ): ?>
								<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
							<?php else: ?>
								<h2><?php bloginfo( 'name' ); ?></h2>
							<?php endif; ?>
						</a>
						<div class="collapse navbar-collapse mean-menu">
							<?php
							$primary_nav_arg = [
								'menu'            => 'primary',
								'theme_location'  => 'primary',
								'container'       => null,
								'menu_class'      => 'navbar-nav m-auto',
								'depth'           => 3,
								'walker'          => new Gauch_Bootstrap_Navwalker(),
								'fallback_cb'     => 'Gauch_Bootstrap_Navwalker::fallback',
							];

							if(has_nav_menu('primary')){
								wp_nav_menu($primary_nav_arg);
							}
							?>
							<?php if($header_btn): ?>
								<div class="others-option">
									<a href="<?php echo esc_url( $header_btn_link ); ?>" class="default-btn style-two"><span class="<?php echo esc_attr($gauch_opt['header_btn_icon']); ?>"></span><?php echo esc_html($header_btn); ?></a>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</nav>
			</div>

			<?php
		}
	}