<?php
/**
 * The single template file
 * @package Gauch
 */
get_header();

$title = get_the_title();

// Blog sidebar
if(isset($gauch_opt['gauch_single_blog_sidebar'])) {
    if( $gauch_opt['gauch_single_blog_sidebar'] == 'gauch_without_sidebar_center' ):
        $gauch_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $gauch_opt['gauch_single_blog_sidebar'] == 'gauch_without_sidebar' ):
        $gauch_sidebar_class = 'col-lg-12 col-md-12';
    else:
        if( is_active_sidebar( 'sidebar-1' ) ):
            $gauch_sidebar_class = 'col-lg-8 col-md-12';
        else:
            $gauch_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        endif;
    endif;
    $sidebar_hide = $gauch_opt['gauch_single_blog_sidebar'];
} else {
    if( is_active_sidebar( 'sidebar-1' ) ):
        $gauch_sidebar_class = 'col-lg-8 col-md-12';
        $sidebar_hide = 'gauch_with_sidebar';
    else:
        $gauch_sidebar_class = 'col-lg-8 col-md-12 offset-lg-2';
        $sidebar_hide = 'gauch_without_sidebar';
    endif;
}

// Blog breadcrumb
if( isset($gauch_opt['blog_title']) ) {
    $hide_breadcrumb    	= $gauch_opt['hide_breadcrumb'];
    $hide_blog_banner       = $gauch_opt['hide_blog_banner'];
} else {
    $hide_breadcrumb    	= 	false;
    $hide_blog_banner       = false;
}

if( function_exists('acf_add_options_page') ) {
	$bg_img = get_field( 'post_banner_background_image' );
}else {
	$bg_img = '';
}

$gauch_blog_single_layout = !empty($gauch_opt['gauch_blog_single_layout']) ? $gauch_opt['gauch_blog_single_layout'] : 'container';

if( isset($gauch_opt['page_title_tag']) ):
    $tag = $gauch_opt['page_title_tag'];
else:
    $tag = 'h1';
endif;

if( isset( $gauch_opt['gauch_blog_style'] ) ):
    $blog_style     = $gauch_opt['gauch_blog_style'];
else:
    $blog_style     = '1';
endif;
?>
<?php if($blog_style == '1'): ?>
    <?php if( $hide_blog_banner == false ): ?>
		<div class="page-title-area">
            <div class="container">
                <div class="page-title-content text-center">
                    <<?php echo esc_attr( $tag ); ?>>
						<?php
							if( !empty(get_the_title()) ):
								the_title();
							else:
								esc_html_e( 'No Title', 'gauch' );
							endif;
						?>
					</<?php echo esc_attr( $tag ); ?>>

                    <?php if( $hide_breadcrumb == false ): ?>
                        <?php
                            if ( function_exists('yoast_breadcrumb') ) {
                                yoast_breadcrumb( '<p class="gauch-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                            } else { ?>
                                <ul>
                                    <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'gauch' ); ?></a></li>
                                    <li>
										<?php
											if( !empty(get_the_title()) ):
												the_title();
											else:
												esc_html_e( 'No Title', 'gauch' );
											endif;
										?>
									</li>
                                </ul>
                                <?php
                            }
                    endif; ?>
                </div>
            </div>
        	<?php gauch_page_shape_images(); ?>
        </div>
	<?php endif; ?>

	<!-- Start Blog Area -->
	<div class="blog-details-area ptb-100 blog-style-one">
		<div class="<?php echo esc_attr( $gauch_blog_single_layout ); ?>">
			<div class="row">
				<?php
				while ( have_posts() ) :
				the_post(); ?>
					<div class="<?php echo esc_attr( $gauch_sidebar_class ); ?>">
						<div class="blog-details">
							<?php if(has_post_thumbnail()) { ?>
								<div class="post-image">
									<img src="<?php the_post_thumbnail_url('full') ?>" alt="<?php the_title_attribute(); ?>">
								</div>
							<?php } ?>

							<div class="blog-details-content">
								<?php if( isset( $gauch_opt['is_post_meta'] ) && $gauch_opt['is_post_meta'] == true ) { ?>
									<div class="blog-meta">
										<ul class="entry-meta">
											<li>
												<i class="ri-user-line"></i>
												<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php echo esc_html(get_the_author()); ?></a>
											</li>
											<li>
												<i class="ri-time-line"></i>
												<?php echo wp_kses(get_the_date('F d, Y'), 'gauchallowedhtml') ?>
											</li>
											<li>
												<i class="ri-message-2-line"></i>
												<?php comments_number(); ?>
											</li>
										</ul>
									</div> <?php
								} ?>

								<?php the_content();

								wp_link_pages( array(
									'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'gauch' ),
									'after'  => '</div>',
								) );
								?>

								<?php if ( get_the_tags() ) {  ?>
								<div class="post-tag-media">
									<ul class="tag">
										<li><span><?php echo esc_html_e('برچسب ها :', 'gauch') ?></span></li>
										<?php $tags = get_the_tags();
										foreach ($tags as $tag ) {  ?>
												<li><a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>">
													<?php echo esc_html($tag->name) ?></a>
												</li>
											<?php
										} ?>
									</ul>
								</div>
								<?php } ?>
							</div>
						</div>

						<?php if(get_the_post_navigation()): ?>
							<?php gauch_single_navigation(); ?>
						<?php endif; ?>

						<?php
							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ) :
								comments_template();
							endif;
						?>
					</div>
				<?php endwhile; // End of the loop. ?>

				<?php if( $sidebar_hide == 'gauch_with_sidebar' ): ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>

			</div>
		</div>
	</div>
	<!-- End Blog Area -->
<?php else: ?>
	<!-- Start Blog Area -->
	<div class="blog-details-area ptb-100" style="background-image:url(<?php echo esc_url( $gauch_opt['single_blog_bg']['url'] ); ?>);">
		<div class="<?php echo esc_attr( $gauch_blog_single_layout ); ?>">
			<div class="row blog-details-content">
				<?php
				while ( have_posts() ) :
				the_post(); ?>
					<div class="<?php echo esc_attr( $gauch_sidebar_class ); ?>">
						<?php if( $hide_blog_banner == false ): ?>
							<div class="blog-details-header row align-items-center justify-content-center">
								<div class="col-lg-6 col-md-12">
									<div class="content">
										<?php
										$post_tags  = get_the_tags();
										$count      = 0;
										$sep        = '';
										if ( $post_tags ) {
											foreach( $post_tags as $tag ) {
												$count++;
												?>
													<a class="category" href="<?php echo esc_url( get_tag_link( $tag->term_id ) ); ?>"><?php echo esc_html( $tag->name ); ?></a>
												<?php
												if( $count > 0 ) break;
											}
										}
										?>
										<h1><?php the_title(); ?></h1>
										<?php the_excerpt(); ?>
										<div class="post-author-meta">
										<?php
											$user       = get_the_author_meta('ID');
											$user_image = get_avatar_url($user, ['size' => '51']);
											$author_link    = get_author_posts_url( $user );
										?>
											<div class="d-flex align-items-center">
												<img src="<?php echo esc_url( $user_image ); ?>" alt="<?php echo esc_attr( get_the_author() ); ?>">
												<div class="title">
													<span class="name"><?php esc_html_e('By', 'gauch'); ?> <a href="<?php echo esc_url( $author_link ); ?>"><?php echo esc_html( get_the_author() ); ?></a></span>
													<span class="date"><?php echo wp_kses(get_the_date('F d, Y'), 'gauchallowedhtml') ?></span>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-lg-6 col-md-12">
									<?php if(has_post_thumbnail()) { ?>
										<div class="image">
											<img src="<?php the_post_thumbnail_url('full') ?>" alt="<?php the_title_attribute(); ?>">
										</div>
									<?php } ?>
								</div>
							</div>
						<?php endif; ?>

						<div class="blog-details-desc">

							<div class="article-content">

								<ul class="social-links">
									<li><a class="facebook d-block" href="https://www.facebook.com/sharer.php?u=<?php echo urlencode( get_permalink() ); ?>" target="_blank"><i class="ri-facebook-fill"></i></a></li>
									<li><a class="twitter d-block" href="https://twitter.com/share?url='<?php echo urlencode( get_permalink() ); ?>&amp;text=<?php echo rawurlencode( esc_attr( get_the_title() ) ); ?>" target="_blank"><i class="ri-twitter-fill"></i></a></li>
									<li><a class="pinterest d-block" href="http://pinterest.com/pin/create/button/?url=<?php echo urlencode( get_permalink() );?>&amp;description=<?php rawurlencode( esc_attr( get_the_excerpt() ) ); ?>&amp;media=<?php echo urlencode( wp_get_attachment_url( get_post_thumbnail_id() ) ); ?>" onclick="window.open(this.href); return false;" target="_blank"><i class="ri-pinterest-fill"></i></a></li>
									<li><a class="linkedin d-block" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo urlencode( get_permalink() ); ?>" target="_blank"><i class="ri-linkedin-fill"></i></a></li>
								</ul>

								<?php the_content();

								wp_link_pages( array(
									'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'gauch' ),
									'after'  => '</div>',
								) );
								?>

								<?php if ( get_the_tags() ) {  ?>
								<div class="post-tag-media">
									<ul class="tag">
										<?php $tags = get_the_tags();
										foreach ($tags as $tag ) {  ?>
												<li><a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>">
													<?php echo esc_html($tag->name) ?></a>
												</li>
											<?php
										} ?>
									</ul>
								</div>
								<?php } ?>
								<?php
									// If comments are open or we have at least one comment, load up the comment template.
									if ( comments_open() || get_comments_number() ) :
										comments_template();
									endif;
								?>
							</div>
						</div>
					</div>
				<?php endwhile; // End of the loop. ?>

				<?php if( $sidebar_hide == 'gauch_with_sidebar' ): ?>
					<?php get_sidebar(); ?>
				<?php endif; ?>

			</div>
		</div>
	</div>
	<!-- End Blog Area -->
<?php endif; ?>

<?php
get_footer();