<?php
/**
 * The template for displaying all pages
 */

get_header();

/**
 * Page Control
 */
if( function_exists('acf_add_options_page') ) {
	$hide_banner 		= get_field( 'enable_page_banner' );
	$hide_breadcrumb 	= get_field( 'hide_breadcrumb' );
}else {
	$hide_banner 		= false;
	$hide_breadcrumb 	= false;
}

// Page Title
if( isset($gauch_opt['page_title_tag']) ):
    $tag = $gauch_opt['page_title_tag'];
else:
    $tag = 'h1';
endif;
?>
	<?php if( $hide_banner == false ) { ?><!-- Start Page Title Area -->
		<div class="page-title-area">
            <div class="container">
                <div class="page-title-content text-center">
					<<?php echo esc_attr( $tag ); ?>><?php the_title(); ?></<?php echo esc_attr( $tag ); ?>>

                    <?php if( $hide_breadcrumb == false ): ?>
						<?php
							if ( function_exists('yoast_breadcrumb') ) {
								yoast_breadcrumb( '<p class="gauch-seo-breadcrumbs" id="breadcrumbs">','</p>' );
							} else { ?>
								<ul>
									<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'gauch' ); ?></a></li>
									<li><?php the_title(); ?></li>
								</ul>
								<?php
							}
					endif; ?>
                </div>
            </div>

           <?php gauch_page_shape_images(); ?>
        </div>
	<?php } ?><!-- End Page Title Area -->

	<?php if( !gauch_is_elementor()): ?><div class="page-main-content blog-details"><?php endif; ?>
		<div class="page-area">
			<?php if( !gauch_is_elementor()): ?><div class="container"><?php endif; ?>
				<?php while ( have_posts() ) : the_post(); ?>
					<?php $thecontent = get_the_content(); // If no content ?>
					<?php if(empty($thecontent)){ ?> <div class="gauch-single-blank-page"></div><?php } ?>

					<?php if( !gauch_is_elementor()): ?><div class="blog-details-content"><?php endif; ?>
						<?php get_template_part( 'template-parts/content', 'page' ); ?>
					<?php if( !gauch_is_elementor()): ?></div><?php endif; ?>
					<?php if ( comments_open() || get_comments_number() ) : comments_template(); endif; // If comments are open or we have at least one comment, load up the comment template. ?>
				<?php endwhile; // End of the loop. ?>
		<?php if( !gauch_is_elementor()): ?></div><?php endif; ?>
		</div>
	<?php if( !gauch_is_elementor()): ?></div><?php endif; ?>

<?php get_footer();