<?php
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'gauch_register_required_plugins' );

if ( ! function_exists( 'gauch_register_required_plugins' ) ) {
	function gauch_register_required_plugins() {

		$plugins = array(

			array(
				'name'               => esc_html__('Gauch Toolkit', 'gauch'),
				'slug'               => 'gauch-toolkit',
				'source'             => get_template_directory() . '/lib/plugins/gauch-toolkit.zip',
				'required'           => true,
			),

			// Elemantor Page Builder
			array(
				'name'               => esc_html__('Elementor Page Builder', 'gauch'),
				'slug'               => 'elementor',
				'required'           => true,
			),

			// Advanced Custom Fields Pro
			array(
				'name'               => esc_html__('Advanced Custom Fields Pro', 'gauch'),
				'slug'               => 'advanced-custom-fields-pro',
				'source'             => 'https://themes.hibotheme.com/tools/advanced-custom-fields-pro.zip', 
				'required'           => true,
			),

			array(
				'name'      => esc_html__('Contact Form 7', 'gauch'),
				'slug'      => 'contact-form-7',
				'required'  => false,
			),
			array(
				'name'               => esc_html__('Hibo Demo Importer', 'gauch'),
				'slug'               => 'hibo-demo-importer',
				'required'           => true,
				'source'             => 'https://themes.hibotheme.com/tools/hibo-demo-importer.zip',
			),
			array(
				'name'		 => esc_html__( 'WooCommerce', 'gauch' ),
				'slug'		 => 'woocommerce',
				'required'	 => true,
			),
		);

		$config = array(
			'id'           => 'tgmpa',
			'default_path' => '',
			'menu'         => 'tgmpa-install-plugins',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true,
			'dismissable'  => true,
			'dismiss_msg'  => '',
			'is_automatic' => false,
			'message'      => '',
		);
		tgmpa( $plugins, $config );
	}
}