<?php
/**
 *  Gauch WooCommerce functions and definitions
 */
// Theme WooCommerce Support
apply_filters( 'storefront_woocommerce_args', array(
	'single_image_width'    => 530,
	'thumbnail_image_width' => 350,
	add_theme_support( 'wc-product-gallery-zoom' ),
	add_theme_support( 'wc-product-gallery-lightbox' ),
	add_theme_support( 'wc-product-gallery-slider' ),
) );

// Change number or products per row
add_filter('loop_shop_columns', 'gauch_loop_columns', 999);
if (!function_exists('gauch_loop_columns')) {
	function gauch_loop_columns() {
		global $gauch_opt;

		$product_columns   = $gauch_opt['product_columns'];

		if($product_columns == ''):
			if ( isset( $_GET['shop-sidebar'] ) ):
				if( $_GET['shop-sidebar'] == 'right' || $_GET['shop-sidebar'] == 'left' ):
					return 2; // 2 products per row
				elseif( $_GET['shop-sidebar'] == 'none' ):
					return 3; // 3 products per row
				endif;
			else:
				if ( $gauch_opt['gauch_product_sidebar'] == 'gauch_product_no_sidebar' ):
					return 3; // 3 products per row
				else:
					return 2; // 2 products per row
				endif;
			endif;
		else:
			return $product_columns;
		endif;
	}
}

// Change number of related products output
function gauch_woo_related_products_limit() {
	global $product;
	$args['posts_per_page'] = 6;
	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'gauch_related_products_args', 20 );
function gauch_related_products_args( $args ) {
	global $gauch_opt;

	if( isset( $gauch_opt['gauch_related_product_count'] ) ):
		$count = $gauch_opt['gauch_related_product_count'];
	else:
		$count = '3';
	endif;

	$args['posts_per_page'] = $count; // related products

	global $gauch_opt;
	if ( isset( $_GET['shop-sidebar'] ) ):
		if( $_GET['shop-sidebar'] == 'right' || $_GET['shop-sidebar'] == 'left' ):
			$args['columns'] = 2; // 2 products per row
		elseif( $_GET['shop-sidebar'] == 'none' ):
			$args['columns'] = 3; // 3 products per row
		endif;
	else:
		if ( $gauch_opt['gauch_product_sidebar'] == 'gauch_product_no_sidebar' ):
			$args['columns'] = 3; // 3 products per row
		else:
			$args['columns'] = 2; // 2 products per row
		endif;
	endif;

	return $args;
}

if ( ! function_exists( 'gauch_wc_refresh_mini_cart_count' ) ) :
	function gauch_wc_refresh_mini_cart_count($fragments){
		ob_start();
		?>
		<span class="mini-cart-count">
			<?php echo WC()->cart->get_cart_contents_count(); ?>
		</span>
		<?php
			$fragments['.mini-cart-count'] = ob_get_clean();
		return $fragments;
	}
endif;
add_filter( 'woocommerce_add_to_cart_fragments', 'gauch_wc_refresh_mini_cart_count');

// Filter woocommerce_checkout_fields
if ( ! function_exists( 'gauch_field_class_add' ) ) :
	function gauch_field_class_add($fields) {
	foreach ($fields as &$fieldset) {
		foreach ($fieldset as &$field) {
			$field['class'][] = 'form-group';
			$field['input_class'][] = 'form-control';
		}
	}
	return $fields;
}
endif;
add_filter('woocommerce_checkout_fields', 'gauch_field_class_add' );

/**
 * Post Per page
 */
add_filter( 'loop_shop_per_page', 'gauch_redefine_products_per_page', 9999 );

function gauch_redefine_products_per_page( $per_page ) {
	global $gauch_opt;

	if( isset( $gauch_opt['products_page_count'] ) ):
		$count = $gauch_opt['products_page_count'];
	else:
		$count = '6';
	endif;

	$per_page = $count;
	return $per_page;
}

if ( ! function_exists( 'gauch_refresh_mini_cart_count' ) ) :
	function gauch_refresh_mini_cart_count($fragments){
		ob_start();
		?>
		<span class="cart-count">
			<?php echo WC()->cart->get_cart_contents_count(); ?>
		</span>
		<?php
			$fragments['.cart-count'] = ob_get_clean();
		return $fragments;
	}
endif;
add_filter( 'woocommerce_add_to_cart_fragments', 'gauch_refresh_mini_cart_count');


/**
 * Auto Complete all WooCommerce orders.
 */
add_action( 'woocommerce_thankyou', 'gauch_custom_woocommerce_auto_complete_order' );
function gauch_custom_woocommerce_auto_complete_order( $order_id ) {
	if ( ! $order_id ) {
		return;
	}
	global $gauch_opt;
	if( $gauch_opt['enable_auto_complete'] == 'yes' ):
		$order = wc_get_order( $order_id );
		$order->update_status( 'completed' );
	endif;

}