<?php
/**
 * Register Theme Widget
 * @package Gauch
 */


// Register sidebar
if ( ! function_exists( 'gauch_widgets_init' ) ) {
    function gauch_widgets_init() {
        register_sidebar( array(
            'name'          => esc_html__( 'Blog Sidebar', 'gauch' ),
            'id'            => 'sidebar-1',
            'description'   => esc_html__( 'Add widgets here.', 'gauch' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );

        // Footer Sidebar
        global $gauch_opt;
        $footer_column = !empty($gauch_opt['footer_column']) ? $gauch_opt['footer_column'] : '4';
        register_sidebar( array(
            'name'          => esc_html__( 'Footer Widgets', 'gauch' ),
            'id'            => 'footer_widgets',
            'description'   => esc_html__( 'Add widgets here.', 'gauch' ),
            'before_widget' => '<div class="single-footer-widget col'.$footer_column.' %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h3>',
            'after_title'   => '</h3>',
        ) );
    }
}
add_action( 'widgets_init', 'gauch_widgets_init' );