<?php
/**
 * Gauch functions and definitions
 * @package Gauch
 */


/**
 * Shorthand contents for theme assets url
 */
define('GAUCH_VERSION', time());
define('GAUCH_THEME_URI', get_template_directory_uri());
define('GAUCH_THEME_DIR', get_template_directory());
define('GAUCH_IMG',GAUCH_THEME_URI . '/assets/img');
define('GAUCH_CSS',GAUCH_THEME_URI . '/assets/css');
define('GAUCH_JS',GAUCH_THEME_URI . '/assets/js');
if( !defined('GAUCH_FRAMEWORK_VAR') ) define('GAUCH_FRAMEWORK_VAR', 'gauch_opt');

/**
 * Sets up theme defaults and registers support for various WordPress features.
 */
if ( ! function_exists( 'gauch_setup' ) ) :

	function gauch_setup() {

		// Make theme available for translation.
		load_theme_textdomain( 'gauch', GAUCH_THEME_DIR. '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable support for Post Thumbnails on posts and pages.
		add_theme_support( 'post-thumbnails' );

		add_theme_support( 'yoast-seo-breadcrumbs' );

		// Gauch image size
		add_image_size( 'gauch_project_thumb', 860, 700, true );
		add_image_size( 'gauch_post_thumb', 750, 600, true );

		// WooCommerce support
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		// Switch default core markup for search form, comment form, and comments
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );
	}
endif;
add_action( 'after_setup_theme', 'gauch_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 */
function gauch_content_width() {
	// This variable is intended to be overruled from themes.
	$GLOBALS['content_width'] = apply_filters( 'gauch_content_width', 640 );
}
add_action( 'after_setup_theme', 'gauch_content_width', 0 );

/**
 * Enqueue scripts and styles.
 */
if ( ! function_exists( 'gauch_scripts' ) ) :

	function gauch_scripts() {
		global $gauch_opt;

		wp_enqueue_style( 'gauch-style', get_stylesheet_uri() );
		wp_style_add_data( 'gauch-style', 'rtl', 'replace' );

		wp_enqueue_style( 'bootstrap', 			GAUCH_CSS . '/bootstrap.min.css', null, GAUCH_VERSION );
		wp_enqueue_style( 'meanmenu', 			GAUCH_CSS . '/meanmenu.min.css', null, GAUCH_VERSION );
		wp_enqueue_style( 'remixicon', 			GAUCH_CSS . '/remixicon.css', null, GAUCH_VERSION );
		wp_enqueue_style( 'animate', 			GAUCH_CSS . '/animate.min.css', null, GAUCH_VERSION );
		wp_enqueue_style( 'owl-carousel', 		GAUCH_CSS . '/owl.carousel.min.css', null, GAUCH_VERSION );
		wp_enqueue_style( 'owl-theme-default', 	GAUCH_CSS . '/owl.theme.default.min.css', null, GAUCH_VERSION );
		wp_enqueue_style( 'odometer', 			GAUCH_CSS . '/odometer.min.css', null, GAUCH_VERSION );
		wp_enqueue_style( 'magnific-popup',     GAUCH_CSS . '/magnific-popup.min.css', null, GAUCH_VERSION );

		if( gauch_rtl() == true ):
			// WooCommerce CSS
			if ( class_exists( 'WooCommerce' ) ):
				wp_enqueue_style( 'gauch-woocommerce', GAUCH_CSS . '/rtl/woocommerce.css');
			endif;
			wp_enqueue_style( 'gauch-main', 	GAUCH_CSS . '/rtl/gauch-main.css', null, GAUCH_VERSION );
			wp_enqueue_style( 'gauch-responsive', 	GAUCH_CSS . '/rtl/gauch-responsive.css', null, GAUCH_VERSION );
			wp_enqueue_style( 'gauch-blog', 	    GAUCH_CSS . '/rtl/gauch-blog.css', null, GAUCH_VERSION );
		else:
			// WooCommerce CSS
			if ( class_exists( 'WooCommerce' ) ):
				wp_enqueue_style( 'gauch-woocommerce', GAUCH_CSS . '/woocommerce.css');
			endif;
			wp_enqueue_style( 'gauch-main', 	GAUCH_CSS . '/gauch-main.css', null, GAUCH_VERSION );
			wp_enqueue_style( 'gauch-responsive', 	GAUCH_CSS . '/gauch-responsive.css', null, GAUCH_VERSION );
			wp_enqueue_style( 'gauch-blog', 	    GAUCH_CSS . '/gauch-blog.css', null, GAUCH_VERSION );
		endif;
		// RTL CSS
		if( gauch_rtl() == true ):
			wp_enqueue_style( 'gauch-rtl', get_template_directory_uri() . '/style-rtl.css' );
		endif;

		wp_enqueue_script( 'bootstrap', 			GAUCH_JS . '/bootstrap.min.js', array('jquery'), GAUCH_VERSION );
		wp_enqueue_script( 'jquery-meanmenu', 		GAUCH_JS . '/jquery.meanmenu.js', array('jquery'), GAUCH_VERSION );
		wp_enqueue_script( 'owl-carousel', 			GAUCH_JS . '/owl.carousel.min.js', array('jquery'), GAUCH_VERSION );
		wp_enqueue_script( 'mixitup', 				GAUCH_JS . '/mixitup.min.js', array('jquery'), GAUCH_VERSION );
		wp_enqueue_script( 'jquery-appear', 		GAUCH_JS . '/jquery.appear.js', array('jquery'), GAUCH_VERSION );
		wp_enqueue_script( 'odometer', 				GAUCH_JS . '/odometer.min.js', array('jquery'), GAUCH_VERSION );
		wp_enqueue_script( 'wow', 					GAUCH_JS . '/wow.min.js', array('jquery'), GAUCH_VERSION );
		wp_enqueue_script( 'jquery-ajaxchimp', 		GAUCH_JS . '/jquery.ajaxchimp.min.js', array('jquery'), GAUCH_VERSION );
		wp_enqueue_script( 'apexcharts', 		    GAUCH_JS . '/apexcharts.min.js', array('jquery'), GAUCH_VERSION );
		wp_enqueue_script( 'jquery-magnific-popup', GAUCH_JS . '/jquery.magnific-popup.min.js', array('jquery'), GAUCH_VERSION );
		wp_enqueue_script( 'gauch-main', 			GAUCH_JS . '/gauch-main.js', array('jquery'), GAUCH_VERSION );

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}

endif;
add_action( 'wp_enqueue_scripts', 'gauch_scripts' );

if ( ! function_exists( 'gauch_fonts' ) ) {
	function gauch_fonts() {
		wp_enqueue_style( 'gauch-titillium-font', "//fonts.googleapis.com/css2?family=Titillium+Web:ital,wght@0,200;0,300;0,400;0,600;0,700;0,900;1,200;1,300;1,400;1,600;1,700&display=swap", '', '1.0.0', 'screen' );
		wp_enqueue_style( 'gauch-cabin-font', "//fonts.googleapis.com/css2?family=Cabin:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&display=swap", '', '1.0.0', 'screen' );
	}
}
add_action( 'wp_enqueue_scripts', 'gauch_fonts' );

/**
 * Custom template tags for this theme.
 */
require GAUCH_THEME_DIR. '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require GAUCH_THEME_DIR. '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require GAUCH_THEME_DIR. '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require GAUCH_THEME_DIR. '/inc/jetpack.php';
}

/**
 * Load bootstrap navwalker
 */
require GAUCH_THEME_DIR. '/inc/bootstrap-navwalker.php';

/**
 * Load theme widgets
 */
require GAUCH_THEME_DIR. '/inc/widget.php';

/**
 * Custom style
 */
require GAUCH_THEME_DIR. '/inc/custom-style.php';

/**
 * Social link
*/
require GAUCH_THEME_DIR. '/inc/social-link.php';

/**
 * Header Style
*/
require GAUCH_THEME_DIR. '/template-parts/header/style-1.php';

/**
 * Recommended plugin
*/
require GAUCH_THEME_DIR. '/lib/recommended-plugin.php';

/**
 * ACF meta filed
*/
require GAUCH_THEME_DIR. '/inc/acf.php';

// Load WooCommerce compatibility file.
if ( class_exists( 'WooCommerce' ) ):
	require GAUCH_THEME_DIR . '/inc/woocommerce.php';
endif;

/**
 * Filter the categories archive widget to add a span around post count
 */
if ( ! function_exists( 'gauch_cat_count_span' ) ) {
	function gauch_cat_count_span( $links ) {
		$links = str_replace( '</a> (', '</a><span class="post-count">(', $links );
		$links = str_replace( ')', ')</span>', $links );
		return $links;
	}
}
add_filter( 'wp_list_categories', 'gauch_cat_count_span' );

/**
 * Filter the archives widget to add a span around post count
 */
if ( ! function_exists( 'gauch_archive_count_span' ) ) {
	function gauch_archive_count_span( $links ) {
		$links = str_replace( '</a>&nbsp;(', '</a><span class="post-count">(', $links );
		$links = str_replace( ')', ')</span>', $links );
		return $links;
	}
}
add_filter( 'get_archives_link', 'gauch_archive_count_span' );

/**
 * Excerpt more text
 */
if ( ! function_exists( 'gauch_excerpt_more' ) ) :
	function gauch_excerpt_more( $more ) {
		return ' ';
	}
endif;
add_filter('excerpt_more', 'gauch_excerpt_more');

/**
 * If page edited by elementor
 */
if ( ! function_exists( 'gauch_is_elementor' ) ) :
	function gauch_is_elementor(){
		if ( function_exists( 'elementor_fail_php_version' ) ):
			global $post;
			return \Elementor\Plugin::$instance->documents->get($post->ID)->is_built_with_elementor();
		endif;
	}
endif;


/**
 * If page edited by elementor
 */
if ( ! function_exists( 'gauch_register_primary_menus' ) ) :
	function gauch_register_primary_menus(){
		register_nav_menus(
			array(
				'primary' 		=> esc_html__('Primary Menu', 'gauch'),
				'footer-menu' 	=> esc_html__( 'Footer Menu', 'gauch' ),
			)
		);
	}
endif;
add_action('init', 'gauch_register_primary_menus');

/**
 * Admin dashboard style and scripts
 */
add_action( 'admin_enqueue_scripts', function() {
    global $pagenow;
    wp_enqueue_script( 'gauch-admin', GAUCH_JS.'/gauch-admin.js', array('jquery'), '1.0.0', true );
    if ( $pagenow == 'admin.php' ) {
		wp_enqueue_style( 'gauch-admin-dashboard', GAUCH_CSS.'/admin-dashboard.min.css' );
    }
});

// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false', 100 );
// Disables the block editor from managing widgets. renamed from wp_use_widgets_block_editor
add_filter( 'use_widgets_block_editor', '__return_false' );
