<?php
/**
 * The template for displaying the footer
 * @package Gauch
 */

	/**
	 * Footer optional data
	 */
	global $gauch_opt;
	if( isset( $gauch_opt['copyright_text'] )):
		$copyright_text 		= $gauch_opt['copyright_text'];
		$enable_back_to_top 	= $gauch_opt['enable_back_to_top'];
	else:
		$copyright_text 		= '';
		$enable_back_to_top 	= true;
	endif;

	// Footer Class
	if ( is_active_sidebar( 'footer_widgets' ) ):
		$footer_class = 'footer-area footer-style-two pt-100';
	else:
		$footer_class = 'blank-footer';
	endif;


	// Main site logo
	if(isset($gauch_opt['main_logo']['url'])):
		$logo 	= $gauch_opt['main_logo']['url'];
	else:
		$logo	= '';
	endif;

	if( function_exists('acf_add_options_page') ) {
		$footer_style    = get_field( 'choose_footer_style' );
		if( is_home() ) {
			$post_page_id  = get_option( 'page_for_posts' );
			$footer_style    = get_field( 'choose_footer_style', $post_page_id);
		}
		
		if ( class_exists( 'WooCommerce' ) ){
			if( is_shop() ) {
				$post_page_id  = get_option( 'woocommerce_shop_page_id' );
				$footer_style    = get_field( 'choose_footer_style', $post_page_id);
			}
		}
	}else {
		$footer_style = 1;
	}

	$footer_shape     = isset( $gauch_opt['footer_shape']['url'] ) ? $gauch_opt['footer_shape']['url'] : '';
?>
	<?php if( $footer_style == 2 ) : ?>
		<footer class="footer-style-wrap-area">
			<div class="container">
				<div class="footer-widget-style-wrap">
					<a class="d-inline-block logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
						<?php if( $logo != '' ): ?>
							<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
						<?php else: ?>
							<h2><?php bloginfo( 'name' ); ?></h2>
						<?php endif; ?>
					</a>
					<?php
						if( has_nav_menu('footer-menu') ){
							$args = array(
								'theme_location' 	=> 'footer-menu',
								'menu'            	=> 'footer-menu',
								'container'       	=> 'ul',
								'fallback_cb'  		=> false,
								'menu_class'      	=> 'quick-links',
								'depth'           	=> 1,
							);
							wp_nav_menu( $args );
						}
						?>
					<ul class="social-links">
						<?php gauch_social_link(); ?>
					</ul>
				</div>
			</div>

			<?php if( $copyright_text != '' ){ ?>
				<div class="copyright-area">
					<div class="container">
						<?php if( $copyright_text != '' ){ ?>
							<p><?php echo wp_kses( $copyright_text, 'gauchallowedhtml' ); ?></p>
						<?php } ?>
					</div>
				</div>
			<?php } ?>
		</footer>
	<?php elseif( $footer_style == 3 ) : ?>
		<footer class="footer-style-wrap-area pt-100 with-black">
			<div class="container">
				<div class="footer-widget-style-wrap with-white-color">
					<a class="d-inline-block logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
						<?php if( $logo != '' ): ?>
							<img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
						<?php else: ?>
							<h2><?php bloginfo( 'name' ); ?></h2>
						<?php endif; ?>
					</a>
					<?php
						if( has_nav_menu('footer-menu') ){
							$args = array(
								'theme_location' 	=> 'footer-menu',
								'menu'            	=> 'footer-menu',
								'container'       	=> 'ul',
								'fallback_cb'  		=> false,
								'menu_class'      	=> 'quick-links',
								'depth'           	=> 1,
							);
							wp_nav_menu( $args );
						}
					?>
					<ul class="social-links">
						<?php gauch_social_link(); ?>
					</ul>
				</div>
			</div>

			<?php if( $copyright_text != '' ){ ?>
				<div class="copyright-area with-white-color">
					<div class="container">
						<?php if( $copyright_text != '' ){ ?>
							<p><?php echo wp_kses( $copyright_text, 'gauchallowedhtml' ); ?></p>
						<?php } ?>
					</div>
				</div>
			<?php } ?>

			<?php if( $footer_shape != ''  ) : ?>
				<div class="footer-style-wrap-shape">
					<img src="<?php echo esc_url( $footer_shape ); ?> " alt="<?php echo esc_attr__('shape','gauch'); ?>">
				</div>
			<?php endif; ?>
		</footer>
	<?php else: ?>
		<?php if( $footer_class != 'blank-footer' ): ?>
			<footer class="<?php echo esc_attr( $footer_class ); ?>">
				<div class="container">
					<div class="row justify-content-cente">
						<?php if ( is_active_sidebar( 'footer_widgets') ) : ?>
							<?php dynamic_sidebar( 'footer_widgets' ); ?>
						<?php endif; ?>
					</div>
				</div>
				<?php if( has_nav_menu('footer-menu') ){ ?>
					<div class="copyright-area">
						<div class="container">
							<div class="row align-items-center">
								<div class="col-lg-6 col-sm-6 col-md-6">
									<?php if( $copyright_text != '' ){ ?>
										<p><?php echo wp_kses( $copyright_text, 'gauchallowedhtml' ); ?></p>
									<?php } ?>
								</div>
								<div class="col-lg-6 col-sm-6 col-md-6">
									<?php
									if( has_nav_menu('footer-menu') ){
										$args = array(
											'theme_location' 	=> 'footer-menu',
											'menu'            	=> 'footer-menu',
											'container'       	=> 'ul',
											'fallback_cb'  		=> false,
											'menu_class'      	=> 'menu',
											'depth'           	=> 1,
										);
										wp_nav_menu( $args );
									}
									?>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
			</footer>
		<?php else: ?>
			<div class="copyright-area mt-1px">
				<div class="container">
					<div class="row align-items-center">
						<div class="col-lg-12 col-sm-12 col-md-12">
							<?php if( isset( $gauch_opt['copyright_text'] )){ ?>
								<?php if( $copyright_text != '' ){ ?>
									<p><?php echo wp_kses( $copyright_text, 'gauchallowedhtml' ); ?></p>
									<?php } ?>
							<?php }else{ ?>
								<p>
								<?php
								printf(
									/* translators: %s: HiboTheme. */
									esc_html__( 'Copyright @2022 Gauch. All Rights Reserved by  %s.', 'gauch' ),
									'<a target="_blank" href="' . esc_url( __( 'https://themes.hibotheme.com/gauch/', 'gauch' ) ) . '">HiboTheme</a>'
								);
								?>
							</p>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>
	<?php endif; ?>

	<?php if( $enable_back_to_top == true ):?>
		<div class="go-top">
            <i class="ri-arrow-up-s-line"></i>
        </div>
	<?php endif; ?>
	
<?php wp_footer(); ?>

</body>
</html>