<?php
/**
 * Team Widget
 */
namespace Elementor;
class Gauch_Team extends Widget_Base{
    public function get_name(){
        return "Gauch_Team";
    }
    public function get_title(){
        return "Team";
    }
    public function get_icon(){
        return "eicon-gallery-group";
    }
    public function get_categories(){
        return ['gauch-elements'];
    }
    protected function register_controls(){

    $this->start_controls_section(
        'Gauch_Team',
        [
            'label' => __( 'Gauch Team', 'gauch-toolkit' ),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]
    );

        $this->add_control(
            'sec_style',
            [
                'label' => __( 'Style', 'gauch-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1'   => __( 'Style 1', 'gauch-toolkit' ),
                    '2'   => __( 'Style 2', 'gauch-toolkit' ),
                ],
                'default' => '1',
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'gauch-toolkit' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    2   => __( '2', 'gauch-toolkit' ),
                    3   => __( '3', 'gauch-toolkit' ),
                    4   => __( '4', 'gauch-toolkit' ),
                ],
                'default' => 4,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'member_img',
            [
                'label' => esc_html__( 'Image', 'gauch-toolkit' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'name',
            [
                'label' => esc_html__( 'Member Name', 'gauch-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'designation',
            [
                'label' => esc_html__( 'Designation', 'gauch-toolkit' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'icon1',
            [
                'label' => esc_html__( 'Social Icon One', 'gauch-toolkit' ),
                'type' => Controls_Manager::ICON,
				'label_block' => true,
				'options' => gauch_icons(),
            ]
        );
        $repeater->add_control(
            'url1',
            [
                'label' => esc_html__( 'Social Link One', 'gauch-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $repeater->add_control(
            'icon2',
            [
                'label' => esc_html__( 'Social Icon Two', 'gauch-toolkit' ),
                'type' => Controls_Manager::ICON,
				'label_block' => true,
				'options' => gauch_icons(),
            ]
        );
        $repeater->add_control(
            'url2',
            [
                'label' => esc_html__( 'Social Link Two', 'gauch-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $repeater->add_control(
            'icon3',
            [
                'label' => esc_html__( 'Social Icon Three', 'gauch-toolkit' ),
                'type' => Controls_Manager::ICON,
				'label_block' => true,
				'options' => gauch_icons(),
            ]
        );
        $repeater->add_control(
            'url3',
            [
                'label' => esc_html__( 'Social Link Three', 'gauch-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $repeater->add_control(
            'icon4',
            [
                'label' => esc_html__( 'Social Icon Four', 'gauch-toolkit' ),
                'type' => Controls_Manager::ICON,
				'label_block' => true,
				'options' => gauch_icons(),
            ]
        );
        $repeater->add_control(
            'url4',
            [
                'label' => esc_html__( 'Social Link Four', 'gauch-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $repeater->add_control(
            'icon5',
            [
                'label' => esc_html__( 'Social Icon Five', 'gauch-toolkit' ),
                'type' => Controls_Manager::ICON,
				'label_block' => true,
				'options' => gauch_icons(),
            ]
        );
        $repeater->add_control(
            'url5',
            [
                'label' => esc_html__( 'Social Link Five', 'gauch-toolkit' ),
                'type' => Controls_Manager::URL,
            ]
        );

        $this->add_control(
            'teams',
            [
                'label' => esc_html__( 'Add Member', 'gauch-toolkit' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

    $this-> end_controls_section();

    // Start Style content controls
    $this-> start_controls_section(
        'style',
        [
            'label'=>esc_html__('Style', 'gauch-toolkit'),
            'tab'=> Controls_Manager::TAB_STYLE,
        ]
    );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__( 'Member Name Color', 'gauch-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-team-member2 .content h3, .team-member-card .team-content h3' => 'color: {{VALUE}}',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'name_size',
				'label' => __( 'Name Typography', 'gauch-toolkit' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single-team-member2 .content h3, .team-member-card .team-content h3',
			]
		);

        $this->add_control(
            'designation_color',
            [
                'label' => esc_html__( 'Member Designation Color', 'gauch-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-team-member2 .content span, .team-member-card .team-content span' => 'color: {{VALUE}}',
                ],
            ]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'designation_size',
				'label' => __( 'Designation Typography', 'gauch-toolkit' ),
				'scheme' => Core\Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single-team-member2 .content span, .team-member-card .team-content span',
			]
		);
    $this-> end_controls_section();
}
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $columns = $settings['columns'];
        if ( $columns == 2 ) {
            $column = 'col-lg-6 col-md-6';
        } elseif ( $columns == 4 ) {
            $column = 'col-lg-3 col-md-6';
        } else {
            $column = 'col-lg-4 col-md-6';
        }

        ?>

        <?php if($settings['sec_style'] == '1'): ?>
            <div class="container">
                <div class="row">
                    <?php foreach( $settings['teams'] as $item ): ?>
                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="single-team-member2">
                                <div class="image">
                                    <?php if( $item['member_img']['url'] != '' ): ?>
                                        <img src="<?php echo esc_url( $item['member_img']['url'] ); ?>" alt="<?php echo esc_attr( $item['name'] ); ?>">
                                    <?php endif; ?>
                                </div>

                                <div class="content">
                                    <h3><?php echo esc_html( $item['name'] ); ?></h3>
                                    <span><?php echo esc_html( $item['designation'] ); ?></span>
                                </div>

                                <ul class="social-links">
                                    <?php if( $item['icon1'] != '' && $item['url1']['url'] != '' ): ?>
                                        <li><a class="d-block" href="<?php echo esc_url( $item['url1']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon1'] ); ?>"></i></a></li>
                                    <?php endif; ?>

                                    <?php if( $item['icon2'] != '' && $item['url2']['url'] != '' ): ?>
                                        <li><a class="d-block" href="<?php echo esc_url( $item['url2']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon2'] ); ?>"></i></a></li>
                                    <?php endif; ?>

                                    <?php if( $item['icon3'] != '' && $item['url3']['url'] != '' ): ?>
                                        <li><a class="d-block" href="<?php echo esc_url( $item['url3']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon3'] ); ?>"></i></a></li>
                                    <?php endif; ?>

                                    <?php if( $item['icon4'] != '' && $item['url4']['url'] != '' ): ?>
                                        <li><a class="d-block" href="<?php echo esc_url( $item['url4']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon4'] ); ?>"></i></a></li>
                                    <?php endif; ?>
                                    <?php if( $item['icon5']
                                        != '' && $item['url5']['url'] != '' ): ?>
                                        <li><a class="d-block" href="<?php echo esc_url( $item['url5']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon5'] ); ?>"></i></a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php else: ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php foreach( $settings['teams'] as $item ): ?>
                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="team-member-card">
                                <div class="team-image">
                                    <?php if( $item['member_img']['url'] != '' ): ?>
                                        <img src="<?php echo esc_url( $item['member_img']['url'] ); ?>" alt="<?php echo esc_attr( $item['name'] ); ?>">
                                    <?php endif; ?>
                                    <div class="social-btn">
                                        <span><i class="ri-share-line"></i></span>
                                        <ul>
                                            <?php if( $item['icon1'] != '' && $item['url1']['url'] != '' ): ?>
                                                <li><a href="<?php echo esc_url( $item['url1']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon1'] ); ?>"></i></a></li>
                                            <?php endif; ?>

                                            <?php if( $item['icon2'] != '' && $item['url2']['url'] != '' ): ?>
                                                <li><a href="<?php echo esc_url( $item['url2']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon2'] ); ?>"></i></a></li>
                                            <?php endif; ?>

                                            <?php if( $item['icon3'] != '' && $item['url3']['url'] != '' ): ?>
                                                <li><a href="<?php echo esc_url( $item['url3']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon3'] ); ?>"></i></a></li>
                                            <?php endif; ?>

                                            <?php if( $item['icon4'] != '' && $item['url4']['url'] != '' ): ?>
                                                <li><a href="<?php echo esc_url( $item['url4']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon4'] ); ?>"></i></a></li>
                                            <?php endif; ?>
                                            <?php if( $item['icon5']
                                                != '' && $item['url5']['url'] != '' ): ?>
                                                <li><a href="<?php echo esc_url( $item['url5']['url'] ); ?>"><i class="<?php echo esc_attr( $item['icon5'] ); ?>"></i></a></li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>

                                <div class="team-content">
                                    <h3><?php echo esc_html( $item['name'] ); ?></h3>
                                    <span><?php echo esc_html( $item['designation'] ); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>

    <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Team );