<?php
/**
 * Team Widget
 */

namespace Elementor;
class Gauch_Team_Two extends Widget_Base {

	public function get_name() {
        return 'Gauch_Team_Two';
    }

	public function get_title() {
        return __( 'Team Two', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Team_Area',
			[
				'label' => __( 'Team Controls', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'top_title',
				[
					'label'   => __( 'Top Title', 'gauch-toolkit' ),
					'type'    => Controls_Manager::TEXT,
					'default' => __('OUR EXPERTS', 'gauch-toolkit'),
				]
			);

			$this->add_control(
                'title_tag',
                [
                    'label' 	=> esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );

			$this->add_control(
				'title',
				[
					'label'       => __( 'Title', 'gauch-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default'     => __('Meet Our Leadership
                    Preparing For Your Success', 'gauch-toolkit'),
                    'label_block' => true,
				]
			);

			$this->add_control(
				'content',
				[
					'label'       => __( 'Content', 'gauch-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default'     => __('It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.', 'gauch-toolkit'),
                    'label_block' => true,
				]
			);

			$this->add_control(
				'button_text',
				[
					'label'   => __( 'Button Text', 'gauch-toolkit' ),
					'type'    => Controls_Manager::TEXT,
					'default' => __('Meet Our Team', 'gauch-toolkit'),
                    'label_block' => true,
				]
			);

			$this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'gauch-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'gauch-toolkit' ),
                    ],
                ]
            );

            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> gauch_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );

			$this->add_control(
				'bg_image',
				[
					'label' => __( 'Section Background Image', 'gauch-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);

            $repeater = new Repeater();

            $repeater->add_control(
                'member_img',
                [
                    'label' => esc_html__( 'Image', 'gauch-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'name',
                [
                    'label' => esc_html__( 'Member Name', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );

            $repeater->add_control(
                'designation',
                [
                    'label' => esc_html__( 'Designation', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );

            $this->add_control(
                'teams',
                [
                    'label' => esc_html__( 'Add Member', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );


        $this->end_controls_section();

        $this->start_controls_section(
			'team_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'top_title_color',
				[
					'label'     => __( 'Top Title Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .team-section-title .sub-title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .team-section-title .sub-title',
                ]
            );

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .team-section-title h1, .team-section-title h2, .team-section-title h3, .team-section-title h4, .team-section-title h5, .team-section-title h6' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .team-section-title h1, .team-section-title h2, .team-section-title h3, .team-section-title h4, .team-section-title h5, .team-section-title h6',
                ]
            );

			$this->add_control(
				'btn_text_color',
				[
					'label'     => __( 'Button Text Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .team-section-title .default-btn, .default-btn.style-two' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .team-section-title .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_hover_bg_color',
				[
					'label'     => __( 'Button Hover Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .team-section-title .default-btn:hover' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .team-section-title .default-btn',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

		// Get Button Link
        if( $settings['link_type'] == 1 ){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
		$this-> add_inline_editing_attributes('content','none');
		?>
        <div class="team-area bg-gradient-image ptb-100"  style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="team-member-list">
                            <div class="row justify-content-center">
                                <?php foreach( $settings['teams'] as $item ): ?>
                                    <div class="col-lg-6 col-md-6 col-sm-6">
                                        <div class="single-team-member">
                                            <?php if( $item['member_img']['url'] != '' ): ?>
                                                <img src="<?php echo esc_url( $item['member_img']['url'] ); ?>" alt="<?php echo esc_attr( $item['name'] ); ?>">
                                            <?php endif; ?>
                                            <div class="content">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <h3><?php echo esc_html( $item['name'] ); ?></h3>
                                                    <span><?php echo esc_html( $item['designation'] ); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12">
                        <div class="team-section-title">
                            <?php if($settings['top_title']): ?>
                                <span class="sub-title"><?php echo esc_html($settings['top_title']); ?></span>
                            <?php endif; ?>
                            <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>>
                                <?php echo esc_html( $settings['title'] ); ?>
                            </<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <p><?php echo wp_kses_post( $settings['content'] ); ?></p>

                            <?php if( $settings['button_text'] ): ?>
                                <a href="<?php echo esc_url( $link ); ?>" class="default-btn style-two"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $settings['button_text'] ); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Team_Two );