<?php
/**
 * Project Details Widget
 */

namespace Elementor;
class Gauch_Project_Details extends Widget_Base {

	public function get_name() {
        return 'Project_Details';
    }

	public function get_title() {
        return __( 'Project Details', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Project_Details',
			[
				'label' => __( 'Gauch Section', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'short_content',
                [
                    'label' => __( 'Short Content', 'gauch-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'default' => __('It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 'gauch-toolkit'),
                ]
            );

            $list_items = new Repeater();

            $list_items->add_control(
                'title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Title', 'gauch-toolkit' ),
                    'default' => __('THE CHALLENGE', 'gauch-toolkit'),
                ]
            );
            $list_items->add_control(
                'content',
                [
                    'type'    => Controls_Manager::WYSIWYG,
                    'label'   => __( 'Content', 'gauch-toolkit' ),
                ]
            );

            $this->add_control(
                'items',
                [
                    'label'   => __( 'Add List Item', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $link   = get_the_permalink();

        $idd    = get_the_ID();
        $terms  = wp_get_post_terms(get_the_ID(), 'project_cat');

        $output = array();

        // ACF Fields
        $icon               = get_field('service_icon_image');
        $content            = get_field('services_card_content');
        $framework_label    = get_field('framework_label');
        $framework_value    = get_field('framework_value');
        $category_label     = get_field('category_label');
        $category_value     = get_field('category_value');
        $web_link_label     = get_field('web_link_label');
        $web_link_value     = get_field('web_link_value');

        if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
            $post_link = get_the_permalink();
        } else {
            $post_link = get_field('external_link');
        }
        ?>
        <div class="case-studies-details-area ptb-100">
            <div class="container">
                <div class="case-studies-details-header row align-items-center justify-content-center">
                    <div class="col-lg-6 col-md-12">
                        <?php if(has_post_thumbnail()): ?>
                            <div class="image">
                                <img src="<?php echo get_the_post_thumbnail_url(get_the_ID()); ?>" alt="<?php the_post_thumbnail_caption(); ?>">
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-6 col-md-12">
                        <div class="content">
                            <?php if($icon): ?>
                                <img src="<?php echo esc_url($icon); ?>" alt="<?php the_post_thumbnail_caption();  ?>">
                            <?php endif; ?>
                            <h1><?php the_title(); ?></h1>

                            <?php echo wp_kses_post($settings['short_content']); ?>

                            <ul class="meta">

                                <?php if($framework_label): ?>
                                    <li>
                                        <i class="ri-folder-2-line"></i>
                                        <span><?php echo esc_html($framework_label); ?></span>
                                        <a href="<?php echo esc_url( $post_link ); ?>"><?php echo esc_html($framework_value); ?></a>
                                    </li>
                                <?php endif; ?>

                                <?php if($category_label): ?>
                                    <li>
                                        <i class="ri-price-tag-3-line"></i>
                                        <span><?php echo esc_html($category_label); ?></span>
                                        <a href="<?php echo esc_url( $post_link ); ?>"><?php echo esc_html($category_value); ?></a>
                                    </li>
                                <?php endif; ?>
                                <?php if($web_link_label): ?>
                                    <li>
                                        <i class="ri-global-line"></i>
                                        <span><?php echo esc_html($web_link_label); ?></span>
                                        <a href="<?php echo esc_url( $web_link_value ); ?>"><?php echo esc_html($web_link_value); ?></a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="case-studies-details-desc">
                    <div class="article-content">
                        <?php $i = 1; foreach( $settings['items'] as $item ): ?>
                            <div class="row mb-40">
                                <div class="col-lg-5 col-md-12">
                                    <h2><span><?php echo esc_html($item['title']) ?></span></h2>
                                </div>
                                <div class="col-lg-7 col-md-12">
                                    <div class="content">
                                        <?php echo wp_kses_post($item['content']) ?>
                                    </div>
                                </div>
                            </div>
                        <?php $i++; endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}


}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Project_Details );