<?php
/**
 * Process Widget
 */

namespace Elementor;
class Gauch_Process extends Widget_Base {

	public function get_name() {
        return 'GauchProcess';
    }

	public function get_title() {
        return __( 'Process Area', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'gauch-toolkit' ),
                'type'  => Controls_Manager::SELECT,
                'options' => [
                    '1'   => __( 'Style 1', 'gauch-toolkit' ),
                    '2'   => __( 'Style 2', 'gauch-toolkit' ),
                ],
                'default' => '1',
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'gauch-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => __( 'Choose Columns', 'gauch-toolkit' ),
                'type'  => Controls_Manager::SELECT,
                'options' => [
                    '2'   => __( '2', 'gauch-toolkit' ),
                    '3'   => __( '3', 'gauch-toolkit' ),
                    '4'   => __( '4', 'gauch-toolkit' ),
                ],
                'default' => '3',
            ]
        );

        $list_items = new Repeater();

        $list_items->add_control(
            'image',
            [
                'label' => __( 'Image', 'gauch-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $list_items->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'gauch-toolkit'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Select Your Service', 'gauch-toolkit'),
                'label_block' => true,
            ]
        );
        $list_items->add_control(
            'content',
            [
                'label' => esc_html__('Content', 'gauch-toolkit'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna.', 'gauch-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'items',
            [
                'label' => esc_html__('List Item', 'gauch-toolkit'),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [ 'name' => esc_html__(' Item #1', 'gauch-toolkit') ],

                ],
                'fields' => $list_items->get_controls(),
            ]
        );
    $this->end_controls_section();

    $this->start_controls_section(
        'section_style',
        [
            'label' => esc_html__( 'Style', 'gauch-toolkit' ),
            'tab' => Controls_Manager::TAB_STYLE,
        ]
    );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'gauch-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-process-box h3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __( 'Title Typography', 'gauch-toolkit' ),
                'selector' => '{{WRAPPER}} .single-process-box h3',
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__( 'Content Color', 'gauch-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-process-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __( 'Content Typography', 'gauch-toolkit' ),
                'selector' => '{{WRAPPER}} .single-process-box p',
            ]
        );
    $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Card Columns
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-sm-6 col-md-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-sm-6 col-md-6';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-sm-6 col-md-6';
        }

        $items = $settings['items'];

        if($settings['style'] == '1'):
            ?>
            <div class="container">
                <div class="process-inner" style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
                    <div class="row justify-content-center">
                        <?php foreach ( $items as $key => $value ) { ?>
                            <div class="<?php echo esc_attr( $column ); ?>">
                                <div class="single-process-box">
                                    <?php if( $value['image']['url'] != '' ): ?>
                                        <div class="icon">
                                            <img src="<?php echo esc_url( $value['image']['url'] ); ?>" alt="<?php echo esc_attr( $value['title'] ) ?>">
                                        </div>
                                    <?php endif; ?>

                                    <h3><?php echo esc_html( $value['title'] ); ?></h3>
                                    <p> <?php echo wp_kses_post( $value['content'] ); ?></p>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        <?php
        elseif($settings['style'] == '2'):
            ?>
            <div class="process-area" style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
                <div class="container">
                    <div class="process-inner bg-color">
                        <div class="row justify-content-center">
                            <?php foreach ( $items as $key => $value ) { ?>
                                <div class="<?php echo esc_attr( $column ); ?>">
                                    <div class="single-process-box">
                                        <?php if( $value['image']['url'] != '' ): ?>
                                            <div class="icon">
                                                <img src="<?php echo esc_url( $value['image']['url'] ); ?>" alt="<?php echo esc_attr( $value['title'] ) ?>">
                                            </div>
                                        <?php endif; ?>

                                        <h3><?php echo esc_html( $value['title'] ); ?></h3>
                                        <p> <?php echo wp_kses_post( $value['content'] ); ?></p>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        endif;
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Process );