<?php
/**
 * Pre Token Sale Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_PreTokenSale extends Widget_Base {

	public function get_name() {
        return 'Gauch_PreTokenSale';
    }

	public function get_title() {
        return esc_html__( 'Token Sale Area', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-image-rollover';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Features_Info',
			[
				'label' => esc_html__( 'Token Info', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            // $this->add_control(
            //     'choose_style',
            //     [
            //         'label' => __( 'Choose Style', 'gauch-toolkit' ),
            //         'type'  => Controls_Manager::SELECT,
            //         'options' => [
            //             '1'   => __( 'Style 1', 'gauch-toolkit' ),
            //             '2'   => __( 'Style 2', 'gauch-toolkit' ),
            //         ],
            //         'default' => '1',
            //     ]
            // );

            $this->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'gauch-toolkit' ),
                    'default' => esc_html__( 'Pre Token Sale Ends', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );

            $this->add_control(
                'gauch_due_date',
                [
                    'label' => __( 'Due Date', 'gauch' ),
                    'type' => Controls_Manager::DATE_TIME,
                    'default' => date( 'Y-m-d H:i', strtotime( '+1 month' ) + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) ),
                    'description' => sprintf( __( 'Date set according to your timezone: %s.', 'gauch' ), Utils::get_timezone_string() ),
                    
                ]
            );
            $this->add_control(
                'date', [
                    'label'       => __( 'Day Text', 'gauch-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __( 'Days' , 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'hours', [
                    'label'       => __( 'Hours Text', 'gauch-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __( 'Hours' , 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'minutes', [
                    'label'       => __( 'Minutes Text', 'gauch-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __( 'Minutes' , 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'seconds', [
                    'label'       => __( 'Seconds Text', 'gauch-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => __( 'Seconds' , 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );

			$this->add_control(
                'right_img',
                [
                    'label' => esc_html__( 'Image', 'gauch-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                ]
            );
			$this->add_control(
                'shape',
                [
                    'label' => esc_html__( 'Shape', 'gauch-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'total_amount',
                [
                    'label'   => esc_html__( 'Amount', 'gauch-toolkit' ),
                    'default' => esc_html__( 'Pre sale total amount 1 ETH = $2,537.37', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'left_label',
                [
                    'label'   => esc_html__( 'Left Label', 'gauch-toolkit' ),
                    'default' => esc_html__( 'Softcap', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'reached_label',
                [
                    'label'   => esc_html__( 'Reached Label', 'gauch-toolkit' ),
                    'default' => esc_html__( '$5', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'goal_label',
                [
                    'label'   => esc_html__( 'Goal Label', 'gauch-toolkit' ),
                    'default' => esc_html__( '$50', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'right_label',
                [
                    'label'   => esc_html__( 'Right Label', 'gauch-toolkit' ),
                    'default' => esc_html__( 'Hardcap', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'progress_per',
                [
                    'label'   => esc_html__( 'Progress Percentage', 'gauch-toolkit' ),
                    'default' => '75',
                    'type' => Controls_Manager::TEXT,
                ]
            );

            // Button One
			$this->add_control(
				'button_text',
				[
					'label'   => __( 'Button Text', 'gauch-toolkit' ),
					'type'    => Controls_Manager::TEXT,
					'default' => __('Buy Token', 'gauch-toolkit'),
                    'label_block' => true,
				]
			);
			$this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'gauch-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'gauch-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> gauch_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );
            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
            $this->add_control(
                'purchase_text',
                [
                    'label'		=> esc_html__('Purchase Text', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'default' => __('Minimum Purchase: 10 ICO Token', 'gauch-toolkit'),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'title_color',
                [
                    'label'     => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pre-token-sale-ends-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .pre-token-sale-ends-content h3',
                ]
            );

            $this->add_control(
                'counter_text_color',
                [
                    'label'     => esc_html__( 'Counter Text Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pre-token-sale-ends-content #timer div' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label'     => esc_html__( 'Content Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pre-token-sale-ends-content p, .pre-token-sale-ends-content .pre-token-sale-ends-with-progress .bottom-list li, .pre-token-sale-ends-content .pre-token-sale-ends-btn li, .pre-token-sale-ends-content #timer div span' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .pre-token-sale-ends-content p, .pre-token-sale-ends-content .pre-token-sale-ends-with-progress .bottom-list li, .pre-token-sale-ends-content .pre-token-sale-ends-btn li, .pre-token-sale-ends-content #timer div span',
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $cs_date =  $settings['gauch_due_date'];
        $cs_date =  preg_replace('/-/', '/', $cs_date);

        if( $settings['link_type'] == 1 ){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        } 
        ?>

        <div class="pre-token-sale-ends-area pb-100">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="pre-token-sale-ends-content">
                            <h3><?php echo esc_html( $settings['title'] ); ?></h3>
                            <div id="timer" class="flex-wrap d-flex justify-content-center">
                                <div id="days" class="align-items-center flex-column d-flex justify-content-center"></div>
                                <div id="hours" class="align-items-center flex-column d-flex justify-content-center"></div>
                                <div id="minutes" class="align-items-center flex-column d-flex justify-content-center"></div>
                                <div id="seconds" class="align-items-center flex-column d-flex justify-content-center"></div>
                            </div>


                            <p><?php echo esc_html( $settings['total_amount'] ); ?></p>
                            <div class="pre-token-sale-ends-with-progress">
                                <ul class="top-list d-flex justify-content-between align-items-center">
                                    <li><?php echo esc_html( $settings['reached_label'] ); ?></li>
                                    <li><?php echo esc_html( $settings['goal_label'] ); ?></li>
                                </ul>
                                <div class="progress-wrapper">
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" style="width: <?php echo esc_attr( $settings['progress_per'] ); ?>%" aria-valuenow="<?php echo esc_attr( $settings['progress_per'] ); ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                <ul class="bottom-list d-flex justify-content-between align-items-center">
                                    <li><?php echo esc_html( $settings['left_label'] ); ?></li>
                                    <li><?php echo esc_html( $settings['right_label'] ); ?></li>
                                </ul>
                            </div>
                            <ul class="pre-token-sale-ends-btn">
                                <?php if( $settings['button_text'] ): ?>
                                    <li>
                                        <a href="<?php echo esc_url( $link ); ?>" class="buy-token-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
                                    </li>
                                <?php endif; ?>
                                <li><?php echo esc_html( $settings['purchase_text'] ); ?></li>
                            </ul>

                            <?php if( $settings['shape']['url'] != '' ): ?>
                                <div class="pre-token-sale-ends-shape">
                                    <img src="<?php echo esc_url( $settings['shape']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'gauch-toolkit'); ?>">
                                </div> 
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php if( $settings['right_img']['url'] != '' ): ?>
                    <div class="col-lg-6 col-md-12">
                        <div class="pre-token-sale-ends-image">
                            <img src="<?php echo esc_url( $settings['right_img']['url'] ); ?>" alt="<?php echo esc_attr__('image', 'gauch-toolkit'); ?>">
                        </div>
                    </div> 
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <script>
            (function($){
            "use strict";
                $( window ).on( 'elementor/frontend/init', function() {
                    elementorFrontend.hooks.addAction( 'frontend/element_ready/Gauch_PreTokenSale.default', function($scope, $){
                        // Count Time 
                        function makeTimer() {
                            var endTime = new Date("<?php echo $cs_date; ?>");	

                            var endTime = (Date.parse(endTime)) / 1000;
                            var now = new Date();
                            var now = (Date.parse(now) / 1000);
                            var timeLeft = endTime - now;
                            var days = Math.floor(timeLeft / 86400); 
                            var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
                            var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600 )) / 60);
                            var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));
                            if (hours < "10") { hours = "0" + hours; }
                            if (minutes < "10") { minutes = "0" + minutes; }
                            if (seconds < "10") { seconds = "0" + seconds; }
                            $("#days").html(days + "<span><?php echo esc_html( $settings['date'] ); ?></span>");
                            $("#hours").html(hours + "<span><?php echo esc_html( $settings['hours'] ); ?></span>");
                            $("#minutes").html(minutes + "<span><?php echo esc_html( $settings['minutes'] ); ?></span>");
                            $("#seconds").html(seconds + "<span><?php echo esc_html( $settings['seconds'] ); ?></span>");
                        }
                        setInterval(function() { makeTimer(); }, 300);
                        });

                });  

                if( typeof elementorFrontend !== 'undefined'  ){
                    elementorFrontend.hooks.addAction( 'frontend/element_ready/Gauch_PreTokenSale.default', function($scope, $){
                        // Count Time 
                        function makeTimerLive() {
                            var endTime = new Date("<?php echo $cs_date; ?>");

                            var endTime = (Date.parse(endTime)) / 1000;
                            var now = new Date();
                            var now = (Date.parse(now) / 1000);
                            var timeLeft = endTime - now;
                            var days = Math.floor(timeLeft / 86400); 
                            var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
                            var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600 )) / 60);
                            var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));
                            if (hours < "10") { hours = "0" + hours; }
                            if (minutes < "10") { minutes = "0" + minutes; }
                            if (seconds < "10") { seconds = "0" + seconds; }
                            
                            $("#days").html(days + "<span><?php echo esc_html( $settings['date'] ); ?></span>");
                            $("#hours").html(hours + "<span><?php echo esc_html( $settings['hours'] ); ?></span>");
                            $("#minutes").html(minutes + "<span><?php echo esc_html( $settings['minutes'] ); ?></span>");
                            $("#seconds").html(seconds + "<span><?php echo esc_html( $settings['seconds'] ); ?></span>");
                        }
                        setInterval(function() { makeTimerLive(); }, 300);
                    });
                }
            
            }(jQuery));

        </script>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_PreTokenSale );