<?php
namespace Elementor;
class Gauch_Post_Area extends Widget_Base{
    public function get_name(){
        return "Gauch_Post";
    }
    public function get_title(){
        return "Posts";
    }
    public function get_icon(){
        return "eicon-post-list";
    }
    public function get_categories(){
        return [ 'gauch-elements' ];
    }
    protected function register_controls(){

        $this-> start_controls_section(
            'layout_section',
            [
                'label' => __('Posts Content', 'gauch-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

            $this->add_control(
                'style',
                [
                    'label' => __( 'Style', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style 1', 'gauch-toolkit' ),
                        '2'   => __( 'Style 2', 'gauch-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'columns',
                [
                    'label' => __( 'Choose Columns', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        2   => __( '2', 'gauch-toolkit' ),
                        3   => __( '3', 'gauch-toolkit' ),
                        4   => __( '4', 'gauch-toolkit' ),
                    ],
                    'default' => 3,
                ]
            );
            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'teciva-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => gauch_toolkit_get_post_cat_list(),
                ]
            );
            $this->add_control(
                'post_title_size',
                [
                    'label'   => __( 'Post Title Heading Tag', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'h1' => 'H1',
                        'h2' => 'H2',
                        'h3' => 'H3',
                        'h4' => 'H4',
                        'h5' => 'H5',
                        'h6' => 'H6',
                    ],
                    'default' => 'h3',
                ]
            );
            $this->add_control(
                'excerpt', [
                    'label'       => __( 'Excerpt Character Limit', 'gauch-toolkit' ),
                    'description' => __( 'Leave the field empty to show the full excerpt. And if excerpt not found in a post, then the excerpt will take from the post content.', 'gauch-toolkit' ),
                    'type'        => Controls_Manager::NUMBER,
                    'default'     => '24',
                ]
            );
            $this->add_control(
                'count',
                [
                    'label'       => __( 'Show Post Count', 'gauch-toolkit' ),
                    'default'     => __( '3', 'gauch-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'description' => __('if you went to see all post type -1','gauch-toolkit')
                ]
            );

            $this->add_control(
                'order',
                [
                    'label'   => __( 'Select Order', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'  => __( 'DESC', 'gauch-toolkit' ),
                        'ASC'   => __( 'ASC', 'gauch-toolkit' ),
                    ],
                    'default'   => 'DESC',
                ]
            );

            $this->add_control(
                'by_text',
                [
                    'label'       => __( 'By Text', 'gauch-toolkit' ),
                    'default'     => __( 'By ', 'gauch-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'condition'   => [
                        'style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'read_more_text',
                [
                    'label'       => __( 'Read More', 'gauch-toolkit' ),
                    'default'     => __( 'Read More', 'gauch-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'condition'   => [
                        'style' => '1',
                    ]
                ]
            );
        $this-> end_controls_section();

        // Start Style content controls
        $this-> start_controls_section(
            'heading_style',
            [
                'label' => __('Posts Style', 'gauch-toolkit'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-post .content h3 a, .single-blog-post .content h2 a, .single-blog-post .content h1 a, .single-blog-post .content h4 a, .single-blog-post .content h5 a, .single-blog-post .content h6 a, .blog-style-card .blog-content h3 a, .blog-style-card .blog-content h1 a, .blog-style-card .blog-content h2 a, .blog-style-card .blog-content h4 a, .blog-style-card .blog-content h5 a, .blog-style-card .blog-content h6 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-blog-post .content h3 a, .single-blog-post .content h2 a, .single-blog-post .content h1 a, .single-blog-post .content h4 a, .single-blog-post .content h5 a, .single-blog-post .content h6 a, .blog-style-card .blog-content h3 a, .blog-style-card .blog-content h1 a, .blog-style-card .blog-content h2 a, .blog-style-card .blog-content h4 a, .blog-style-card .blog-content h5 a, .blog-style-card .blog-content h6 a',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label'     => __( 'Content Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-post .content p, .blog-style-card .blog-content p' => 'color: {{VALUE}}',
                    ],
                    'condition'   => [
                        'style' => '1',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-blog-post .content p, .blog-style-card .blog-content p',
                    'condition'   => [
                        'style' => '1',
                    ]
                ]
            );

            $this->add_control(
                'meta_color',
                [
                    'label' => __( 'Meta Color', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-post .image .date, .blog-style-card .blog-content .meta li, .blog-style-card .blog-content .meta li a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'meta_typography',
                    'label'    => __( 'Meta Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-blog-post .image .date, .blog-style-card .blog-content .meta li, .blog-style-card .blog-content .meta li a',
                ]
            );

            $this->add_control(
                'read_more_color',
                [
                    'label' => __( 'Button Color', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-blog-post .content .default-btn' => 'color: {{VALUE}}',
                    ],
                    'condition'   => [
                        'style' => '1',
                    ]
                ]
            );
        $this-> end_controls_section();
    }

    protected function render()
    {
        global $gauch_opt;

        $settings = $this->get_settings_for_display();

        $columns = $settings['columns'];
        if ( $columns == 2 ) {
            $column = 'col-lg-6 col-md-6 col-sm-6';
        } elseif ( $columns == 4 ) {
            $column = 'col-lg-3 col-md-6 col-sm-6';
        } else {
            $column = 'col-lg-4 col-md-6 col-sm-6';
        }

        // Post Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'post',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'meta_key'      => '_thumbnail_id',
                'ignore_sticky_posts' => 1,
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'category',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false,
                    )
                )
            );
        } else {
            $args = array(
                'post_type'           => 'post',
                'posts_per_page'      => $settings['count'],
                'order'               => $settings['order'],
                'meta_key'            => '_thumbnail_id',
                'ignore_sticky_posts' => 1,
            );
        }

        $post_array = new \WP_Query( $args ); ?>

        <?php if($settings['style'] == '1') : ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php
                        $loop = 1;
                        while ( $post_array->have_posts() ): $post_array->the_post();
                        $id    = get_the_ID();
                        $title = get_the_title( get_the_ID() );
                    ?>
                    <div class="<?php echo esc_attr( $column ); ?>">
                        <div class="single-blog-post-el">
                            <?php if(get_the_post_thumbnail_url() != ''): ?>
                                <div class="image">
                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="d-block">
                                        <img src="<?php echo get_the_post_thumbnail_url( get_the_ID() ); ?>" alt="<?php the_post_thumbnail_caption(); ?>">
                                    </a>
                                    <span class="date"><?php echo esc_html(get_the_date()); ?></span>
                                </div>
                            <?php endif; ?>

                            <div class="content">
                                <<?php echo esc_attr($settings['post_title_size']); ?>>
                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                        <?php echo esc_html($title); ?>
                                    </a>
                                </<?php echo esc_attr($settings['post_title_size']); ?>>

                                <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt'], '' )); ?></p>

                                <?php if($settings['read_more_text'] != ''): ?>
                                    <a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="default-btn"><span class="ri-arrow-right-s-line"></span><?php echo esc_html($settings['read_more_text']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php
                        $loop++;
                        endwhile;
                        wp_reset_query();
                    ?>
                </div>
            </div>
        <?php else: ?>
            <div class="container">
                <div class="row justify-content-center">
                    <?php
                        $loop = 1;
                        while ( $post_array->have_posts() ): $post_array->the_post();
                        $id    = get_the_ID();
                        $title = get_the_title( get_the_ID() );
                    ?>
                        <div class="<?php echo esc_attr( $column ); ?>">
                            <div class="blog-style-card">
                                <?php if(get_the_post_thumbnail_url() != ''): ?>
                                    <div class="blog-image">
                                        <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                            <img src="<?php echo get_the_post_thumbnail_url( get_the_ID() ); ?>" alt="<?php the_post_thumbnail_caption(); ?>">
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <div class="blog-content">
                                    <?php if( isset( $gauch_opt['is_post_meta'] ) && $gauch_opt['is_post_meta'] == true ) { ?>
                                        <ul class="meta">
                                            <li><?php echo esc_html($settings['by_text']); ?>  <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php echo esc_html(get_the_author()); ?></a></li>
                                            <li><?php echo esc_html(get_the_date()); ?></li>
                                        </ul>
                                    <?php } ?>

                                    <<?php echo esc_attr($settings['post_title_size']); ?>>
                                        <a href="<?php echo esc_url(get_the_permalink($id)); ?>">
                                            <?php echo esc_html($title); ?>
                                        </a>
                                    </<?php echo esc_attr($settings['post_title_size']); ?>>
                                </div>
                            </div>
                        </div>
                    <?php
                        $loop++;
                        endwhile;
                        wp_reset_query();
                    ?>
                </div>
            </div>
        <?php endif; ?>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Post_Area );