<?php
/**
 * Platform Info Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_PlatformAraea extends Widget_Base {

	public function get_name() {
        return 'PlatformArea';
    }

	public function get_title() {
        return esc_html__( 'Platform Area', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-image-rollover';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Features_Info',
			[
				'label' => esc_html__( 'Gauch Features Info', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

			$repeater = new Repeater();
            $repeater->add_control(
                'icon',
                [
                    'type'    => Controls_Manager::MEDIA,
                    'label' => __( 'Icon Image', 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Title', 'gauch-toolkit' ),
                    'default' => 'Email Marketing'
                ]
            );
            $repeater->add_control(
                'content', [
					'type'    => Controls_Manager::TEXTAREA,
					'label'   => esc_html__( 'Content', 'gauch-toolkit' ),
                ]
            );
            $repeater->add_control(
                'arrow_img',
                [
                    'type'    => Controls_Manager::MEDIA,
                    'label' => __( 'Arrow Image', 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => esc_html__( 'Add Image', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'title_color',
                [
                    'label'     => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .platforms-item h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .platforms-item h3',
                ]
            );
            $this->add_control(
                'con_color',
                [
                    'label'     => esc_html__( 'Content Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .platforms-item p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'con_typography',
                    'label'    => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .platforms-item p',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>
        <div class="container">
            <div class="row justify-content-center">
                <?php foreach($settings['items'] as $item): ?>
                    <div class="col-lg-4 col-sm-6">
                        <div class="platforms-item">
                            <?php if($item['icon']['url']): ?>
                                <div class="image">
                                    <img src="<?php echo esc_url( $item['icon']['url'] ); ?>" alt="<?php echo esc_attr($item['title']); ?>">
                                </div>
                            <?php endif; ?>
                            <h3><?php echo esc_html($item['title']); ?></h3>
                            <p><?php echo esc_html($item['content']); ?></p>

                            <?php if($item['arrow_img']['url']): ?>
                                <div class="arrow-image">
                                    <img src="<?php echo esc_url( $item['arrow_img']['url'] ); ?>" alt="<?php echo esc_attr($item['title']); ?>">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_PlatformAraea );