<?php
/**
 * Funfacts Two Widget
 */

namespace Elementor;
class Gauch_Funfacts_Two extends Widget_Base {

	public function get_name() {
        return 'Gauch_FunfactsTwo';
    }

	public function get_title() {
        return __( 'Funfacts Two', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-counter';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'funfacts_section',
			[
				'label' => __( 'Funfacts Control', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $list_items = new Repeater();
            $list_items->add_control(
                'number',
                [
                    'type'    => Controls_Manager::NUMBER,
                    'label'   => __( 'Ending Number', 'gauch-toolkit' ),
                    'default' => 324,
                ]
            );
            $list_items->add_control(
                'suffix',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Number Suffix', 'gauch-toolkit' ),
                    'default' => __('+', 'gauch-toolkit'),
                ]
            );
            $list_items->add_control(
                'title',
                [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => __( 'Title', 'gauch-toolkit' ),
                    'default' => __('Project Completed', 'gauch-toolkit'),
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => __( 'Add Counter Item', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );
            $this->add_control(
                'bg_image',
                [
                    'label'     => __( 'Section Background Image', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::MEDIA,
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'counter_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'counter_color',
                [
                    'label' => __( 'Number Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-funfact-card h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'number_typography',
                    'label'    => __( 'Number Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-funfact-card h3',
                ]
            );

            $this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'gauch-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-funfact-card p' => 'color: {{VALUE}}',
					],
				]
			);

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-funfact-card p',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();
    ?>
        <div class="funfacts-style-area">
            <div class="container">
                <div class="funfacts-style-inner-box pt-100 pb-70" style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
                    <div class="row justify-content-center">
                        <?php $i = 1; foreach( $settings['items'] as $item ) : ?>
                            <div class="col-lg-3 col-md-6 col-sm-4 col-6">
                                <div class="single-funfact-card">
                                    <h3>
                                        <span class="odometer" data-count="<?php echo esc_attr( $item['number'] ); ?>">00</span>   
                                        <span class="small-text"><?php echo esc_html( $item['suffix'] ); ?></span>
                                    </h3>
                                    <p><?php echo esc_html( $item['title'] ); ?></p>
                                </div>
                            </div>
                        <?php $i++; endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Funfacts_Two );