<?php
/**
 * Features Card Widget
 */

namespace Elementor;
class Gauch_Features_Card_Area extends Widget_Base {

	public function get_name() {
        return 'Gauch_Features_Card_Area';
    }

	public function get_title() {
        return __( 'Feature Services Area', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-image-rollover';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'features_section',
			[
				'label' => __( 'Features Control', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'columns',
                [
                    'label' => __( 'Choose Columns', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '2'   => __( '2', 'gauch-toolkit' ),
                        '3'   => __( '3', 'gauch-toolkit' ),
                        '4'   => __( '4', 'gauch-toolkit' ),
                    ],
                    'default' => '3',
                ]
            );

            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Choose Category', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => gauch_toolkit_get_page_services_cat_el(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Features Order By', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'gauch-toolkit' ),
                        'ASC'       => __( 'ASC', 'gauch-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'gauch-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3,
                ]
            );

            $this->add_control(
                'excerpt_num',
                [
                    'label'   => esc_html__( 'Excerpt', 'rec-toolkit' ),
                    'type'    => Controls_Manager::NUMBER,
                    'default' => 19,
                ]
            );

            $this->add_control(
                'card_bg_image',
                [
                    'label' => __( 'Card Background Image', 'gauch-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'ser_fea_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-features-box h3 a, .single-features-box h1 a, .single-features-box h2 a, .single-features-box h4 a, .single-features-box h5 a, .single-features-box h6 a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-features-box h3, .single-features-box h1, .single-features-box h2, .single-features-box h4, .single-features-box h5, .single-features-box h6',
                ]
            );
			$this->add_control(
				'con_color',
				[
					'label'     => __( 'Content Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-features-box p' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'con_typography',
                    'label'    => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-features-box p',
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();

        // Card Columns
        $columns = $settings['columns'];
        if ( $columns == '2' ) {
            $column = 'col-lg-6 col-sm-6 col-md-6';
        } elseif ( $columns == '3' ) {
            $column = 'col-lg-4 col-sm-6 col-md-6';
        } elseif ( $columns == '4' ) {
            $column = 'col-lg-3 col-sm-6 col-md-6';
        }

        // Services Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'     => 'services',
                'posts_per_page'=> $settings['count'],
                'order'         => $settings['order'],
                'tax_query'     => array(
                    array(
                        'taxonomy'      => 'service_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        } else {
            $args = array(
                'post_type'         => 'services',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }
        $services_array = new \WP_Query( $args );
        ?>

        <div class="container">
            <div class="row justify-content-center">

                <?php
                while ($services_array->have_posts()): $services_array->the_post();
                    $idd = get_the_ID();

                    if ( class_exists('ACF') && get_field('choose_link_type') == 1 ) {
                        $post_link = get_the_permalink();
                    } else {
                        $post_link = get_field('external_link');
                    }
                ?>

                <div class="<?php echo esc_attr( $column ); ?>">
                    <div class="single-features-box">
                        <?php if(get_the_post_thumbnail_url() != ''): ?>
                            <div class="icon">
                                <img src="<?php echo get_the_post_thumbnail_url( get_the_ID(), 'full' ); ?>" alt="<?php the_post_thumbnail_caption();  ?>">
                            </div>
                        <?php endif; ?>

                        <h3><a href="<?php echo esc_url($post_link); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>

                        <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), $settings['excerpt_num'], '' )); ?></p>

                        <style>
                            .single-features-box::before {background-image: url(<?php echo esc_url( $settings['card_bg_image']['url'] ); ?> )}
                        </style>

                    </div>
                </div>

                <?php endwhile;
                wp_reset_query(); ?>

            </div>
        </div>

        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Features_Card_Area );