<?php
/**
 * Features Info Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_Features_Info extends Widget_Base {

	public function get_name() {
        return 'Features_Info';
    }

	public function get_title() {
        return esc_html__( 'Features Info', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-image-rollover';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Features_Info',
			[
				'label' => esc_html__( 'Gauch Features Info', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'choose_style',
                [
                    'label' => __( 'Choose Style', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style 1', 'gauch-toolkit' ),
                        '2'   => __( 'Style 2', 'gauch-toolkit' ),
                        '3'   => __( 'Style 3', 'gauch-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'columns',
                [
                    'label' => __( 'Choose Columns', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        2   => __( '2', 'gauch-toolkit' ),
                        3   => __( '3', 'gauch-toolkit' ),
                        4   => __( '4', 'gauch-toolkit' ),
                    ],
                    'default' => 3,
                ]
            );

			$repeater = new Repeater();
            $repeater->add_control(
                'icon',
                [
                    'type'    => Controls_Manager::MEDIA,
                    'label' => __( 'Icon Image', 'gauch-toolkit' ),
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Title', 'gauch-toolkit' ),
                    'default' => 'Email Marketing'
                ]
            );
            $repeater->add_control(
                'content', [
					'type'    => Controls_Manager::TEXTAREA,
					'label'   => esc_html__( 'Content', 'gauch-toolkit' ),
                    'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => esc_html__( 'Add Image', 'gauch-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'label' => __( 'Card Background', 'gauch-toolkit' ),
                    'types' => [ 'classic' ],
                    'selector' => '{{WRAPPER}} .single-features-box::before',
                    'condition' => [
                        'choose_style' => '1',
                    ]
                ]
            );
            
            $this->add_control(
                'card_alignment',
                [
                    'label' => __( 'Card Alignment', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        'left'     => __( 'Left', 'gauch-toolkit' ),
                        'center'   => __( 'Center', 'gauch-toolkit' ),
                        'right'    => __( 'Right', 'gauch-toolkit' ),
                    ],
                    'default'   => 'center',
                    'condition' => [
                        'choose_style' => ['2','3'],
                    ]
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'card_color',
                [
                    'label'     => esc_html__( 'Card Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-features-box , .single-features-card, .single-features-card.with-black-color' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label'     => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-features-box h3, .single-features-card h3, .single-features-card.with-black-color h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .single-features-box h3, .single-features-card h3, .single-features-card.with-black-color h3',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label'     => esc_html__( 'Content Color', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .features-content  p, .single-features-card p, .single-features-card.with-black-color p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'content_typography',
                    'label'    => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .features-content  p, .single-features-card p, .single-features-card.with-black-color p',
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $columns = $settings['columns'];
        if ( $columns == 2 ) {
            $column = 'col-lg-6 col-md-6';
        } elseif ( $columns == 4 ) {
            $column = 'col-lg-3 col-md-6';
        } else {
            $column = 'col-lg-4 col-md-6';
        }
        ?>

        <div class="container">
            <div class="row justify-content-center">
                <?php foreach($settings['items'] as $item): ?>
                    <div class="<?php echo $column; ?>">

                        <?php if ( $settings['choose_style'] == '1' ) : ?>
                            <div class="single-features-box">
                                <?php if($item['icon']['url']): ?>
                                    <div class="icon">
                                        <img src="<?php echo esc_url( $item['icon']['url'] ); ?>" alt="<?php echo esc_attr($item['title']); ?>">
                                    </div>
                                <?php endif; ?>
                                <h3><?php echo esc_html($item['title']); ?></h3>
                                <p><?php echo wp_kses_post($item['content']); ?></p>
                            </div>
                        <?php else: ?>
                            <div class="single-features-card  <?php if ( $settings['choose_style'] == '3' ) : ?> with-black-color <?php endif; ?> <?php if($settings['card_alignment'] == 'left'): ?> text-start <?php elseif($settings['card_alignment'] == 'right'): ?> text-end <?php endif; ?>">
                                <?php if($item['icon']['url']): ?>
                                    <div class="image">
                                        <img src="<?php echo esc_url( $item['icon']['url'] ); ?>" alt="<?php echo esc_attr($item['title']); ?>">
                                    </div>
                                <?php endif; ?>
                                <h3><?php echo esc_html($item['title']); ?></h3>
                                <p><?php echo wp_kses_post($item['content']); ?></p>
                            </div>
                        <?php endif; ?>

                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Features_Info );