<?php namespace Elementor;

class GauchContactWidget extends Widget_Base{
    public function get_name(){
        return "gauchcontact-widget";
    }
    public function get_title(){
        return "Contact Area";
    }
    public function get_icon(){
        return "eicon-form-horizontal";
    }
    public function get_categories(){
        return [ 'gauch-elements' ];
    }

    protected function register_controls(){

        $this-> start_controls_section(
            'contact_info_content',
            [
                'label' => esc_html__('Contact Controls', 'gauch-toolkit'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'sec_style',
                [
                    'label' => __( 'Section Style', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style 1', 'gauch-toolkit' ),
                        '2'   => __( 'Style 2', 'gauch-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'form_title',
                [
                    'label'   => __( 'Form Title', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __( 'Contact Us', 'gauch-toolkit' ),
                    'condition' => [
                        'sec_style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'contact_shortcode',
                [
                    'label' => esc_html__( 'Contact Form Shortcode', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::TEXT,
                ]
            );
            $this->add_control(
                'info_title',
                [
                    'label'   => __( 'Information Title', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __( 'Get in Touch', 'gauch-toolkit' ),
                    'condition' => [
                        'sec_style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'info_content',
                [
                    'label'   => __( 'Information Content', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                    'condition' => [
                        'sec_style' => '2',
                    ]
                ]
            );
            $this->add_control(
                'bg_img', [
                    'type'    => Controls_Manager::MEDIA,
                    'label'   => esc_html__( ' Image', 'gauch-toolkit' ),
                ]
            );
        $this-> end_controls_section();

        // Styling
        $this->start_controls_section(
			'section_style',
			[
				'label'     => esc_html__( 'Style', 'gauch-toolkit' ),
				'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'sec_style' => '2',
                ]
			]
        );

            $this->add_control(
                'sec_bcolor',
                [
                    'label'     => esc_html__( 'Form Background', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-us-inner-box' => 'background-color: {{VALUE}}',
                    ],
                   
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( ' Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-us-inner-box .contact-form-wrap h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( ' Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .contact-us-inner-box .contact-form-wrap h2',
                ]
            );
            $this->add_control(
                'intitle_color',
                [
                    'label' => esc_html__( 'Info Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-us-inner-box .get-in-touch-information h4' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'intitle_typography',
                    'label' => __( 'Info Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .contact-us-inner-box .get-in-touch-information h4',
                ]
            );
            $this->add_control(
                'con_color',
                [
                    'label' => esc_html__( 'Info Content Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-us-inner-box .get-in-touch-information .information-list li a, .contact-us-inner-box .get-in-touch-information .information-list li, .contact-us-inner-box .get-in-touch-information .information-list li span' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'incon_typography',
                    'label' => __( 'Info Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .contact-us-inner-box .get-in-touch-information .information-list li a, .contact-us-inner-box .get-in-touch-information .information-list li, .contact-us-inner-box .get-in-touch-information .information-list li span',
                ]
            );
        $this-> end_controls_section();
    }

    protected function render() 
    {
        $settings = $this->get_settings_for_display(); 
        $form = $settings['contact_shortcode']; 
        ?>
        <?php if($settings['sec_style'] == '1'): ?>
            <div class="get-in-touch-area">
                <div class="container">
                    <div class="get-in-touch-inner-box ptb-100" style="background-image:url(<?php echo esc_url( $settings['bg_img']['url'] ); ?>);">
                        <?php if($form != '') : ?>
                            <div class="get-in-touch-form">
                                <?php echo do_shortcode($form); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="container">
                <div class="contact-us-inner-box">
                    <div class="row align-items-center">
                        <div class="col-lg-8 col-md-12">
                            <div class="contact-form-wrap">
                                <h2><?php echo esc_html($settings['form_title'] ); ?></h2>
                                <?php if($form != '') : ?>
                                    <div id="contactForm">
                                        <?php echo do_shortcode($form); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-12">
                            <div class="get-in-touch-information">
                                <h4><?php echo esc_html($settings['info_title'] ); ?></h4>
                                <?php echo wp_kses_post( $settings['info_content'] ); ?>

                                <?php if( $settings['bg_img']['url'] != '' ) : ?>
                                <div class="get-in-touch-shape">
                                    <img src="<?php echo esc_url( $settings['bg_img']['url'] ); ?>" alt="<?php echo esc_attr__('image','gauch-toolkit');?> ">
                                </div>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

    <?php    
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new GauchContactWidget );