<?php
/**
 * Choose Us Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_Choose_Us extends Widget_Base {

	public function get_name() {
        return 'Gauch_ChooseUs';
    }

	public function get_title() {
        return esc_html__( 'Choose Us Area', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Choose_Two',
			[
				'label' => esc_html__( 'Gauch Choose Us', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => __( 'Style', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style 1', 'gauch-toolkit' ),
                        '2'   => __( 'Style 2', 'gauch-toolkit' ),
                        '3'   => __( 'Style 3', 'gauch-toolkit' ),
                        '4'   => __( 'Style 4', 'gauch-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'top_title',
                [
                    'label' => esc_html__( 'Top Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('ABOUT US', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('You Can Choose Us By Looking At Our Different Work Skills', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => esc_html__( 'Content', 'gauch-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'default' => esc_html__('Donec sollicitudin molestie malesuada vivamus magna justo lacinia eget consectetur sed convallis at tellus donec rutrum congue leo eget malesuada quisque velit nisi pretium ut lacinia in elementum.', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'list_icon',
                [
                    'label'   => __( 'Lists Icon', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => 'ri-check-fill',
                ]
            );

            // Feature list
            $list_items = new Repeater();
            $list_items->add_control(
                'feature_title',
                [
                    'label'   => __( 'Title', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __( 'Brand Strategy', 'gauch-toolkit' ),
                ]
            );
            $this->add_control(
                'feature_item',
                [
                    'label'  => esc_html__('Feature Item', 'gauch-toolkit'),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );
            // Button One
			$this->add_control(
				'button_text',
				[
					'label'   => __( 'Button Text', 'gauch-toolkit' ),
					'type'    => Controls_Manager::TEXT,
					'default' => __('Get Started Now', 'gauch-toolkit'),
                    'label_block' => true,
                    'condition' => [
                        'style' => '3',
                    ]
				]
			);
			$this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'gauch-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'gauch-toolkit' ),
                    ],
                    'condition' => [
                        'style' => '3',
                    ]
                ]
            );
            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> gauch_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                        'style'     => '3',
                    ]
                ]
            );
            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                        'style'     => '3',
                    ]
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_images',
			[
				'label' => esc_html__( 'Images', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'sec_image',
                [
                    'label' => __( 'Section Image', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'shape1',
                [
                    'label' => __( 'Shape Image 1', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                    'condition' => [
                        'style' => '1',
                    ]
                ]
            );
        $this->end_controls_section();

        // Styling
        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .why-choose-us-content .sub-title, .cyber-safety-content .sub-title, .cryptocurrency-about-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .why-choose-us-content .sub-title, .cyber-safety-content .sub-title, .cryptocurrency-about-content .sub-title',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .why-choose-us-content h2, .why-choose-us-content h1, .why-choose-us-content h3, .why-choose-us-content h4, .why-choose-us-content h5, .why-choose-us-content h6, .cyber-safety-content h2, .cyber-safety-content h1, .cyber-safety-content h3, .cyber-safety-content h4, .cyber-safety-content h5, .cyber-safety-content h6, .cryptocurrency-about-content h2, .cryptocurrency-about-content h1, .cryptocurrency-about-content h3, .cryptocurrency-about-content h4, .cryptocurrency-about-content h5, .cryptocurrency-about-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}}  .why-choose-us-content h2, .why-choose-us-content h1, .why-choose-us-content h3, .why-choose-us-content h4, .why-choose-us-content h5, .why-choose-us-content h6, .cyber-safety-content h2, .cyber-safety-content h1, .cyber-safety-content h3, .cyber-safety-content h4, .cyber-safety-content h5, .cyber-safety-content h6, .cryptocurrency-about-content h2, .cryptocurrency-about-content h1, .cryptocurrency-about-content h3, .cryptocurrency-about-content h4, .cryptocurrency-about-content h5, .cryptocurrency-about-content h6',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .why-choose-us-content p, .cyber-safety-content p, .cryptocurrency-about-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .why-choose-us-content p, .cyber-safety-content p, .cryptocurrency-about-content p',
                ]
            );

            $this->add_control(
                'fea_title_color',
                [
                    'label' => esc_html__( 'Feature Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .why-choose-us-content .list li, .cyber-safety-content .safety-list li, .cryptocurrency-about-content .about-list li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'fae_tit_typography',
                    'label' => __( 'Feature Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .why-choose-us-content .list li, .cyber-safety-content .safety-list li, .cryptocurrency-about-content .about-list li',
                ]
            );

            $this->add_control(
				'btn_text_color',
				[
					'label'     => __( 'Button Text Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn.style-two' => 'color: {{VALUE}}',
					],
                    'condition' => [
                        'style' => '3',
                    ]
				]
			);

			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn.style-two' => 'background-color: {{VALUE}}',
					],
                    'condition' => [
                        'style' => '3',
                    ]
				]
			);

			$this->add_control(
				'btn_hover_color',
				[
					'label'     => __( 'Button Hover Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn.style-two:hover' => 'color: {{VALUE}}',
					],
                    'condition' => [
                        'style' => '3',
                    ]
				]
			);
			$this->add_control(
				'btn_hover_bg_color',
				[
					'label'     => __( 'Button Hover Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .default-btn.style-two:hover' => 'background-color: {{VALUE}}',
					],
                    'condition' => [
                        'style' => '3',
                    ]
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .default-btn.style-two',
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');

        $feature_item = $settings['feature_item'];
        ?>

        <?php if($settings['style'] == '1') : ?>
            <div class="why-choose-us-area ptb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="why-choose-us-content">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <ul class="list">
                                    <?php foreach( $feature_item as $item ): ?>
                                        <li><i class="<?php echo esc_attr( $settings['list_icon'] ); ?>"></i> <?php echo esc_html($item['feature_title'] ); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>

                        <?php if($settings['sec_image']['url']): ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="why-choose-us-image">
                                <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if($settings['shape1']['url'] != ''): ?>
                    <div class="why-choose-us-shape">
                        <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "gauch-toolkit"); ?>">
                    </div>
                <?php endif; ?>
            </div>
        <?php elseif($settings['style'] == '2') : ?>
            <div class="cyber-safety-area pb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <?php if($settings['sec_image']['url']): ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="cyber-safety-image">
                                    <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="col-lg-6 col-md-12">
                            <div class="cyber-safety-content">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <div class="row align-items-center">

                                    <div class="col-lg-6 col-md-6">
                                        <ul class="safety-list">
                                            <?php $i = 1; foreach( $feature_item as $item ): 
                                            if( $i % 2 != 0 ): ?>
                                                <li><i class="<?php echo esc_attr( $settings['list_icon'] ); ?>"></i> <?php echo esc_html($item['feature_title'] ); ?></li>
                                            <?php endif;
                                            $i++; endforeach; ?>
                                        </ul>
                                    </div>

                                    <div class="col-lg-6 col-md-6">
                                        <ul class="safety-list">
                                            <?php $i = 1; foreach( $feature_item as $item ): 
                                            if( $i % 2 == 0 ): ?>
                                                <li><i class="<?php echo esc_attr( $settings['list_icon'] ); ?>"></i> <?php echo esc_html($item['feature_title'] ); ?></li>
                                            <?php endif;
                                            $i++; endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($settings['style'] == '3') :
            if( $settings['link_type'] == 1 ){
                $link = get_page_link( $settings['link_to_page'] );
            } else {
                $link = $settings['ex_link'];
            } 
        ?>
            <div class="about-area ptb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <?php if($settings['sec_image']['url']): ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="cryptocurrency-about-image">
                                    <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="col-lg-6 col-md-12">
                            <div class="cryptocurrency-about-content">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <ul class="about-list">
                                    <?php foreach( $feature_item as $item ): ?>
                                        <li><i class="<?php echo esc_attr( $settings['list_icon'] ); ?>"></i> <?php echo esc_html($item['feature_title'] ); ?></li>
                                    <?php endforeach; ?>
                                </ul>

                                <?php if( $settings['button_text'] ): ?>
                                    <div class="about-btn">
                                        <a href="<?php echo esc_url( $link ); ?>" class="default-btn style-two"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $settings['button_text'] ); ?></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>

            <div class="about-area ptb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <?php if($settings['sec_image']['url']): ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="ico-about-image">
                                    <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="col-lg-6 col-md-12">
                            <div class="ico-about-content">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ); ?>
                                <ul class="about-list">
                                    <?php foreach( $feature_item as $item ): ?>
                                        <li><i class="<?php echo esc_attr( $settings['list_icon'] ); ?>"></i> <?php echo esc_html($item['feature_title'] ); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        <?php endif; ?>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Choose_Us );