<?php
/**
 * Banner Slider Widget
 */

namespace Elementor;
class Gauch_Banner_Slider extends Widget_Base {

	public function get_name() {
        return 'Gauch_Banner_Slider';
    }

	public function get_title() {
        return __( 'Banner Slider', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_Banner_Slider_Area',
			[
				'label' => __( 'Banner Slider Controls', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
                'title_tag',
                [
                    'label' 	=> esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'options' 	=> [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );
            $this->add_control(
				'bg_image',
				[
					'label' => __( 'Section Background Image', 'gauch-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);

            $this->add_control(
				'bg_shape_image',
				[
					'label' => __( 'Section Border Image', 'gauch-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);

            $list_items = new Repeater();
			$list_items->add_control(
				'top_title',
				[
					'label'   => __( 'Top Title', 'gauch-toolkit' ),
					'type'    => Controls_Manager::TEXT,
					'default' => __('AWARD WINNING COMPANY', 'gauch-toolkit'),
				]
			);

			$list_items->add_control(
				'title',
				[
					'label'       => __( 'Title', 'gauch-toolkit' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default'     => __('Make Your Business More Money With Team Of Experts', 'gauch-toolkit'),
                    'label_block' => true,
				]
			);

			$list_items->add_control(
				'button_text',
				[
					'label'   => __( 'Button Text', 'gauch-toolkit' ),
					'type'    => Controls_Manager::TEXT,
					'default' => __('Get Started Now', 'gauch-toolkit'),
                    'label_block' => true,
				]
			);

			$list_items->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'gauch-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'gauch-toolkit' ),
                    ],
                ]
            );

            $list_items->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> gauch_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );

            $list_items->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );

			$list_items->add_control(
				'sec_image',
				[
					'label' => __( 'Section Image', 'gauch-toolkit' ),
					'type'  => Controls_Manager::MEDIA,
				]
			);

            $this->add_control(
                'slider_items',
                [
                    'label' => esc_html__('Slider Item', 'gauch-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'gauch-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'top_title_color',
				[
					'label'     => __( 'Top Title Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-content .sub-title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'top_title_typography',
                    'label'    => __( 'Top Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-content .sub-title',
                ]
            );

			$this->add_control(
				'title_color',
				[
					'label'     => __( 'Title Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-content h1, .home-content h2, .home-content h3, .home-content h4, .home-content h5, .home-content h6' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'label'    => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-content h1, .home-content h2, .home-content h3, .home-content h4, .home-content h5, .home-content h6',
                ]
            );

			$this->add_control(
				'btn_text_color',
				[
					'label'     => __( 'Button Text Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-content .default-btn, .default-btn.style-two span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_bg_color',
				[
					'label'     => __( 'Button Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-content .default-btn' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'btn_hover_bg_color',
				[
					'label'     => __( 'Button Hover Background Color', 'gauch-toolkit' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .home-content .default-btn:hover' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'btn_typography',
                    'label'    => __( 'Button Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .home-content .default-btn',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
		$this-> add_inline_editing_attributes('content','none');

        if($settings['bg_shape_image']['url']):
            ?>
            <style>
                .home-area::before {
                        background-image: url(<?php echo esc_url($settings['bg_shape_image']['url']); ?>);
                }
                @media only screen and (min-width: 1550px) {
                    .home-area::before {
                        background-image: url(<?php echo esc_url($settings['bg_shape_image']['url']); ?>);
                    }
                }
            </style>
            <?php
        endif;
		?>
        <div class="home-area" style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
            <div class="home-slides owl-carousel owl-theme">
                <?php  foreach( $settings['slider_items'] as $item ):
                    // Get Button Link
                    if( $item['link_type'] == 1 ){
                        $link = get_page_link( $item['link_to_page'] );
                    } else {
                        $link = $item['ex_link'];
                    } ?>
                    <div class="banner-item">
                        <div class="container">
                            <div class="row align-items-center">
                                <div class="col-lg-6 col-md-12">
                                    <div class="home-content">
                                        <?php if($item['top_title']): ?>
                                            <span class="sub-title"><?php echo esc_html($item['top_title']); ?></span>
                                        <?php endif; ?>
                                        <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>>
                                            <?php echo esc_html( $item['title'] ); ?>
                                        </<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                        <?php if( $item['button_text'] ): ?>
                                            <a href="<?php echo esc_url( $link ); ?>" class="default-btn style-two"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $item['button_text'] ); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-12">
                                    <div class="home-image">
                                        <?php if($item['sec_image']['url']): ?>
                                            <img src="<?php echo esc_url( $item['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($item['title']); ?>">
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
	}

}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_Banner_Slider );