<?php
/**
 * App Download Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_App_Download extends Widget_Base {

	public function get_name() {
        return 'App_Download';
    }

	public function get_title() {
        return esc_html__( 'App Download', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-download-button';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_App_Download',
			[
				'label' => esc_html__( 'Gauch App Download', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
        
            $this->add_control(
                'top_title',
                [
                    'label' => esc_html__( 'Top Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Download App', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Download Your Free Copy Today From Apple And Play Store', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h3',
                ]
            );
            $this->add_control(
				'left_button_img',
				[
					'label' 	=> esc_html__( 'Left Button Image', 'gauch-toolkit' ),
					'type' 		=> Controls_Manager::MEDIA,
				]
            );
            $this->add_control(
                'left_button_link',
                [
                    'label'   => esc_html__( 'Left Image Link', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => '#',
                ]
            );
            $this->add_control(
				'right_button_img',
				[
					'label' 	=> esc_html__( 'Right Button Image', 'gauch-toolkit' ),
					'type' 		=> Controls_Manager::MEDIA,
				]
            );
            $this->add_control(
                'right_button_link',
                [
                    'label'   => esc_html__( 'Right Image Link', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => '#',
                ]
            );
            $this->add_control(
                'fimage',
                [
                    'label' => esc_html__( 'Feature Image', 'gauch-toolkit' ),
                    'type'	 => Controls_Manager::MEDIA,
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'toptitle_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .download-app-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'toptitle_typography',
                    'label' => __( 'Top Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .download-app-content .sub-title',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .download-app-content h3, .download-app-content h1, .download-app-content h2, .download-app-content h4, .download-app-content h5, .download-app-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .download-app-content h3, .download-app-content h1, .download-app-content h2, .download-app-content h4, .download-app-content h5, .download-app-content h6',
                ]
            );
            $this->add_control(
                'seec_bg_color',
                [
                    'label' => esc_html__( 'Section Background Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .download-app-inner-box' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');

        ?>
        <div class="download-app-area">
            <div class="container">
                <div class="download-app-inner-box">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="download-app-content">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <ul class="app-list">
                                    <?php if($settings['left_button_img']['url']): ?>
                                        <li>
                                            <a href="<?php echo esc_url($settings['left_button_link']); ?>"><img src="<?php echo esc_url($settings['left_button_img']['url']); ?>" alt="<?php echo esc_attr__('image','gauch-toolkit'); ?>"></a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if($settings['right_button_img']['url']): ?>
                                        <li>
                                            <a href="<?php echo esc_url($settings['right_button_link']); ?>"><img src="<?php echo esc_url($settings['right_button_img']['url']); ?>" alt="<?php echo esc_attr__('image','gauch-toolkit'); ?>"></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>

                        <?php if($settings['fimage']['url']): ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="download-app-image">
                                    <img src="<?php echo esc_url($settings['fimage']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_App_Download );