<?php
/**
 * About Area Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_About_Area extends Widget_Base {

	public function get_name() {
        return 'About_Area';
    }

	public function get_title() {
        return esc_html__( 'About Area', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_About_Area',
			[
				'label' => esc_html__( 'Gauch About Area', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'sec_style',
                [
                    'label' => esc_html__( 'Section Style', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => esc_html__( 'Style 1', 'gauch-toolkit' ),
                        '2'         => esc_html__( 'Style 2', 'gauch-toolkit' ),
                        '3'         => esc_html__( 'Style 3', 'gauch-toolkit' ),
                        '4'         => esc_html__( 'Style 4', 'gauch-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

            $this->add_control(
                'top_title',
                [
                    'label' => esc_html__( 'Top Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('ABOUT GAUCH', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('A Few Words About Us', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => esc_html__( 'Content', 'gauch-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'default' => esc_html__('Cloud based storage for your data backup just log in with your mail account from play store and using whatever you want for your business purpose orem ipsum dummy text. Never missyour chance its just began.', 'gauch-toolkit'),
                    'condition' => [
                        'sec_style!' => ['3','4'],
                    ]
                ]
            );

            // Feature list
            $list_items = new Repeater();

            $list_items->add_control(
                'icon_image',
                [
                    'label' => __( 'Icon Image', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );

            $list_items->add_control(
                'feature_title',
                [
                    'label'   => __( 'Title', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __( 'Brand Strategy', 'gauch-toolkit' ),
                ]
            );
            $list_items->add_control(
                'feature_desc',
                [
                    'label'   => __( 'Description', 'gauch-toolkit' ),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => __( 'Nulla quis lorem ut libero malesuada feugiat. Vivamus magna justo lacinia eget consectetur sed convallis at tellus.', 'gauch-toolkit' ),
                ]
            );
            $this->add_control(
                'feature_item',
                [
                    'label' => esc_html__('Feature Item', 'gauch-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Left Button Text', 'gauch-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Read More', 'gauch-toolkit'),
                    'condition' => [
                        'sec_style!' => ['3','4'],
                    ]
				]
            );

            $this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Left Button Link Type', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options'       => [
                        '1'  	=> esc_html__( 'Link To Page', 'gauch-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'gauch-toolkit' ),
                    ],
                    'condition' => [
                        'sec_style!' => ['3','4'],
                    ]
                ]
            );

            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Left Button Link Page', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> gauch_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type'  => '1',
                        'sec_style!' => ['3','4'],
                    ]
                ]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Left Button External Link', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type'  => '2',
                        'sec_style!' => ['3','4'],
                    ]
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_images',
			[
				'label' => esc_html__( 'Images', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'bg_image',
                [
                    'label'     => __( 'Section Background Image', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::MEDIA,
                    'condition' => [
                        'sec_style!' => ['3','4'],
                    ]
                ]
            );
            $this->add_control(
                'sec_image',
                [
                    'label' => __( 'Section Feature Image', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'img_pos',
                [
                    'label' => esc_html__( 'Section Image Position', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'left'         => esc_html__( 'Left', 'gauch-toolkit' ),
                        'right'         => esc_html__( 'Right', 'gauch-toolkit' ),
                    ],
                    'default' => 'left',
                    'condition' => [
                        'sec_style!' => '4',
                    ]
                ]
            );

            $this->add_control(
                'shape1',
                [
                    'label' => __( 'Shape Image 1', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                    'condition' => [
                        'sec_style!' => '4',
                    ]
                ]
            );
            $this->add_control(
                'shape2',
                [
                    'label' => __( 'Shape Image 2', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                    'condition' => [
                        'sec_style' => '1',
                    ]
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_logos',
			[
				'label' => esc_html__( 'Brand Logos', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'sec_style' => '2',
                ]
			]
        );

            $this->add_control(
                'logo_title',
                [
                    'label' 	=> esc_html__( 'Title', 'gauch-toolkit' ),
                    'type' 		=> Controls_Manager::TEXT,
                    'default' 	=> esc_html__('AWARDS AND INDUSTRY RECOGNITION', 'gauch-toolkit'),
                ]
            );
            // Logos
            $logo_items = new Repeater();

            $logo_items->add_control(
                'brand_image',
                [
                    'label' => __( 'Brand Image', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'logos_item',
                [
                    'label' => esc_html__('Logo Item', 'gauch-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $logo_items->get_controls(),
                ]
            );
        $this->end_controls_section();

        // Styling
        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'top_title_bgcolor',
                [
                    'label'     => esc_html__( 'Top Title Background', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .sub-title' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'sec_style!' => ['3','4'],
                    ]
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .sub-title, .what-we-work-content .sub-title, .ico-choose-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content .sub-title, .what-we-work-content .sub-title, .ico-choose-content .sub-title',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content h2, .about-content h3, .about-content h4, .about-content h5, .about-content h5, .about-content h6, .about-content h1, .what-we-work-content h2, .what-we-work-content h1, .what-we-work-content h3, .what-we-work-content h4, .what-we-work-content h5, .what-we-work-content h6, .ico-choose-content h2, .ico-choose-content h1, .ico-choose-content h3, .ico-choose-content h4, .ico-choose-content h5, .ico-choose-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content h2, .about-content h3, .about-content h4, .about-content h5, .about-content h5, .about-content h6, .about-content h1, .what-we-work-content h2, .what-we-work-content h1, .what-we-work-content h3, .what-we-work-content h4, .what-we-work-content h5, .what-we-work-content h6, .ico-choose-content h2, .ico-choose-content h1, .ico-choose-content h3, .ico-choose-content h4, .ico-choose-content h5, .ico-choose-content h6',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content p' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'sec_style!' => ['3','4'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content p',
                    'condition' => [
                        'sec_style!' => ['3','4'],
                    ]
                ]
            );

            $this->add_control(
                'fea_title_color',
                [
                    'label' => esc_html__( 'Feature Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .features-list li span, .what-we-work-content .we-work-inner-box h3, .ico-choose-content .choose-inner-box h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'fae_tit_typography',
                    'label' => __( 'Feature Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content .features-list li span, .what-we-work-content .we-work-inner-box h3, .ico-choose-content .choose-inner-box h3',
                ]
            );
            $this->add_control(
                'fea_desc_color',
                [
                    'label' => esc_html__( 'Feature Description Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .what-we-work-content .we-work-inner-box p, .ico-choose-content .choose-inner-box p' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'sec_style' =>  ['3','4'],
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'fae_desc_typography',
                    'label' => __( 'Feature Description Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .what-we-work-content .we-work-inner-box p, .ico-choose-content .choose-inner-box p',
                    'condition' => [
                        'sec_style' =>  ['3','4'],
                    ]
                ]
            );

            $this->add_control(
                'btn_color',
                [
                    'label' => esc_html__( 'Button Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'sec_style!' => ['3','4'],
                    ]
                ]
            );
            $this->add_control(
                'card_color',
                [
                    'label' => esc_html__( 'Card Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .what-we-work-content .we-work-inner-box' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'sec_style' =>  ['3','4'],
                    ]
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');

        // Get Button Link
        if($settings['link_type'] == 1){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        $feature_item = $settings['feature_item'];
        $logos_item   = $settings['logos_item'];
        ?>
        <?php if($settings['sec_style'] == '1'): ?>
            <div class="about-area bg-gradient-image ptb-100" style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
                <div class="container">
                    <div class="row align-items-center">
                    <?php if($settings['sec_image']['url']): ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="about-image">
                                <?php if($settings['sec_image']['url']): ?>
                                    <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                <?php endif; ?>

                                <?php if($settings['shape1']['url'] != ''): ?>
                                    <div class="shape5">
                                        <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "gauch-toolkit"); ?>">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-12">
                    <?php else: ?>
                        <div class="col-lg-12 col-md-12">
                    <?php endif; ?>
                            <div class="about-content">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <?php  if( $feature_item ): ?>
                                    <ul class="features-list">
                                    <?php  foreach( $feature_item as $item ): ?>
                                        <li>
                                            <div class="d-flex align-items-center">
                                                <?php if($item['icon_image']['url'] != ''): ?>
                                                    <div class="icon">
                                                        <img src="<?php echo esc_url( $item['icon_image']['url'] ); ?>" alt="<?php echo esc_attr__("Image", "gauch-toolkit"); ?>">
                                                    </div>
                                                <?php endif; ?>

                                                <span><?php echo esc_html($item['feature_title'] ); ?></span>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>

                                    </ul>
                                <?php endif; ?>

                                <?php if( $settings['button_text'] != '' ): ?>
                                    <a href="<?php echo esc_url( $link ); ?>" class="default-btn"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $settings['button_text'] ); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($settings['shape2']['url'] != ''): ?>
                    <div class="shape6">
                        <img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "gauch-toolkit"); ?>">
                    </div>
                <?php endif; ?>

            </div>
        <?php elseif($settings['sec_style'] == '2'): ?>
            <div class="about-area bg-gradient-image ptb-100" style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
                <div class="container">
                    <div class="row align-items-center">
                    <?php if($settings['sec_image']['url']): ?>
                        <div class="col-lg-6 col-md-12">
                            <div class="about-image">
                                <?php if($settings['sec_image']['url']): ?>
                                    <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                <?php endif; ?>

                                <?php if($settings['shape1']['url'] != ''): ?>
                                    <div class="shape5">
                                        <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "gauch-toolkit"); ?>">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-12">
                    <?php else: ?>
                        <div class="col-lg-12 col-md-12">
                    <?php endif; ?>
                            <div class="about-content">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ); ?>

                                <?php  if( $feature_item ): ?>
                                    <ul class="features-list">
                                    <?php  foreach( $feature_item as $item ): ?>
                                        <li>
                                            <div class="d-flex align-items-center">
                                                <?php if($item['icon_image']['url'] != ''): ?>
                                                    <div class="icon">
                                                        <img src="<?php echo esc_url( $item['icon_image']['url'] ); ?>" alt="<?php echo esc_attr__("Image", "gauch-toolkit"); ?>">
                                                    </div>
                                                <?php endif; ?>

                                                <span><?php echo esc_html($item['feature_title'] ); ?></span>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>

                                <?php if( $settings['button_text'] != '' ): ?>
                                    <a href="<?php echo esc_url( $link ); ?>" class="default-btn"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $settings['button_text'] ); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <?php  if( $logos_item ): ?>
                        <div class="awards-list">

                            <h4><?php echo esc_html($settings['logo_title'] ); ?></h4>

                            <div class="row justify-content-center">
                                <?php foreach( $logos_item as $item ): ?>
                                    <div class="col-lg-2 col-4 col-sm-4 col-md-3">
                                        <?php if($item['brand_image']['url'] != ''): ?>
                                            <div class="awards-box">
                                                <img src="<?php echo esc_url( $item['brand_image']['url'] ); ?>" alt="<?php echo esc_attr__("Image", "gauch-toolkit"); ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        <?php elseif($settings['sec_style'] == '3'): ?>
            <div class="what-we-work-area pb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <?php if($settings['img_pos'] == 'left'): ?>
                            <?php if($settings['sec_image']['url']): ?>
                                <div class="col-lg-6 col-md-12">
                                    <div class="what-we-work-image">
                                        <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>

                        <div class="col-lg-6 col-md-12">
                            <div class="what-we-work-content <?php if($settings['img_pos'] == 'right'): ?> pad-left0  <?php endif; ?>">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php $loop = 1; foreach( $feature_item as $item ) : ?>
                                    <?php if( $loop % 2 != 0 ): ?>
                                    <div class="we-work-inner-box">
                                    <?php else: ?>
                                    <div class="we-work-inner-box with-some-left">
                                    <?php endif; ?>
                                        <?php if($item['icon_image']['url'] != ''): ?>
                                            <div class="image">
                                                <img src="<?php echo esc_url( $item['icon_image']['url'] ); ?>" alt="<?php echo esc_attr__("Image", "gauch-toolkit"); ?>">
                                            </div>
                                        <?php endif; ?>
                                        <h3><?php echo esc_html($item['feature_title'] ); ?></h3>
                                        <p><?php echo esc_html($item['feature_desc'] ); ?></p>
                                    </div>
                                <?php $loop++; endforeach; ?>

                            </div>
                        </div>

                        <?php if($settings['img_pos'] == 'right'): ?>
                            <?php if($settings['sec_image']['url']): ?>
                                <div class="col-lg-6 col-md-12">
                                    <div class="what-we-work-image">
                                        <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if($settings['shape1']['url'] != ''): ?>
                    <div class="what-we-work-shape">
                        <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "gauch-toolkit"); ?>">
                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>

            <div class="ico-choose-area pb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="ico-choose-content">
                                <?php if( $settings['top_title'] != '' ): ?>
                                    <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                                <?php endif; ?>

                                <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>


                                <?php foreach( $feature_item as $item ) : ?>
                                    <div class="choose-inner-box">
                                        <?php if($item['icon_image']['url'] != ''): ?>
                                            <div class="image">
                                                <img src="<?php echo esc_url( $item['icon_image']['url'] ); ?>" alt="<?php echo esc_attr__("Image", "gauch-toolkit"); ?>">
                                            </div>
                                        <?php endif; ?>
                                        <h3><?php echo esc_html($item['feature_title'] ); ?></h3>
                                        <p><?php echo esc_html($item['feature_desc'] ); ?></p>
                                    </div>
                                <?php endforeach; ?>

                            </div>
                        </div>

                        <?php if($settings['sec_image']['url']): ?>
                            <div class="col-lg-6 col-md-12">
                                <div class="ico-choose-image">
                                    <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_About_Area );