<?php
/**
 * About Area Two Widget
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Gauch_About_Area_Two extends Widget_Base {

	public function get_name() {
        return 'About_Area_Two';
    }

	public function get_title() {
        return esc_html__( 'About Area Two', 'gauch-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'gauch-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'Gauch_About_Area_Two',
			[
				'label' => esc_html__( 'Gauch About Area Two', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'top_title',
                [
                    'label' => esc_html__( 'Top Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('ABOUT US', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('We Are Award Winning Digital Marketing Company', 'gauch-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => esc_html__( 'Title Tag', 'gauch-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => esc_html__( 'h1', 'gauch-toolkit' ),
                        'h2'         => esc_html__( 'h2', 'gauch-toolkit' ),
                        'h3'         => esc_html__( 'h3', 'gauch-toolkit' ),
                        'h4'         => esc_html__( 'h4', 'gauch-toolkit' ),
                        'h5'         => esc_html__( 'h5', 'gauch-toolkit' ),
                        'h6'         => esc_html__( 'h6', 'gauch-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => esc_html__( 'Content', 'gauch-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'gauch-toolkit'),
                ]
            );

            // Feature list
            $list_items = new Repeater();

            $list_items->add_control(
                'icon_image',
                [
                    'label' => __( 'Icon Image', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );

            $list_items->add_control(
                'feature_title',
                [
                    'label' => __( 'Title', 'gauch-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Brand Strategy', 'gauch-toolkit' ),
                ]
            );
            $this->add_control(
                'feature_item',
                [
                    'label' => esc_html__('Feature Item', 'gauch-toolkit'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $list_items->get_controls(),
                ]
            );

            $this->add_control(
				'button_text',
				[
					'label' 	=> esc_html__( 'Button Text', 'gauch-toolkit' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('More About Us', 'gauch-toolkit'),
				]
            );

            $this->add_control(
                'link_type',
                [
                    'label' 		=> esc_html__( 'Button Link Type', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' => [
                        '1'  	=> esc_html__( 'Link To Page', 'gauch-toolkit' ),
                        '2' 	=> esc_html__( 'External Link', 'gauch-toolkit' ),
                    ],
                ]
            );

            $this->add_control(
                'link_to_page',
                [
                    'label' 		=> esc_html__( 'Button Link Page', 'gauch-toolkit' ),
                    'type' 			=> Controls_Manager::SELECT,
                    'label_block' 	=> true,
                    'options' 		=> gauch_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );

            $this->add_control(
                'ex_link',
                [
                    'label'		=> esc_html__('Button External Link', 'gauch-toolkit'),
                    'type'		=> Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_images',
			[
				'label' => esc_html__( 'Images', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'sec_image',
                [
                    'label' => __( 'Section Image', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'shape1',
                [
                    'label' => __( 'Shape Image 1', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'shape2',
                [
                    'label' => __( 'Shape Image 2', 'gauch-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
        $this->end_controls_section();

        // Styling
        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'gauch-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'top_title_bgcolor',
                [
                    'label'     => esc_html__( 'Top Title Background', 'gauch-toolkit' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .sub-title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content .sub-title',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content h2, .about-content h3, .about-content h4, .about-content h5, .about-content h5, .about-content h6, .about-content h1' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content h2, .about-content h3, .about-content h4, .about-content h5, .about-content h5, .about-content h6, .about-content h1',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content p',
                ]
            );

            $this->add_control(
                'fea_title_color',
                [
                    'label' => esc_html__( 'Feature Title Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .features-list li span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'fae_tit_typography',
                    'label' => __( 'Feature Title Typography', 'gauch-toolkit' ),
                    'selector' => '{{WRAPPER}} .about-content .features-list li span',
                ]
            );

            $this->add_control(
                'btn_color',
                [
                    'label' => esc_html__( 'Button Color', 'gauch-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .default-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');

        // Get Button Link
        if($settings['link_type'] == 1){
            $link = get_page_link( $settings['link_to_page'] );
        } else {
            $link = $settings['ex_link'];
        }

        $feature_item = $settings['feature_item'];
        ?>
        <div class="about-area">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="about-img">
                            <?php if($settings['sec_image']['url']): ?>
                                <img src="<?php echo esc_url( $settings['sec_image']['url'] ) ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                            <?php endif; ?>

                            <?php if($settings['shape1']['url'] != ''): ?>
                                <div class="shape5">
                                    <img src="<?php echo esc_url( $settings['shape1']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "gauch-toolkit"); ?>">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12">
                        <div class="about-content">
                            <?php if( $settings['top_title'] != '' ): ?>
                                <span class="sub-title"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                            <?php endif; ?>

                            <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <?php echo wp_kses_post( $settings['content'] ); ?>

                            <?php  if( $feature_item ): ?>
                                <ul class="features-list">
                                <?php  foreach( $feature_item as $item ): ?>
                                    <li>
                                        <div class="d-flex align-items-center">
                                            <?php if($item['icon_image']['url'] != ''): ?>
                                                <div class="icon">
                                                    <img src="<?php echo esc_url( $item['icon_image']['url'] ); ?>" alt="<?php echo esc_attr__("Image", "gauch-toolkit"); ?>">
                                                </div>
                                            <?php endif; ?>

                                            <span><?php echo esc_html($item['feature_title'] ); ?></span>
                                        </div>
                                    </li>
                                <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>

                            <?php if( $settings['button_text'] != '' ): ?>
                                <a href="<?php echo esc_url( $link ); ?>" class="default-btn"><span class="ri-arrow-right-s-line"></span><?php echo esc_html( $settings['button_text'] ); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <?php if($settings['shape2']['url'] != ''): ?>
                <div class="shape6">
                    <img src="<?php echo esc_url( $settings['shape2']['url'] ); ?>" alt="<?php echo esc_attr__("Shape", "gauch-toolkit"); ?>">
                </div>
            <?php endif; ?>
        </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Gauch_About_Area_Two );