<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta content="telephone=no" name="format-detection">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php $fav = get_field('favicon' ,'option'); 
    if ($fav) {
    ?>
    <link rel="shortcut icon" type="image/png" href="<?php echo esc_url( $fav['url'] ); ?>" />
    <?php } ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Chivo:ital,wght@0,100..900;1,100..900&family=IBM+Plex+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;1,100;1,200;1,300;1,400;1,500;1,600;1,700&family=Libre+Bodoni:ital,wght@0,400..700;1,400..700&family=Nunito:ital,wght@0,200..1000;1,200..1000&display=swap" rel="stylesheet">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<?php
    if(is_home() || is_front_page()) {
        $cls_header = 'site-header';
    } else {
        $cls_header = 'inner-header';
    }
?>
<header  class="<?php echo $cls_header; ?>" id="site-header">
   <div class="container-lg">
        <div class="row align-items-center header-wrap">
            <div class="logo-wrap col-4 col-sm-2 col-lg-2">
                <?php
                    /* logo */
                    $logo = get_field('logo_header' ,'option');
                    if ($logo) {
                        echo '<a class="logo-header" href="' . get_bloginfo('url') . '" >';
                        echo '<img src="' . $logo['url'] . '" width="' . $logo['width'] . '" height="' . $logo['height'] . '" alt="' . $logo['alt'] . '" />';
                        echo '</a>';
                    }
                ?>
            </div>

            <nav class="col-4 col-sm-7 mobile-menu-order">
                <div class="mobile-menu-btn d-inline-flex d-sm-none">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/menu.svg" width="24" height="24" alt="menu" />
                </div>
                <?php
                    if (has_nav_menu('main')) {
                        $defaults = array(
                            'theme_location' => 'main',
                            'container' => '',
                            'menu_class' => ' main-menu  d-none d-sm-flex',
                            'echo' => true,
                            'fallback_cb' => 'wp_page_menu',
                            'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                            'depth' => 3,
                        );
                        wp_nav_menu($defaults);
                    }
                ?>
            </nav>
            <div class="header-left col-4 col-sm-3">
                <?php $header_cta = get_field('header_cta','option');
                    if($header_cta) {
                ?>
                <div class="cta-phone">
                    <a class="theme-button" href="<?php echo $header_cta['cta_url']; ?>">
                        <?php echo $header_cta['cta_text']; ?>
                        <span class="btn-icon"><i class="icon-arrow-right"></i></span>
                        <span></span>
                    </a>
                </div>
                <?php } ?>
            </div>
        </div>
   </div>
</header>

<main class="main-content">
