(function ($) {
  $(document).ready(function () {

    const customCss = `
      /* استایل موقعیت های شغلی */
      .job-position-item { background: #fff; padding: 15px; margin-bottom: 10px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
      .job-position-title { font-size: 16px; font-weight: bold; margin-bottom: 10px; }
      .job-position-description { margin-bottom: 10px; }
      .job-position-type { display: inline-block; padding: 4px 8px; background: #e3f2fd; border-radius: 4px; margin-right: 10px; }
      .job-position-skills { margin-top: 10px; }
      .job-skill-tag { display: inline-block; padding: 2px 6px; background: #f5f5f5; border-radius: 3px; margin: 2px; font-size: 12px; }
      .custom-list-wrap { background: #f9f9f9; border-radius: 8px !important; box-shadow: 0 2px 8px #0001; }
      .custom-list-items { margin-bottom: 10px; }
      .custom-list-item { background: #fff; border: 1px solid #e0e0e0 !important; box-shadow: 0 1px 4px #0001; margin-bottom: 8px; border-radius: 6px !important; padding: 12px !important; display: flex; gap: 10px; align-items: center; flex-wrap: wrap; }
      .custom-list-item input, .custom-list-item textarea { border-radius: 4px; border: 1px solid #ccc; padding: 6px 8px; }
      .custom-list-item input[type="text"] { min-width: 100px; }
      .custom-list-item .button { background: #e53935; color: #fff; border: none; border-radius: 4px; padding: 6px 14px; cursor: pointer; }
      .custom-list-item .button.button-upload { background: #1976d2; margin-right: 6px; }
      .custom-list-item .button.button-upload:hover { background: #1565c0; }
      .custom-list-item .button:hover { background: #b71c1c; }
      .custom-list-item .field-date { width: 120px; }
      .custom-list-item .field-time { width: 90px; }
      .custom-list-item .field-title, .custom-list-item .field-discount-title { flex: 1; min-width: 120px; }
      .custom-list-item .field-small-text { flex: 1; min-width: 100px; }
      .custom-list-item .field-link { flex: 2; min-width: 180px; }
      .custom-list-item .field-image-preview { max-width: 60px; max-height: 60px; border-radius: 4px; border: 1px solid #ccc; margin-left: 8px; }
      .custom-list-item .field-html { width: 100%; height: 60px; }
      .custom-list-item label { font-size: 12px; color: #666; margin-left: 4px; }
      /* استایل تب‌ها */
      .custom-tabs-container { display: flex; flex-direction: row-reverse; align-items: flex-start; }
      .custom-tabs-list {
        display: flex;
        flex-direction: column;
        gap: 4px;
        margin-left: 40px;
        margin-right: 0;
        min-width: 180px;
        align-items: flex-start;
        order: 2;
      }
      .custom-tab-btn {
  display: flex;               
  align-items: center;         
  gap: 0.75rem;               
  padding-top: 1rem;          
  padding-bottom: 1rem;       
  padding-right: 1rem;        
  width: 100%;                
  text-align: right;          
  border-radius: 0.25rem;     
  transition: all 0.2s ease;  
  background: #fff;
  border: none !important;
  font-size: 16px;
      }
      .custom-tab-btn.active, .custom-tab-btn:focus {
        background-color: #f3f4f6;        
      }
      .custom-tab-btn:hover {
        background-color: #f3f4f6;
      }
      .custom-tabs-list {
        border-radius: 22px 0 0 22px;
        padding: 18px 0 18px 0;
        min-height: 400px;
      }
      .custom-tab-content { flex: 1; order: 1; }
      @media (max-width: 900px) {
        .custom-tabs-container { flex-direction: column; }
        .custom-tabs-list { flex-direction: row; margin-left: 0; margin-bottom: 24px; border-radius: 22px 22px 0 0; min-width: unset; min-height: unset; }
        .custom-tab-btn, .custom-tab-btn.active, .custom-tab-btn:focus, .custom-tab-btn:hover {
          border-radius: 22px 22px 0 0 !important;
          padding: 14px 18px;
          width: auto;
        }
      }
        .logos-container {width:100%;margin-top:10px;}
.logo-item {background:#f8f8f8!important;border:1px solid #e0e0e0!important;border-radius:8px!important;padding:12px!important;margin:8px 0!important;}
.logo-item h4 {color:#444!important;margin:0 0 10px 0!important;font-size:14px!important;}
.logo-item input[type="text"] {border:1px solid #ddd!important;border-radius:4px!important;padding:6px 8px!important;background:#fff!important;}
.logo-item .button {font-size:12px!important;padding:5px 10px!important;}
    `;
    if (!document.getElementById('custom-theme-settings-css')) {
      $('<style id="custom-theme-settings-css">' + customCss + '</style>').appendTo('head');
    }


    const $form = $('.wrap form');
    if ($form.length) {

      const $allContent = $('<div class="custom-tab-content" id="tab-content-general"></div>');
      $form.children().not('.custom-tabs-container, .about-page-field').appendTo($allContent);

      const $mainPageContent = $('<div class="custom-tab-content" id="tab-content-main" style="display:none;"><p>در این بخش تنظیمات صفحه اصلی قرار می‌گیرد.</p></div>');

      const $styleContent = $('<div class="custom-tab-content" id="tab-content-style" style="display:none;"><p>در این بخش تنظیمات استایل‌های مختلف قالب قرار می‌گیرد.</p></div>');

      const $jobsContent = $('<div class="custom-tab-content" id="tab-content-jobs" style="display:none;"></div>');

      const $aboutContent = $('<div class="custom-tab-content" id="tab-content-about" style="display:none;"><p>تنظیمات صفحه درباره ما</p></div>');

      const $faqContent = $('<div class="custom-tab-content" id="tab-content-faq" style="display:none;"></div>');


      const $aboutFields = $('.about-page-field');
      if ($aboutFields.length) {
        const $table = $('<table class="form-table" role="presentation"></table>');
        $aboutFields.appendTo($table);
        $aboutContent.empty().append($table);
      }
      const $tabsList = $('<div class="custom-tabs-list"></div>');
      $tabsList.append('<button type="button" class="custom-tab-btn active" data-tab="general">تنظیمات عمومی</button>');
      $tabsList.append('<button type="button" class="custom-tab-btn" data-tab="main">صفحه اصلی</button>');
      $tabsList.append('<button type="button" class="custom-tab-btn" data-tab="style">تنظیمات استایل</button>');
      $tabsList.append('<button type="button" class="custom-tab-btn" data-tab="jobs">موقعیت‌های شغلی</button>');
      $tabsList.append('<button type="button" class="custom-tab-btn" data-tab="about">صفحه درباره ما</button>');
      $tabsList.append('<button type="button" class="custom-tab-btn" data-tab="faq">سوالات متداول</button>');

      const $tabsContainer = $('<div class="custom-tabs-container"></div>');
      $tabsContainer.append($tabsList).append($allContent).append($mainPageContent).append($styleContent).append($jobsContent).append($aboutContent).append($faqContent);
      $form.prepend($tabsContainer);

      $tabsList.on('click', '.custom-tab-btn', function () {
        $tabsList.find('.custom-tab-btn').removeClass('active');
        $(this).addClass('active');
        const tabName = $(this).data('tab');
        $('.custom-tab-content').hide();
        $('#tab-content-' + tabName).show();
      });
    }

    $('.custom-list-wrap').each(function () {
      const $wrapper = $(this);
      const name = $wrapper.data('name');
      const $textarea = $wrapper.next('textarea.custom-list-json');
      let items = [];

      try {
        items = JSON.parse($textarea.val()) || [];
      } catch (e) {
        items = [];
      }


      function assignUUIDs() {
        items.forEach(item => {
          if (!item._uuid) {
            item._uuid = Math.random().toString(36).substring(2, 10);
          }
        });
      }

      function render() {
        assignUUIDs();
        $wrapper.empty();
        const $list = $('<div class="custom-list-items"></div>');


        let isHomeSections = (name === 'home_sections');

        let isAboutBoxes = (name === 'about_boxes');
        if (isHomeSections) {
          $list.sortable({
            handle: '.drag-handle',
            axis: 'y',
            update: function () {
              let newItems = [];
              $list.find('.custom-list-item').each(function () {
                const uuid = $(this).data('id');
                const found = items.find(i => i._uuid === uuid);
                if (found) newItems.push(found);
              });
              items = newItems;
              save();
              render();
            }
          });
        }

        items.forEach((item, idx) => {
          const $item = $(`<div class="custom-list-item" data-id="${item._uuid}"></div>`);

          if (isHomeSections) {
            $item.append('<span class="drag-handle" style="cursor:grab;font-size:20px;margin-left:8px;">☰</span>');
          }

          if (name === 'slider') {
            $item.append(`<input type="text" placeholder="عنوان تخفیف" class="field-discount-title" value="${item.discount_title || ''}">`);
            $item.append(`<input type="text" placeholder="عنوان" class="field-title" value="${item.title || ''}">`);
            $item.append(`<input type="text" placeholder="نوشته کوچک" class="field-small-text" value="${item.small_text || ''}">`);
            $item.append(`<input type="text" placeholder="لینک" class="field-link" value="${item.link || ''}">`);

            $item.append(`<input type="text" placeholder="تاریخ (مثال: 1403/04/18)" class="field-date" value="${item.date_fa || ''}">`);
            $item.append(`<input type="time" placeholder="ساعت" class="field-time" value="${item.time || ''}">`);

            $item.append(`<input type="text" placeholder="آدرس تصویر" class="field-image" value="${item.image || ''}" style="width:180px;">`);
            $item.append(`<button type="button" class="button button-upload">انتخاب تصویر</button>`);
            if (item.image) $item.append(`<img src="${item.image}" class="field-image-preview">`);
          } else if (name === 'user_panel_slider') {
            $item.append(`<input type="text" placeholder="آدرس تصویر" class="field-image" value="${item.image || ''}" style="width:180px;">`);
            $item.append(`<button type="button" class="button button-upload">انتخاب تصویر</button>`);
            if (item.image) $item.append(`<img src="${item.image}" class="field-image-preview">`);
            $item.append(`<input type="text" placeholder="لینک" class="field-link" value="${item.link || ''}">`);
          } else if (name === 'product_categories') {
            $item.append(`<input type="text" placeholder="آدرس تصویر" class="field-icon" value="${item.icon || ''}" style="width:180px;">`);
            $item.append(`<button type="button" class="button button-upload">انتخاب تصویر</button>`);
            if (item.icon) $item.append(`<img src="${item.icon}" class="field-image-preview">`);
            $item.append(`<input type="text" placeholder="نام" class="field-name" value="${item.name || ''}">`);
            $item.append(`<input type="text" placeholder="لینک" class="field-link" value="${item.link || ''}">`);
          } else if (name === 'socials') {
            $item.append(`<textarea type="text" placeholder="آیکون" class="field-icon">${item.icon || ''}</textarea>`);
            $item.append(`<input type="text" placeholder="نام" class="field-name" value="${item.name || ''}">`);
            $item.append(`<input type="text" placeholder="لینک" class="field-link" value="${item.link || ''}">`);
          } else if (name === 'site_menu') {
            $item.append(`<input type="text" placeholder="نام" class="field-name" value="${item.name || ''}">`);
            $item.append(`<input type="text" placeholder="لینک" class="field-link" value="${item.link || ''}">`);
            $item.append(`<textarea type="text" placeholder="آیکون" class="field-icon" style="width:100px;">${item.icon || ''}</textarea>`);
          } else if (name === 'navbar_menu') {
            $item.append(`<input type="text" placeholder="نام" class="field-name" value="${item.name || ''}">`);
            $item.append(`<input type="text" placeholder="لینک" class="field-link" value="${item.link || ''}">`);
          } else if (name === 'job_positions_list') {
            $item.append(`<input type="text" class="field-title" placeholder="عنوان موقعیت شغلی" value="${item.title || ''}" style="width:100%;margin-bottom:10px;">`);
            $item.append(`<textarea class="field-description" placeholder="توضیحات موقعیت شغلی" style="width:100%;margin-bottom:10px;min-height:100px;">${item.description || ''}</textarea>`);
            const jobType = item.job_type || 'تمام وقت';
            $item.append(`
              <select class="field-job-type" style="margin-bottom:10px;width:200px;">
                <option value="تمام وقت"${jobType === 'تمام وقت' ? ' selected' : ''}>تمام وقت</option>
                <option value="پاره وقت"${jobType === 'پاره وقت' ? ' selected' : ''}>پاره وقت</option>
                <option value="دورکاری"${jobType === 'دورکاری' ? ' selected' : ''}>دورکاری</option>
                <option value="کارآموزی"${jobType === 'کارآموزی' ? ' selected' : ''}>کارآموزی</option>
              </select>
            `);
            $item.append(`<input type="text" class="field-skills" placeholder="مهارت‌ها (با کاما جدا کنید)" value="${item.skills || ''}" style="width:100%;">`);
          } else if (name === 'faq_list') {
            $item.append(`<input type="text" class="field-question" placeholder="سوال" value="${item.question || ''}" style="width:100%;margin-bottom:10px;">`);
            $item.append(`<textarea class="field-answer" placeholder="پاسخ" style="width:100%;margin-bottom:10px;min-height:100px;">${item.answer || ''}</textarea>`);
          } else if (name === 'site_badges') {
            $item.append(`<textarea placeholder="کد HTML" class="field-html">${item.html || ''}</textarea>`);
          } else if (name === 'footer_menu_1' || name === 'footer_menu_2') {
            $item.append(`<input type="text" placeholder="عنوان" class="field-name" value="${item.name || ''}">`);
            $item.append(`<input type="text" placeholder="لینک" class="field-link" value="${item.link || ''}">`);
          } else if (name === 'home_sections') {
            $item.append(`<label>نوع سکشن:</label>`);
            const typeOptions = [
              { value: 'product_categories', text: 'دسته‌بندی محصولات' },
              { value: 'products', text: 'سکشن محصولات' },
              { value: 'special_products', text: 'محصولات فروش ویژه' },
              { value: 'site_badges', text: 'نمادها' },
              { value: 'blog_posts', text: 'سکشن پست‌های بلاگ' },
              { value: 'custom_html', text: 'HTML سفارشی' },
              { value: 'site_description_box', text: 'باکس توضیحات سایت' },
              { value: 'banners', text: 'سکشن بنر' },
              { value: 'slider', text: 'سکشن اسلایدر' },
              { value: 'logo_slider', text: 'اسلایدر لوگوها' }
            ];
            const typeSelect = $('<select class="field-section-type"></select>');
            typeOptions.forEach(opt => {
              typeSelect.append(`<option value="${opt.value}"${item.type === opt.value ? ' selected' : ''}>${opt.text}</option>`);
            });
            $item.append(typeSelect);

            if (item.type === 'products') {
              // ساختار بهبود یافته برای سکشن محصولات
              const $productsSection = $('<div style="background:linear-gradient(135deg, #e0fae2 0%, #e0fae2 100%);padding:16px;margin:10px 0;border-radius:12px;border:2px solid #e0fae2;box-shadow:0 2px 8px rgba(156,39,176,0.15);"></div>');

              $productsSection.append(`<div style="display:flex;align-items:center;margin-bottom:14px;padding-bottom:10px;border-bottom:2px solid rgba(255,255,255,0.7);">
                <span style="font-size:20px;margin-left:8px;">🛍️</span>
                <h4 style="margin:0;color:#000000;font-size:15px;font-weight:600;">تنظیمات سکشن محصولات</h4>
              </div>`);

              // ردیف اول: آیکون و نام و لینک
              $productsSection.append(`
                <div style="display:grid;grid-template-columns:120px 1fr 1fr;gap:12px;margin-bottom:12px;">
                  <div style="background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                      <span style="font-size:16px;margin-left:6px;">✨</span>
                      آیکون:
                    </label>
                    <textarea placeholder="SVG" class="field-icon" style="width:100%;min-height:60px;padding:8px;border:1px solid #e0fae2;border-radius:6px;font-size:12px;background:#fff;font-family:monospace;resize:none;">${item.icon || ''}</textarea>
                  </div>
                  <div style="background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                      <span style="font-size:16px;margin-left:6px;">📝</span>
                      نام سکشن:
                    </label>
                    <input type="text" placeholder="مثال: محصولات پرفروش" class="field-name" value="${item.name || ''}" style="width:100%;padding:8px 12px;border:1px solid #e0fae2;border-radius:6px;font-size:13px;background:#fff;">
                  </div>
                  <div style="background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                      <span style="font-size:16px;margin-left:6px;">🔗</span>
                      لینک:
                    </label>
                    <input type="text" placeholder="https://example.com" class="field-link" value="${item.link || ''}" style="width:100%;padding:8px 12px;border:1px solid #e0fae2;border-radius:6px;font-size:13px;background:#fff;">
                  </div>
                </div>
              `);

              // ردیف دوم: جستجوی دسته‌بندی
              const selectedCats = item.product_cats || [];
              const $catList = $('<div class="field-product-cats-list" style="display:flex;flex-wrap:wrap;gap:6px;margin-top:8px;"></div>');
              selectedCats.forEach(cat => {
                $catList.append(`<span class="cat-chip" data-id="${cat.id}">${cat.name} <b style='cursor:pointer;' class='remove-cat'>&times;</b></span>`);
              });

              $productsSection.append(`
                <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;position:relative;">
                  <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                    <span style="font-size:16px;margin-left:6px;">🏷️</span>
                    دسته‌بندی محصولات:
                  </label>
                  <input type="text" class="field-product-cat-search" placeholder="🔍 جستجو کنید..." autocomplete="off" value="" style="width:100%;padding:10px 12px;border:2px solid #e0fae2;border-radius:8px;font-size:13px;background:#fff;transition:all 0.3s;">
                  <div class="product-cat-search-results" style="position:relative;z-index:1000;"></div>
                </div>
              `);
              $productsSection.find('.field-product-cat-search').after($catList);

              // ردیف سوم: تعداد و ترتیب نمایش
              $productsSection.append(`
                <div style="background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;display:grid;grid-template-columns:1fr 1fr;gap:12px;">
                  <div>
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                      <span style="font-size:16px;margin-left:6px;">🔢</span>
                      تعداد محصول:
                    </label>
                    <input type="number" min="1" max="30" class="field-product-count" placeholder="تعداد" value="${item.product_count || 4}" style="width:100%;padding:8px 12px;border:1px solid #e0fae2;border-radius:6px;font-size:13px;background:#fff;">
                  </div>
                  <div>
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                      <span style="font-size:16px;margin-left:6px;">📊</span>
                      ترتیب نمایش:
                    </label>
                    <select class="field-product-sort" style="width:100%;padding:8px 12px;border:1px solid #e0fae2;border-radius:6px;font-size:13px;background:#fff;cursor:pointer;">
                      <option value="popularity"${item.product_sort === 'popularity' ? ' selected' : ''}>محبوب‌ترین</option>
                      <option value="sales"${item.product_sort === 'sales' ? ' selected' : ''}>پرفروش‌ترین</option>
                      <option value="latest"${item.product_sort === 'latest' ? ' selected' : ''}>جدیدترین</option>
                    </select>
                  </div>
                </div>
              `);

              $item.append($productsSection);
            } else if (item.type === 'special_products') {
              // ساختار بهبود یافته برای محصولات فروش ویژه
              const $specialSection = $('<div style="background:linear-gradient(135deg, #e0fae2 0%, #e0fae2 100%);padding:16px;margin:10px 0;border-radius:12px;border:2px solid #e0fae2;box-shadow:0 2px 8px rgba(255,193,7,0.2);"></div>');

              $specialSection.append(`<div style="display:flex;align-items:center;margin-bottom:14px;padding-bottom:10px;border-bottom:2px solid rgba(255,255,255,0.7);">
                <span style="font-size:20px;margin-left:8px;">⚡</span>
                <h4 style="margin:0;color:#000000;font-size:15px;font-weight:600;">تنظیمات محصولات فروش ویژه</h4>
              </div>`);

              // ردیف اول: آیکون، نام و تعداد
              $specialSection.append(`
                <div style="display:grid;grid-template-columns:120px 1fr 200px;gap:12px;margin-bottom:12px;">
                  <div style="background:rgba(255,255,255,0.9);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                      <span style="font-size:16px;margin-left:6px;">✨</span>
                      آیکون:
                    </label>
                    <textarea placeholder="SVG" class="field-icon" style="width:100%;min-height:60px;padding:8px;border:1px solid #e0fae2;border-radius:6px;font-size:12px;background:#fff;font-family:monospace;resize:none;">${item.icon || ''}</textarea>
                  </div>
                  <div style="background:rgba(255,255,255,0.9);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                      <span style="font-size:16px;margin-left:6px;">🏆</span>
                      نام سکشن:
                    </label>
                    <input type="text" placeholder="مثال: پیشنهادهای شگفت‌انگیز" class="field-name" value="${item.name || ''}" style="width:100%;padding:8px 12px;border:1px solid #e0fae2;border-radius:6px;font-size:13px;background:#fff;">
                  </div>
                  <div style="background:rgba(255,255,255,0.9);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                      <span style="font-size:16px;margin-left:6px;">🔢</span>
                      تعداد محصول:
                    </label>
                    <input type="number" min="1" max="30" class="field-product-count" placeholder="تعداد" value="${item.product_count || 4}" style="width:100%;padding:8px 12px;border:1px solid #e0fae2;border-radius:6px;font-size:13px;background:#fff;">
                  </div>
                </div>
              `);

              // راهنما
              $specialSection.append(`
                <div style="background:rgba(255,255,255,0.9);padding:10px 12px;border-radius:8px;display:flex;align-items:center;gap:8px;">
                  <span style="font-size:18px;">💡</span>
                  <p style="margin:0;font-size:12px;color:#000000;opacity:0.9;">محصولاتی که تخفیف دارند نمایش داده می‌شوند</p>
                </div>
              `);

              $item.append($specialSection);
            } else if (item.type === 'blog_posts') {
              // ساختار بهبود یافته برای پست‌های بلاگ
              const $blogSection = $('<div style="background:linear-gradient(135deg, #e8f5e9 0%, #c8e6c9 100%);padding:16px;margin:10px 0;border-radius:12px;border:2px solid #81c784;box-shadow:0 2px 8px rgba(76,175,80,0.15);"></div>');

              $blogSection.append(`<div style="display:flex;align-items:center;margin-bottom:14px;padding-bottom:10px;border-bottom:2px solid rgba(255,255,255,0.7);">
                <span style="font-size:20px;margin-left:8px;">📰</span>
                <h4 style="margin:0;color:#2e7d32;font-size:15px;font-weight:600;">تنظیمات سکشن بلاگ</h4>
              </div>`);

              // جستجوی دسته‌بندی بلاگ
              const selectedBlogCats = item.blog_cats || [];
              const $blogCatList = $('<div class="field-blog-cats-list" style="display:flex;flex-wrap:wrap;gap:6px;margin-top:8px;"></div>');
              selectedBlogCats.forEach(cat => {
                $blogCatList.append(`<span class="cat-chip" data-id="${cat.id}">${cat.name} <b style='cursor:pointer;' class='remove-cat'>&times;</b></span>`);
              });

              $blogSection.append(`
                <div style="background:rgba(255,255,255,0.9);padding:12px;border-radius:8px;position:relative;">
                  <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#2e7d32;">
                    <span style="font-size:16px;margin-left:6px;">🏷️</span>
                    دسته‌بندی بلاگ:
                  </label>
                  <input type="text" class="field-blog-cat-search" placeholder="🔍 جستجو کنید..." autocomplete="off" value="" style="width:100%;padding:10px 12px;border:2px solid #81c784;border-radius:8px;font-size:13px;background:#fff;transition:all 0.3s;">
                  <div class="blog-cat-search-results" style="position:relative;z-index:1000;"></div>
                  <p style="margin:8px 0 0 0;font-size:12px;color:#2e7d32;opacity:0.8;">💡 می‌توانید چند دسته‌بندی انتخاب کنید</p>
                </div>
              `);
              $blogSection.find('.field-blog-cat-search').after($blogCatList);

              $item.append($blogSection);
            } else if (item.type === 'banners') {
              $item.append(`<input type="number" min="1" max="10" class="field-banner-count" placeholder="تعداد بنر" value="${item.banner_count || 1}" style="width:70px;">`);


              const currentStyle = item.banner_style || 'style1';
              $item.append(`
                <div style="margin:10px 0;">
                  <label style="display:inline-block;width:80px;font-size:12px;">استایل:</label>
                  <select class="field-banner-style" style="width:150px;">
                    <option value="style1"${currentStyle === 'style1' ? ' selected' : ''}>استایل 1</option>
                    <option value="style2"${currentStyle === 'style2' ? ' selected' : ''}>استایل 2</option>
                  </select>
                </div>
              `);


              let banners = item.banners || [];
              const bannerCount = parseInt(item.banner_count) || 1;


              while (banners.length < bannerCount) {
                banners.push({ desktop_image: '', mobile_image: '', link: '' });
              }
              while (banners.length > bannerCount) {
                banners.pop();
              }

              const $bannersContainer = $('<div class="banners-container" style="width:100%;"></div>');
              banners.forEach((banner, bannerIdx) => {
                const $bannerItem = $('<div class="banner-item" style="background:linear-gradient(135deg, #e0fae2 0%, #e0fae2 100%);padding:16px;margin:10px 0;border-radius:12px;border:2px solid #e1e8ed;box-shadow:0 2px 8px rgba(0,0,0,0.08);transition:all 0.3s ease;"></div>');

                // Header بنر با آیکون
                $bannerItem.append(`<div style="display:flex;align-items:center;margin-bottom:14px;padding-bottom:10px;border-bottom:2px solid rgba(255,255,255,0.6);">
                  <span style="font-size:20px;margin-left:8px;">🖼️</span>
                  <h4 style="margin:0;color:#2c3e50;font-size:15px;font-weight:600;">بنر شماره ${bannerIdx + 1}</h4>
                </div>`);

                // بخش تصویر دسکتاپ
                const desktopPreview = banner.desktop_image
                  ? `<div style="margin-top:8px;"><img src="${banner.desktop_image}" class="field-image-preview" style="max-width:120px;max-height:80px;border-radius:8px;border:2px solid #fff;box-shadow:0 2px 6px rgba(0,0,0,0.1);"></div>`
                  : '';
                $bannerItem.append(`
                  <div style="margin-bottom:14px;background:rgba(255,255,255,0.7);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#34495e;">
                      <span style="font-size:16px;margin-left:6px;">💻</span>
                      تصویر دسکتاپ:
                    </label>
                    <div style="display:flex;align-items:center;gap:8px;flex-wrap:wrap;">
                      <input type="text" placeholder="آدرس تصویر دسکتاپ" class="field-banner-desktop-image" value="${banner.desktop_image || ''}" style="flex:1;min-width:200px;padding:8px 12px;border:1px solid #d1d8e0;border-radius:6px;font-size:13px;background:#fff;">
                      <button type="button" class="button button-primary button-upload-banner" data-type="desktop" data-banner="${bannerIdx}" style="padding:8px 16px;font-size:13px;border-radius:6px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
                        <span style="margin-left:4px;">📁</span> انتخاب تصویر
                      </button>
                    </div>
                    ${desktopPreview}
                  </div>
                `);

                // بخش تصویر موبایل
                const mobilePreview = banner.mobile_image
                  ? `<div style="margin-top:8px;"><img src="${banner.mobile_image}" class="field-image-preview" style="max-width:80px;max-height:80px;border-radius:8px;border:2px solid #fff;box-shadow:0 2px 6px rgba(0,0,0,0.1);"></div>`
                  : '';
                $bannerItem.append(`
                  <div style="margin-bottom:14px;background:rgba(255,255,255,0.7);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#34495e;">
                      <span style="font-size:16px;margin-left:6px;">📱</span>
                      تصویر موبایل:
                    </label>
                    <div style="display:flex;align-items:center;gap:8px;flex-wrap:wrap;">
                      <input type="text" placeholder="آدرس تصویر موبایل" class="field-banner-mobile-image" value="${banner.mobile_image || ''}" style="flex:1;min-width:200px;padding:8px 12px;border:1px solid #d1d8e0;border-radius:6px;font-size:13px;background:#fff;">
                      <button type="button" class="button button-primary button-upload-banner" data-type="mobile" data-banner="${bannerIdx}" style="padding:8px 16px;font-size:13px;border-radius:6px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
                        <span style="margin-left:4px;">📁</span> انتخاب تصویر
                      </button>
                    </div>
                    ${mobilePreview}
                  </div>
                `);

                // بخش لینک
                $bannerItem.append(`
                  <div style="background:rgba(255,255,255,0.7);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#34495e;">
                      <span style="font-size:16px;margin-left:6px;">🔗</span>
                      لینک بنر:
                    </label>
                    <input type="text" placeholder="https://example.com" class="field-banner-link" value="${banner.link || ''}" style="width:100%;padding:8px 12px;border:1px solid #d1d8e0;border-radius:6px;font-size:13px;background:#fff;">
                  </div>
                `);

                $bannersContainer.append($bannerItem);
              });
              $item.append($bannersContainer);
            } else if (item.type === 'slider') {

              $item.append(`<label>استایل اسلایدر:</label>`);
              const styleOptions = [
                { value: 'style1', text: 'استایل یک' },
                { value: 'style2', text: 'استایل دو' },
                { value: 'style3', text: 'استایل سه' },
                { value: 'style4', text: 'استایل چهار' },
              ];
              const styleSelect = $('<select class="field-slider-style"></select>');
              styleOptions.forEach(opt => {
                styleSelect.append(`<option value="${opt.value}"${item.slider_style === opt.value ? ' selected' : ''}>${opt.text}</option>`);
              });
              $item.append(styleSelect);


              $item.append(`<input type="number" min="1" max="10" class="field-slider-count" placeholder="تعداد اسلاید" value="${item.slider_count || 1}" style="width:70px;">`);


              let slides = item.slides || [];
              const slideCount = parseInt(item.slider_count) || 1;
              const currentStyle = item.slider_style || 'style1';


              while (slides.length < slideCount) {
                if (currentStyle === 'style1') {
                  slides.push({ discount_title: '', date_fa: '', time: '', title: '', image: '', small_text: '', link: '' });
                } else if (currentStyle === 'style2') {
                  slides.push({ small_text: '', title: '', image: '', link: '' });
                } else if (currentStyle === 'style3') {
                  slides.push({ desktop_image: '', mobile_image: '', link: '' });
                } else if (currentStyle === 'style4') {
                  slides.push({ desktop_image: '', mobile_image: '', link: '' });
                }
              }
              while (slides.length > slideCount) {
                slides.pop();
              }

              const $slidesContainer = $('<div class="slides-container" style="width:100%;"></div>');
              slides.forEach((slide, slideIdx) => {
                const $slideItem = $('<div class="slide-item" style="background:linear-gradient(135deg, #e0fae2 0%, #e0fae2 100%);padding:16px;margin:10px 0;border-radius:12px;border:2px solid #e0fae2;box-shadow:0 2px 8px rgba(0,188,212,0.15);transition:all 0.3s ease;"></div>');

                // Header اسلاید با آیکون
                $slideItem.append(`<div style="display:flex;align-items:center;margin-bottom:14px;padding-bottom:10px;border-bottom:2px solid rgba(255,255,255,0.7);">
                  <span style="font-size:20px;margin-left:8px;">🎬</span>
                  <h4 style="margin:0;color:#000000;font-size:15px;font-weight:600;">اسلاید شماره ${slideIdx + 1}</h4>
                </div>`);

                if (currentStyle === 'style1') {
                  // استایل 1: فرم کامل با تخفیف و تایمر

                  const imagePreview = slide.image
                    ? `<div style="margin-top:8px;"><img src="${slide.image}" class="field-image-preview" style="max-width:120px;max-height:80px;border-radius:8px;border:2px solid #fff;box-shadow:0 2px 6px rgba(0,0,0,0.1);"></div>`
                    : '';

                  $slideItem.append(`
                    <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">🏷️</span>
                        عنوان تخفیف:
                      </label>
                      <input type="text" placeholder="مثال: تخفیف ویژه" class="field-slide-discount-title" value="${slide.discount_title || ''}" style="width:100%;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                    </div>
                    
                    <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">⏰</span>
                        زمان شروع تخفیف:
                      </label>
                      <div style="display:flex;gap:8px;flex-wrap:wrap;">
                        <input type="text" placeholder="تاریخ (1403/04/18)" class="field-slide-date" value="${slide.date_fa || ''}" style="flex:1;min-width:150px;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                        <input type="time" class="field-slide-time" value="${slide.time || ''}" style="width:120px;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                      </div>
                    </div>

                    <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">📝</span>
                        عنوان اصلی:
                      </label>
                      <input type="text" placeholder="عنوان اسلاید" class="field-slide-title" value="${slide.title || ''}" style="width:100%;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                    </div>

                    <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">🖼️</span>
                        تصویر اسلاید:
                      </label>
                      <div style="display:flex;align-items:center;gap:8px;flex-wrap:wrap;">
                        <input type="text" placeholder="آدرس تصویر" class="field-slide-image" value="${slide.image || ''}" style="flex:1;min-width:200px;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                        <button type="button" class="button button-primary button-upload-slide" data-type="image" data-slide="${slideIdx}" style="padding:8px 16px;font-size:13px;border-radius:6px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
                          <span style="margin-left:4px;">📁</span> انتخاب
                        </button>
                      </div>
                      ${imagePreview}
                    </div>

                    <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">💬</span>
                        توضیح کوتاه:
                      </label>
                      <input type="text" placeholder="توضیحات کوتاه اسلاید" class="field-slide-small-text" value="${slide.small_text || ''}" style="width:100%;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                    </div>

                    <div style="background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">🔗</span>
                        لینک:
                      </label>
                      <input type="text" placeholder="https://example.com" class="field-slide-link" value="${slide.link || ''}" style="width:100%;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                    </div>
                  `);

                } else if (currentStyle === 'style2') {
                  // استایل 2: فرم ساده

                  const imagePreview = slide.image
                    ? `<div style="margin-top:8px;"><img src="${slide.image}" class="field-image-preview" style="max-width:120px;max-height:80px;border-radius:8px;border:2px solid #fff;box-shadow:0 2px 6px rgba(0,0,0,0.1);"></div>`
                    : '';

                  $slideItem.append(`
                    <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">💬</span>
                        توضیح کوتاه:
                      </label>
                      <input type="text" placeholder="توضیحات کوتاه" class="field-slide-small-text" value="${slide.small_text || ''}" style="width:100%;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                    </div>

                    <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">📝</span>
                        عنوان:
                      </label>
                      <input type="text" placeholder="عنوان اسلاید" class="field-slide-title" value="${slide.title || ''}" style="width:100%;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                    </div>

                    <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">🖼️</span>
                        تصویر:
                      </label>
                      <div style="display:flex;align-items:center;gap:8px;flex-wrap:wrap;">
                        <input type="text" placeholder="آدرس تصویر" class="field-slide-image" value="${slide.image || ''}" style="flex:1;min-width:200px;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                        <button type="button" class="button button-primary button-upload-slide" data-type="image" data-slide="${slideIdx}" style="padding:8px 16px;font-size:13px;border-radius:6px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
                          <span style="margin-left:4px;">📁</span> انتخاب
                        </button>
                      </div>
                      ${imagePreview}
                    </div>

                    <div style="background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">🔗</span>
                        لینک:
                      </label>
                      <input type="text" placeholder="https://example.com" class="field-slide-link" value="${slide.link || ''}" style="width:100%;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                    </div>
                  `);

                } else if (currentStyle === 'style3' || currentStyle === 'style4') {
                  // استایل 3 و 4: تصویر دسکتاپ و موبایل

                  const desktopPreview = slide.desktop_image
                    ? `<div style="margin-top:8px;"><img src="${slide.desktop_image}" class="field-image-preview" style="max-width:120px;max-height:80px;border-radius:8px;border:2px solid #fff;box-shadow:0 2px 6px rgba(0,0,0,0.1);"></div>`
                    : '';
                  const mobilePreview = slide.mobile_image
                    ? `<div style="margin-top:8px;"><img src="${slide.mobile_image}" class="field-image-preview" style="max-width:80px;max-height:80px;border-radius:8px;border:2px solid #fff;box-shadow:0 2px 6px rgba(0,0,0,0.1);"></div>`
                    : '';

                  $slideItem.append(`
                    <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">💻</span>
                        تصویر دسکتاپ:
                      </label>
                      <div style="display:flex;align-items:center;gap:8px;flex-wrap:wrap;">
                        <input type="text" placeholder="آدرس تصویر دسکتاپ" class="field-slide-desktop-image" value="${slide.desktop_image || ''}" style="flex:1;min-width:200px;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                        <button type="button" class="button button-primary button-upload-slide" data-type="desktop" data-slide="${slideIdx}" style="padding:8px 16px;font-size:13px;border-radius:6px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
                          <span style="margin-left:4px;">📁</span> انتخاب
                        </button>
                      </div>
                      ${desktopPreview}
                    </div>

                    <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">📱</span>
                        تصویر موبایل:
                      </label>
                      <div style="display:flex;align-items:center;gap:8px;flex-wrap:wrap;">
                        <input type="text" placeholder="آدرس تصویر موبایل" class="field-slide-mobile-image" value="${slide.mobile_image || ''}" style="flex:1;min-width:200px;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                        <button type="button" class="button button-primary button-upload-slide" data-type="mobile" data-slide="${slideIdx}" style="padding:8px 16px;font-size:13px;border-radius:6px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
                          <span style="margin-left:4px;">📁</span> انتخاب
                        </button>
                      </div>
                      ${mobilePreview}
                    </div>

                    <div style="background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                      <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#000000;">
                        <span style="font-size:16px;margin-left:6px;">🔗</span>
                        لینک:
                      </label>
                      <input type="text" placeholder="https://example.com" class="field-slide-link" value="${slide.link || ''}" style="width:100%;padding:8px 12px;border:1px solid #b2dfdb;border-radius:6px;font-size:13px;background:#fff;">
                    </div>
                  `);
                }

                $slidesContainer.append($slideItem);
              });
              $item.append($slidesContainer);
            } else if (item.type === 'logo_slider') {
              $item.append(`<input type="text" placeholder="عنوان سکشن" class="field-name" value="${item.name || ''}" style="width:200px;margin-bottom:10px;">`);
              $item.append(`<input type="number" min="1" max="20" class="field-logo-count" placeholder="تعداد لوگو" value="${item.logo_count || 1}" style="width:70px;margin-bottom:10px;">`);


              let logos = item.logos || [];
              const logoCount = parseInt(item.logo_count) || 1;


              while (logos.length < logoCount) {
                logos.push({ image: '', link: '', alt: '' });
              }
              while (logos.length > logoCount) {
                logos.pop();
              }

              const $logosContainer = $('<div class="logos-container" style="width:100%;"></div>');
              logos.forEach((logo, logoIdx) => {
                const $logoItem = $('<div class="logo-item" style="background:linear-gradient(135deg, #fff3e0 0%, #ffe0b2 100%);padding:16px;margin:10px 0;border-radius:12px;border:2px solid #ffcc80;box-shadow:0 2px 8px rgba(255,152,0,0.15);transition:all 0.3s ease;"></div>');

                // Header لوگو با آیکون
                $logoItem.append(`<div style="display:flex;align-items:center;margin-bottom:14px;padding-bottom:10px;border-bottom:2px solid rgba(255,255,255,0.7);">
                  <span style="font-size:20px;margin-left:8px;">🏢</span>
                  <h4 style="margin:0;color:#e65100;font-size:15px;font-weight:600;">لوگو شماره ${logoIdx + 1}</h4>
                </div>`);

                // بخش تصویر لوگو
                const logoPreview = logo.image
                  ? `<div style="margin-top:8px;"><img src="${logo.image}" class="field-image-preview" style="max-width:100px;max-height:60px;border-radius:8px;border:2px solid #fff;box-shadow:0 2px 6px rgba(0,0,0,0.1);background:#fff;padding:4px;"></div>`
                  : '';
                $logoItem.append(`
                  <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#bf360c;">
                      <span style="font-size:16px;margin-left:6px;">🖼️</span>
                      تصویر لوگو:
                    </label>
                    <div style="display:flex;align-items:center;gap:8px;flex-wrap:wrap;">
                      <input type="text" placeholder="آدرس تصویر لوگو" class="field-logo-image" value="${logo.image || ''}" style="flex:1;min-width:200px;padding:8px 12px;border:1px solid #ffccbc;border-radius:6px;font-size:13px;background:#fff;">
                      <button type="button" class="button button-primary button-upload-logo" data-logo="${logoIdx}" style="padding:8px 16px;font-size:13px;border-radius:6px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
                        <span style="margin-left:4px;">📁</span> انتخاب
                      </button>
                    </div>
                    ${logoPreview}
                  </div>
                `);

                // بخش لینک
                $logoItem.append(`
                  <div style="margin-bottom:12px;background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#bf360c;">
                      <span style="font-size:16px;margin-left:6px;">🔗</span>
                      لینک:
                    </label>
                    <input type="text" placeholder="https://example.com" class="field-logo-link" value="${logo.link || ''}" style="width:100%;padding:8px 12px;border:1px solid #ffccbc;border-radius:6px;font-size:13px;background:#fff;">
                  </div>
                `);

                // بخش Alt Text
                $logoItem.append(`
                  <div style="background:rgba(255,255,255,0.8);padding:12px;border-radius:8px;">
                    <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#bf360c;">
                      <span style="font-size:16px;margin-left:6px;">🏷️</span>
                      متن جایگزین (Alt):
                    </label>
                    <input type="text" placeholder="توضیح کوتاه درباره لوگو" class="field-logo-alt" value="${logo.alt || ''}" style="width:100%;padding:8px 12px;border:1px solid #ffccbc;border-radius:6px;font-size:13px;background:#fff;">
                  </div>
                `);

                $logosContainer.append($logoItem);
              });
              $item.append($logosContainer);
            }

            else if (item.type === 'custom_html') {
              $item.append(`<textarea class="field-html" placeholder="کد HTML">${item.html || ''}</textarea>`);
            }
          } else if (name === 'about_boxes') {
            $item.append(`<input type="text" placeholder="عنوان" class="field-title" value="${item.title || ''}">`);
            $item.append(`<input type="text" placeholder="توضیح کوتاه" class="field-small-text" value="${item.short_desc || ''}">`);
            $item.append(`<input type="text" placeholder="آدرس تصویر" class="field-image" value="${item.image || ''}" style="width:180px;">`);
            $item.append(`<button type="button" class="button button-upload">انتخاب تصویر</button>`);
            if (item.image) $item.append(`<img src="${item.image}" class="field-image-preview">`);
          }

          const $removeBtn = $('<button type="button" class="button">حذف</button>');
          $removeBtn.on('click', function () {
            const id = $(this).closest('.custom-list-item').data('id');
            items = items.filter(i => i._uuid !== id);
            save();
            render();
          });

          $item.append($removeBtn);
          $list.append($item);
        });


        let canAdd = true;
        if (isAboutBoxes && items.length >= 4) canAdd = false;
        if (canAdd) {
          const $addBtn = $('<button type="button" class="button button-primary" style="margin-top:5px;">افزودن آیتم جدید</button>');
          $addBtn.on('click', function () {
            let newItem;
            if (name === 'about_boxes') {
              newItem = { title: '', short_desc: '', image: '', _uuid: Math.random().toString(36).substring(2, 10) };
            } else if (name === 'slider') {
              newItem = { discount_title: '', date_fa: '', time: '', title: '', image: '', small_text: '', link: '', _uuid: Math.random().toString(36).substring(2, 10) };
            } else if (name === 'user_panel_slider') {
              newItem = { image: '', link: '', _uuid: Math.random().toString(36).substring(2, 10) };
            } else if (name === 'product_categories') {
              newItem = { icon: '', name: '', link: '', _uuid: Math.random().toString(36).substring(2, 10) };
            } else if (name === 'socials') {
              newItem = { icon: '', name: '', link: '', _uuid: Math.random().toString(36).substring(2, 10) };
            } else if (name === 'site_menu') {
              newItem = { name: '', link: '', icon: '', _uuid: Math.random().toString(36).substring(2, 10) };
            } else if (name === 'navbar_menu') {
              newItem = { name: '', link: '', _uuid: Math.random().toString(36).substring(2, 10) };
            } else if (name === 'job_positions_list') {
              newItem = { title: '', description: '', job_type: 'تمام وقت', skills: '', _uuid: Math.random().toString(36).substring(2, 10) };
            } else if (name === 'faq_list') {
              newItem = { question: '', answer: '', _uuid: Math.random().toString(36).substring(2, 10) };
            } else if (name === 'site_badges') {
              newItem = { html: '', _uuid: Math.random().toString(36).substring(2, 10) };
            } else if (name === 'footer_menu_1' || name === 'footer_menu_2') {
              newItem = { name: '', link: '', _uuid: Math.random().toString(36).substring(2, 10) };
            } else if (name === 'home_sections') {
              let defaultType = 'products';

              newItem = {
                type: defaultType,
                icon: '',
                name: '',
                link: '',
                product_cats: [],
                product_count: 4,
                product_sort: 'popularity',
                blog_cats: [],
                html: '',
                banner_count: 1,
                banner_style: 'style1',
                banners: [{ desktop_image: '', mobile_image: '', link: '' }],
                slider_style: 'style1',
                slider_count: 1,
                slides: [{ discount_title: '', date_fa: '', time: '', title: '', image: '', small_text: '', link: '' }],
                logo_count: 1,
                logos: [{ image: '', link: '', alt: '' }],
                _uuid: Math.random().toString(36).substring(2, 10)
              };
            }
            items.push(newItem);
            save();
            render();
          });
          $wrapper.append($list).append($addBtn);
        } else {
          $wrapper.append($list);
        }
      }

      function save() {
        $wrapper.find('.custom-list-item').each(function () {
          const $item = $(this);
          const id = $item.data('id');
          const index = items.findIndex(i => i._uuid === id);
          if (index !== -1) {
            if (name === 'about_boxes') {
              items[index].title = $item.find('.field-title').val();
              items[index].short_desc = $item.find('.field-small-text').val();
              items[index].image = $item.find('.field-image').val();
            } else if (name === 'slider') {
              items[index].discount_title = $item.find('.field-discount-title').val();
              items[index].date_fa = $item.find('.field-date').val();
              items[index].time = $item.find('.field-time').val();
              items[index].title = $item.find('.field-title').val();
              items[index].image = $item.find('.field-image').val();
              items[index].small_text = $item.find('.field-small-text').val();
              items[index].link = $item.find('.field-link').val();

              var dateFa = items[index].date_fa;
              var time = items[index].time;
              if (dateFa && time && window.persianDate) {
                try {
                  var pd = new persianDate().parse(dateFa + ' ' + time);
                  var g = pd.toGregorian();
                  var gDate = new Date(g.year, g.month - 1, g.day, ...time.split(':'));
                  items[index].date_gregorian = gDate.toISOString();
                } catch (e) {
                  items[index].date_gregorian = '';
                }
              } else {
                items[index].date_gregorian = '';
              }
            } else if (items[index].type === 'logo_slider') {
              items[index].name = $item.find('.field-name').val();
              items[index].logo_count = $item.find('.field-logo-count').val();
              items[index].logos = [];
              $item.find('.logo-item').each(function () {
                const $logoItem = $(this);
                items[index].logos.push({
                  image: $logoItem.find('.field-logo-image').val(),
                  link: $logoItem.find('.field-logo-link').val(),
                  alt: $logoItem.find('.field-logo-alt').val()
                });
              });
            }

            else if (name === 'user_panel_slider') {
              items[index].image = $item.find('.field-image').val();
              items[index].link = $item.find('.field-link').val();
            } else if (name === 'product_categories') {
              items[index].icon = $item.find('.field-icon').val();
              items[index].name = $item.find('.field-name').val();
              items[index].link = $item.find('.field-link').val();
            } else if (name === 'socials') {
              items[index].icon = $item.find('.field-icon').val();
              items[index].name = $item.find('.field-name').val();
              items[index].link = $item.find('.field-link').val();
            } else if (name === 'site_menu') {
              items[index].name = $item.find('.field-name').val();
              items[index].link = $item.find('.field-link').val();
              items[index].icon = $item.find('.field-icon').val();
            } else if (name === 'navbar_menu') {
              items[index].name = $item.find('.field-name').val();
              items[index].link = $item.find('.field-link').val();
            } else if (name === 'job_positions_list') {
              items[index].title = $item.find('.field-title').val();
              items[index].description = $item.find('.field-description').val();
              items[index].job_type = $item.find('.field-job-type').val();
              items[index].skills = $item.find('.field-skills').val();
            } else if (name === 'faq_list') {
              items[index].question = $item.find('.field-question').val();
              items[index].answer = $item.find('.field-answer').val();
            } else if (name === 'site_badges') {
              items[index].html = $item.find('.field-html').val();
            } else if (name === 'footer_menu_1' || name === 'footer_menu_2') {
              items[index].name = $item.find('.field-name').val();
              items[index].link = $item.find('.field-link').val();
            } else if (name === 'home_sections') {
              items[index].type = $item.find('.field-section-type').val();
              if (items[index].type === 'products') {
                items[index].icon = $item.find('.field-icon').val();
                items[index].name = $item.find('.field-name').val();
                items[index].link = $item.find('.field-link').val();

                items[index].product_cats = [];
                $item.find('.field-product-cats-list .cat-chip').each(function () {
                  let id = $(this).data('id');
                  if (typeof id === 'string' && /^\d+$/.test(id)) id = parseInt(id);
                  items[index].product_cats.push({
                    id: id,
                    name: $(this).contents().get(0).nodeValue.trim()
                  });
                });
                items[index].product_count = $item.find('.field-product-count').val();
                items[index].product_sort = $item.find('.field-product-sort').val();
              } else if (items[index].type === 'special_products') {
                items[index].icon = $item.find('.field-icon').val();
                items[index].name = $item.find('.field-name').val();
                items[index].product_count = $item.find('.field-product-count').val();
              } else if (items[index].type === 'blog_posts') {
                items[index].blog_cats = [];
                $item.find('.field-blog-cats-list .cat-chip').each(function () {
                  let id = $(this).data('id');
                  if (typeof id === 'string' && /^\d+$/.test(id)) id = parseInt(id);
                  items[index].blog_cats.push({
                    id: id,
                    name: $(this).contents().get(0).nodeValue.trim()
                  });
                });
              } else if (items[index].type === 'custom_html') {
                items[index].html = $item.find('.field-html').val();
              } else if (items[index].type === 'banners') {
                items[index].banner_count = $item.find('.field-banner-count').val();
                items[index].banner_style = $item.find('.field-banner-style').val();
                items[index].banners = [];
                $item.find('.banner-item').each(function () {
                  const $bannerItem = $(this);
                  items[index].banners.push({
                    desktop_image: $bannerItem.find('.field-banner-desktop-image').val(),
                    mobile_image: $bannerItem.find('.field-banner-mobile-image').val(),
                    link: $bannerItem.find('.field-banner-link').val()
                  });
                });
              } else if (items[index].type === 'slider') {
                items[index].slider_style = $item.find('.field-slider-style').val();
                items[index].slider_count = $item.find('.field-slider-count').val();
                items[index].slides = [];
                $item.find('.slide-item').each(function () {
                  const $slideItem = $(this);
                  const style = items[index].slider_style;

                  if (style === 'style1') {
                    items[index].slides.push({
                      discount_title: $slideItem.find('.field-slide-discount-title').val(),
                      date_fa: $slideItem.find('.field-slide-date').val(),
                      time: $slideItem.find('.field-slide-time').val(),
                      title: $slideItem.find('.field-slide-title').val(),
                      image: $slideItem.find('.field-slide-image').val(),
                      small_text: $slideItem.find('.field-slide-small-text').val(),
                      link: $slideItem.find('.field-slide-link').val()
                    });
                  } else if (style === 'style2') {
                    items[index].slides.push({
                      small_text: $slideItem.find('.field-slide-small-text').val(),
                      title: $slideItem.find('.field-slide-title').val(),
                      image: $slideItem.find('.field-slide-image').val(),
                      link: $slideItem.find('.field-slide-link').val()
                    });
                  } else if (style === 'style3') {
                    items[index].slides.push({
                      desktop_image: $slideItem.find('.field-slide-desktop-image').val(),
                      mobile_image: $slideItem.find('.field-slide-mobile-image').val(),
                      link: $slideItem.find('.field-slide-link').val()
                    });
                  } else if (style === 'style4') {
                    items[index].slides.push({
                      desktop_image: $slideItem.find('.field-slide-desktop-image').val(),
                      mobile_image: $slideItem.find('.field-slide-mobile-image').val(),
                      link: $slideItem.find('.field-slide-link').val()
                    });
                  }
                });
              } else if (items[index].type === 'site_description_box') {

                items[index] = { type: 'site_description_box', _uuid: items[index]._uuid };
              }
            }
          }
        });
        $textarea.val(JSON.stringify(items));
      }


      $wrapper.on('click', '.button-upload', function (e) {
        e.preventDefault();
        const $item = $(this).closest('.custom-list-item');
        let $input;
        if (name === 'product_categories') {
          $input = $item.find('.field-icon');
        } else {
          $input = $item.find('.field-image');
        }
        let frame = wp.media({ title: 'انتخاب تصویر', multiple: false });
        frame.on('select', function () {
          let attachment = frame.state().get('selection').first().toJSON();
          $input.val(attachment.url);
          $item.find('.field-image-preview').remove();
          $input.after(`<img src="${attachment.url}" class="field-image-preview">`);
          $input.trigger('input');
        });
        frame.open();
      });


      $wrapper.on('click', '.button-upload-slide', function (e) {
        e.preventDefault();
        const $button = $(this);
        const type = $button.data('type');
        const slideIdx = $button.data('slide');
        const $slideItem = $button.closest('.slide-item');
        let $input;

        if (type === 'image') {
          $input = $slideItem.find('.field-slide-image');
        } else if (type === 'desktop') {
          $input = $slideItem.find('.field-slide-desktop-image');
        } else if (type === 'mobile') {
          $input = $slideItem.find('.field-slide-mobile-image');
        }

        let title = 'انتخاب تصویر';
        if (type === 'desktop') title = 'انتخاب تصویر دسکتاپ';
        else if (type === 'mobile') title = 'انتخاب تصویر موبایل';

        let frame = wp.media({ title: title, multiple: false });
        frame.on('select', function () {
          let attachment = frame.state().get('selection').first().toJSON();
          $input.val(attachment.url);

          $input.nextAll('.field-image-preview').remove();
          $input.after(`<img src="${attachment.url}" class="field-image-preview" style="max-width:40px;max-height:40px;margin-left:5px;vertical-align:middle;">`);
          $input.trigger('input');
        });
        frame.open();
      });


      $wrapper.on('click', '.button-upload-banner', function (e) {
        e.preventDefault();
        const $button = $(this);
        const type = $button.data('type');
        const bannerIdx = $button.data('banner');
        const $bannerItem = $button.closest('.banner-item');
        let $input = $bannerItem.find(`.field-banner-${type}-image`);

        let frame = wp.media({ title: `انتخاب تصویر ${type === 'desktop' ? 'دسکتاپ' : 'موبایل'}`, multiple: false });
        frame.on('select', function () {
          let attachment = frame.state().get('selection').first().toJSON();
          $input.val(attachment.url);

          $input.nextAll('.field-image-preview').remove();
          $input.after(`<img src="${attachment.url}" class="field-image-preview" style="max-width:50px;max-height:50px;margin:2px;">`);
          $input.trigger('input');
        });
        frame.open();
      });


      $wrapper.on('click', '.button-upload-logo', function (e) {
        e.preventDefault();
        const $button = $(this);
        const logoIdx = $button.data('logo');
        const $logoItem = $button.closest('.logo-item');
        let $input = $logoItem.find('.field-logo-image');

        let frame = wp.media({ title: 'انتخاب لوگو', multiple: false });
        frame.on('select', function () {
          let attachment = frame.state().get('selection').first().toJSON();
          $input.val(attachment.url);

          $input.nextAll('.field-image-preview').remove();
          $input.after(`<img src="${attachment.url}" class="field-image-preview" style="max-width:40px;max-height:40px;margin-left:5px;vertical-align:middle;">`);
          $input.trigger('input');
        });
        frame.open();
      });


      $wrapper.on('input', 'input, textarea, select', function () {
        save();
      });


      $wrapper.on('change', '.field-section-type', function () {
        const $item = $(this).closest('.custom-list-item');
        const id = $item.data('id');
        const index = items.findIndex(i => i._uuid === id);
        if (index !== -1) {
          const newType = $(this).val();
          items[index].type = newType;


          if (newType === 'banners') {
            items[index].banner_count = 1;
            items[index].banners = [{ desktop_image: '', mobile_image: '', link: '' }];
          } else if (newType === 'slider') {
            items[index].slider_style = 'style1';
            items[index].slider_count = 1;
            items[index].slides = [{ discount_title: '', date_fa: '', time: '', title: '', image: '', small_text: '', link: '' }];
          }

          save();
          render();
        }
      });


      $wrapper.on('input change', '.field-banner-count', function () {
        const $item = $(this).closest('.custom-list-item');
        const id = $item.data('id');
        const index = items.findIndex(i => i._uuid === id);
        if (index !== -1) {
          const newCount = parseInt($(this).val()) || 1;
          let currentBanners = items[index].banners || [];


          if (newCount > currentBanners.length) {

            for (let i = currentBanners.length; i < newCount; i++) {
              currentBanners.push({ desktop_image: '', mobile_image: '', link: '' });
            }
          } else if (newCount < currentBanners.length) {

            currentBanners = currentBanners.slice(0, newCount);
          }

          items[index].banner_count = newCount;
          items[index].banners = currentBanners;
          save();


          const $bannersContainer = $item.find('.banners-container');
          $bannersContainer.empty();

          currentBanners.forEach((banner, bannerIdx) => {
            const $bannerItem = $('<div class="banner-item" style="background:linear-gradient(135deg, #e0fae2 0%, #e0fae2 100%);padding:16px;margin:10px 0;border-radius:12px;border:2px solid #e1e8ed;box-shadow:0 2px 8px rgba(0,0,0,0.08);transition:all 0.3s ease;"></div>');

            // Header بنر با آیکون
            $bannerItem.append(`<div style="display:flex;align-items:center;margin-bottom:14px;padding-bottom:10px;border-bottom:2px solid rgba(255,255,255,0.6);">
              <span style="font-size:20px;margin-left:8px;">🖼️</span>
              <h4 style="margin:0;color:#2c3e50;font-size:15px;font-weight:600;">بنر شماره ${bannerIdx + 1}</h4>
            </div>`);

            // بخش تصویر دسکتاپ
            const desktopPreview = banner.desktop_image
              ? `<div style="margin-top:8px;"><img src="${banner.desktop_image}" class="field-image-preview" style="max-width:120px;max-height:80px;border-radius:8px;border:2px solid #fff;box-shadow:0 2px 6px rgba(0,0,0,0.1);"></div>`
              : '';
            $bannerItem.append(`
              <div style="margin-bottom:14px;background:rgba(255,255,255,0.7);padding:12px;border-radius:8px;">
                <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#34495e;">
                  <span style="font-size:16px;margin-left:6px;">💻</span>
                  تصویر دسکتاپ:
                </label>
                <div style="display:flex;align-items:center;gap:8px;flex-wrap:wrap;">
                  <input type="text" placeholder="آدرس تصویر دسکتاپ" class="field-banner-desktop-image" value="${banner.desktop_image || ''}" style="flex:1;min-width:200px;padding:8px 12px;border:1px solid #d1d8e0;border-radius:6px;font-size:13px;background:#fff;">
                  <button type="button" class="button button-primary button-upload-banner" data-type="desktop" data-banner="${bannerIdx}" style="padding:8px 16px;font-size:13px;border-radius:6px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
                    <span style="margin-left:4px;">📁</span> انتخاب تصویر
                  </button>
                </div>
                ${desktopPreview}
              </div>
            `);

            // بخش تصویر موبایل
            const mobilePreview = banner.mobile_image
              ? `<div style="margin-top:8px;"><img src="${banner.mobile_image}" class="field-image-preview" style="max-width:80px;max-height:80px;border-radius:8px;border:2px solid #fff;box-shadow:0 2px 6px rgba(0,0,0,0.1);"></div>`
              : '';
            $bannerItem.append(`
              <div style="margin-bottom:14px;background:rgba(255,255,255,0.7);padding:12px;border-radius:8px;">
                <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#34495e;">
                  <span style="font-size:16px;margin-left:6px;">📱</span>
                  تصویر موبایل:
                </label>
                <div style="display:flex;align-items:center;gap:8px;flex-wrap:wrap;">
                  <input type="text" placeholder="آدرس تصویر موبایل" class="field-banner-mobile-image" value="${banner.mobile_image || ''}" style="flex:1;min-width:200px;padding:8px 12px;border:1px solid #d1d8e0;border-radius:6px;font-size:13px;background:#fff;">
                  <button type="button" class="button button-primary button-upload-banner" data-type="mobile" data-banner="${bannerIdx}" style="padding:8px 16px;font-size:13px;border-radius:6px;box-shadow:0 2px 4px rgba(0,0,0,0.1);">
                    <span style="margin-left:4px;">📁</span> انتخاب تصویر
                  </button>
                </div>
                ${mobilePreview}
              </div>
            `);

            // بخش لینک
            $bannerItem.append(`
              <div style="background:rgba(255,255,255,0.7);padding:12px;border-radius:8px;">
                <label style="display:flex;align-items:center;margin-bottom:8px;font-size:13px;font-weight:600;color:#34495e;">
                  <span style="font-size:16px;margin-left:6px;">🔗</span>
                  لینک بنر:
                </label>
                <input type="text" placeholder="https://example.com" class="field-banner-link" value="${banner.link || ''}" style="width:100%;padding:8px 12px;border:1px solid #d1d8e0;border-radius:6px;font-size:13px;background:#fff;">
              </div>
            `);

            $bannersContainer.append($bannerItem);
          });
        }
      });


      $wrapper.on('change', '.field-slider-style', function () {
        const $item = $(this).closest('.custom-list-item');
        const id = $item.data('id');
        const index = items.findIndex(i => i._uuid === id);
        if (index !== -1) {
          const newStyle = $(this).val();
          const slideCount = parseInt(items[index].slider_count) || 1;
          items[index].slider_style = newStyle;


          items[index].slides = [];
          for (let i = 0; i < slideCount; i++) {
            if (newStyle === 'style1') {
              items[index].slides.push({ discount_title: '', date_fa: '', time: '', title: '', image: '', small_text: '', link: '' });
            } else if (newStyle === 'style2') {
              items[index].slides.push({ small_text: '', title: '', image: '', link: '' });
            } else if (newStyle === 'style3') {
              items[index].slides.push({ desktop_image: '', mobile_image: '', link: '' });
            } else if (newStyle === 'style4') {
              items[index].slides.push({ desktop_image: '', mobile_image: '', link: '' });
            }
          }

          save();
          render();
        }
      });


      $wrapper.on('input change', '.field-slider-count', function () {
        const $item = $(this).closest('.custom-list-item');
        const id = $item.data('id');
        const index = items.findIndex(i => i._uuid === id);
        if (index !== -1) {
          const newCount = parseInt($(this).val()) || 1;
          const currentStyle = items[index].slider_style || 'style1';
          let currentSlides = items[index].slides || [];


          if (newCount > currentSlides.length) {

            for (let i = currentSlides.length; i < newCount; i++) {
              if (currentStyle === 'style1') {
                currentSlides.push({ discount_title: '', date_fa: '', time: '', title: '', image: '', small_text: '', link: '' });
              } else if (currentStyle === 'style2') {
                currentSlides.push({ small_text: '', title: '', image: '', link: '' });
              } else if (currentStyle === 'style3') {
                currentSlides.push({ desktop_image: '', mobile_image: '', link: '' });
              }
            }
          } else if (newCount < currentSlides.length) {

            currentSlides = currentSlides.slice(0, newCount);
          }

          items[index].slider_count = newCount;
          items[index].slides = currentSlides;
          save();
          render();
        }
      });

      $wrapper.on('input change', '.field-logo-count', function () {
        const $item = $(this).closest('.custom-list-item');
        const id = $item.data('id');
        const index = items.findIndex(i => i._uuid === id);
        if (index !== -1) {
          const newCount = parseInt($(this).val()) || 1;
          let currentLogos = items[index].logos || [];


          if (newCount > currentLogos.length) {

            for (let i = currentLogos.length; i < newCount; i++) {
              currentLogos.push({ image: '', link: '', alt: '' });
            }
          } else if (newCount < currentLogos.length) {

            currentLogos = currentLogos.slice(0, newCount);
          }

          items[index].logo_count = newCount;
          items[index].logos = currentLogos;
          save();
          render();
        }
      });


      setTimeout(function () {
        $('.custom-list-wrap[data-name="slider"] .field-date').persianDatepicker({
          format: 'YYYY/MM/DD',
          autoClose: true,
          initialValue: false,
          calendar: { persian: { locale: 'fa' } }
        });

        $('.slide-item .field-slide-date').persianDatepicker({
          format: 'YYYY/MM/DD',
          autoClose: true,
          initialValue: false,
          calendar: { persian: { locale: 'fa' } }
        });
      }, 500);

      render();


      $wrapper.on('input', '.field-product-cat-search', function () {
        const $item = $(this).closest('.custom-list-item');
        const q = $(this).val();
        const $results = $item.find('.product-cat-search-results');
        $results.empty();
        if (q.length < 2) return;
        let siteUrl = window.location.origin;

        $results.html('<div class="cat-loading">در حال جستجو...</div>');
        if (window.ajaxurl) {
          const parser = document.createElement('a');
          parser.href = window.ajaxurl;
          siteUrl = parser.origin + parser.pathname.replace(/\/wp-admin.*/, '');
        }
        $.get(siteUrl + '/wp-json/theme-settings/v1/product-categories', { search: q }, function (data) {
          $results.empty();
          if (Array.isArray(data)) {

            let selected = [];
            $item.find('.field-product-cats-list .cat-chip').each(function () {
              selected.push($(this).data('id'));
            });
            let hasResult = false;
            data.forEach(cat => {
              if (!selected.includes(cat.id)) {
                $results.append(`<div class="cat-result" data-id="${cat.id}" data-name="${cat.name}">${cat.name}</div>`);
                hasResult = true;
              }
            });
            if (!hasResult) $results.append('<div class="cat-no-result">نتیجه‌ای یافت نشد</div>');
          } else {
            $results.append('<div class="cat-no-result">نتیجه‌ای یافت نشد</div>');
          }
        });
        $results.addClass('cat-dropdown');
      });
      $wrapper.on('click', '.product-cat-search-results .cat-result', function () {
        const $item = $(this).closest('.custom-list-item');
        const id = $(this).data('id');
        const name = $(this).data('name');

        const $catList = $item.find('.field-product-cats-list');
        if ($catList.find(`[data-id='${id}']`).length) return;
        $catList.append(`<span class="cat-chip" data-id="${id}">${name} <b style='cursor:pointer;' class='remove-cat'>&times;</b></span>`);
        $item.find('.product-cat-search-results').empty();
        save();
      });
      $wrapper.on('click', '.field-product-cats-list .remove-cat', function () {
        const $chip = $(this).closest('.cat-chip');
        $chip.remove();
        save();
      });

      $wrapper.on('input', '.field-blog-cat-search', function () {
        const $item = $(this).closest('.custom-list-item');
        const q = $(this).val();
        const $results = $item.find('.blog-cat-search-results');
        $results.empty();
        if (q.length < 2) return;
        $results.html('<div class="cat-loading">در حال جستجو...</div>');
        let siteUrl = window.location.origin;
        if (window.ajaxurl) {
          const parser = document.createElement('a');
          parser.href = window.ajaxurl;
          siteUrl = parser.origin + parser.pathname.replace(/\/wp-admin.*/, '');
        }
        $.get(siteUrl + '/wp-json/wp/v2/categories', { search: q, per_page: 10 }, function (data) {
          $results.empty();
          if (Array.isArray(data)) {

            let selected = [];
            $item.find('.field-blog-cats-list .cat-chip').each(function () {
              selected.push($(this).data('id'));
            });
            let hasResult = false;
            data.forEach(cat => {
              if (!selected.includes(cat.id)) {
                $results.append(`<div class="cat-result" data-id="${cat.id}" data-name="${cat.name}">${cat.name}</div>`);
                hasResult = true;
              }
            });
            if (!hasResult) $results.append('<div class="cat-no-result">نتیجه‌ای یافت نشد</div>');
          } else {
            $results.append('<div class="cat-no-result">نتیجه‌ای یافت نشد</div>');
          }
        });
        $results.addClass('cat-dropdown');
      });
      $wrapper.on('click', '.blog-cat-search-results .cat-result', function () {
        const $item = $(this).closest('.custom-list-item');
        const id = $(this).data('id');
        const name = $(this).data('name');
        const $catList = $item.find('.field-blog-cats-list');
        if ($catList.find(`[data-id='${id}']`).length) return;
        $catList.append(`<span class="cat-chip" data-id="${id}">${name} <b style='cursor:pointer;' class='remove-cat'>&times;</b></span>`);
        $item.find('.blog-cat-search-results').empty();
        save();
      });
      $wrapper.on('click', '.field-blog-cats-list .remove-cat', function () {
        const $chip = $(this).closest('.cat-chip');
        $chip.remove();
        save();
      });

      if (!document.getElementById('cat-chip-style')) {
        const chipCss = `
        .cat-chip { display:inline-flex;align-items:center;background:#e3f2fd;color:#1976d2;border-radius:16px;padding:2px 10px 2px 6px;margin:2px 4px 2px 0;font-size:13px;box-shadow:0 1px 4px #1976d211;transition:background .2s; }
        .cat-chip b.remove-cat {margin-right:4px;font-size:15px;line-height:1;}
        .cat-chip:hover {background:#bbdefb;}
        .cat-dropdown {position:absolute;right:0;left:0;top:100%;background:#fff;border:1px solid #1976d2;border-radius:0 0 10px 10px;box-shadow:0 4px 16px #1976d222;z-index:1001;max-height:220px;overflow:auto;margin-top:2px;}
        .cat-result {padding:8px 12px;cursor:pointer;transition:background .15s;}
        .cat-result:hover {background:#e3f2fd;}
        .cat-loading {padding:8px 12px;color:#1976d2;font-size:13px;}
        .cat-no-result {padding:8px 12px;color:#888;font-size:13px;}
        .banners-container {width:100%;margin-top:10px;}
        .banner-item {transition:all 0.3s ease!important;}
        .banner-item:hover {transform:translateY(-2px)!important;box-shadow:0 4px 12px rgba(0,0,0,0.12)!important;}
        .banner-item input[type="text"]:focus {outline:none!important;border-color:#3498db!important;box-shadow:0 0 0 3px rgba(52,152,219,0.1)!important;}
        .banner-item .button-upload-banner:hover {background:#2980b9!important;transform:scale(1.02)!important;}
        .banner-item .field-image-preview {transition:transform 0.2s ease!important;}
        .banner-item .field-image-preview:hover {transform:scale(1.5)!important;z-index:100!important;position:relative!important;cursor:zoom-in!important;}
        .slides-container {width:100%;margin-top:10px;}
        .slide-item {transition:all 0.3s ease!important;}
        .slide-item:hover {transform:translateY(-2px)!important;box-shadow:0 4px 12px rgba(0,188,212,0.25)!important;}
        .slide-item input[type="text"]:focus, .slide-item input[type="time"]:focus {outline:none!important;border-color:#00bcd4!important;box-shadow:0 0 0 3px rgba(0,188,212,0.1)!important;}
        .slide-item .button-upload-slide:hover {background:#0097a7!important;transform:scale(1.02)!important;}
        .slide-item .field-image-preview {transition:transform 0.2s ease!important;}
        .slide-item .field-image-preview:hover {transform:scale(1.5)!important;z-index:100!important;position:relative!important;cursor:zoom-in!important;}
        .logos-container {width:100%;margin-top:10px;}
        .logo-item {transition:all 0.3s ease!important;}
        .logo-item:hover {transform:translateY(-2px)!important;box-shadow:0 4px 12px rgba(255,152,0,0.25)!important;}
        .logo-item input[type="text"]:focus {outline:none!important;border-color:#ff9800!important;box-shadow:0 0 0 3px rgba(255,152,0,0.1)!important;}
        .logo-item .button-upload-logo:hover {background:#f57c00!important;transform:scale(1.02)!important;}
        .logo-item .field-image-preview {transition:transform 0.2s ease!important;}
        .logo-item .field-image-preview:hover {transform:scale(1.3)!important;z-index:100!important;position:relative!important;cursor:zoom-in!important;}
        .field-product-cat-search:focus, .field-blog-cat-search:focus {outline:none!important;border-color:#1976d2!important;box-shadow:0 0 0 4px rgba(25,118,210,0.1)!important;transform:scale(1.01)!important;}
        select.field-product-sort:focus {outline:none!important;border-color:#ab47bc!important;box-shadow:0 0 0 3px rgba(171,71,188,0.1)!important;}
        `;
        $('<style id="cat-chip-style">' + chipCss + '</style>').appendTo('head');
      }
    });


    const $mainTab = $('#tab-content-main');
    const $homeSectionsWrap = $('.custom-list-wrap[data-name="home_sections"]').parent();
    const $homeSectionsCount = $("input[name='custom_theme_options[home_sections_count]']").closest('tr, p, div');
    if ($mainTab.length) {

      $mainTab.append($homeSectionsCount);
      $mainTab.append($homeSectionsWrap);
    }

    $homeSectionsWrap.hide();
    $homeSectionsCount.hide();


    const $styleTab = $('#tab-content-style');
    const styleFields = [
      'product_carousel_style',
      'header_style',
      'footer_style',
      'category_card_style',
      'product_page_style',
      'container_style',
      'category_page_style',
    ];

    const $styleFieldElements = [];
    styleFields.forEach(function (fieldName) {
      const $field = $("select[name='custom_theme_options[" + fieldName + "]']").closest('tr');
      if ($field.length) {
        $styleFieldElements.push($field);
      }
    });

    if ($styleTab.length && $styleFieldElements.length) {

      $styleFieldElements.forEach(function ($field) {
        $styleTab.append($field);
        $field.hide();
      });
    }


    $(document).on('click', '.custom-tab-btn', function () {
      const tabName = $(this).data('tab');


      if (tabName === 'main') {
        $homeSectionsWrap.show();
        $homeSectionsCount.show();
      } else {
        $homeSectionsWrap.hide();
        $homeSectionsCount.hide();
      }


      if (tabName === 'style') {
        $styleFieldElements.forEach(function ($field) {
          $field.show();
        });
      } else {
        $styleFieldElements.forEach(function ($field) {
          $field.hide();
        });
      }
    });

  });
})(jQuery);
