<?php
$cls = sprintf('col-12 col-md-6 col-sm-6 col-xs-6 col-lg-%s clearfix', $settings['layout_col']);

while ($wc_query->have_posts()):
    $wc_query->the_post();
    $product = wc_get_product(get_the_ID());
?>

    <div class="<?php echo esc_attr($cls); ?>">
        <div class="product-item-wrapper">
            <div class="product-thumbnail">
                <?php echo get_the_post_thumbnail(); ?>
            </div>
            <article class="grid-products5-content">
                <h3 class="product-title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h3>
                <p class="product-price-wrapper">
                    <?php if($settings['price_prefix'] && $settings['show_price_prefix'] === 'yes'): ?>
                        <?php echo sanitize_text_field($settings['price_prefix']); ?>
                    <?php endif; ?>
                    <?php
                    if ($product->is_type('variable')) {
                        $variation_prices = [];
                        foreach ($product->get_available_variations() as $variation) {
                            $variation_prices[] = $variation['display_price'];
                        }
                        if($variation_prices) {
                            $lowest_price = min($variation_prices);
                            if($settings['show_in_thousands'] === 'yes' && is_numeric($lowest_price))
                                $lowest_price = $lowest_price / 1000;
                            echo wc_price($lowest_price);
                        }
                    } else {
                        $product_price = $product->get_price();
                        if($settings['show_in_thousands'] === 'yes' && is_numeric($product_price))
                            $product_price = $product_price / 1000;
                        echo wc_price($product_price);
                    }
                    ?>
                </p>
                <div class="d-flex justify-content-between align-items-center product-meta">
                    <?php if($settings['show_sale_stats'] === 'yes'): ?>
                        <div class="d-flex justify-content-center align-items-center total-sale-wrapper">
                            <span class="dot"></span>
                            <?php if($product->get_total_sales() == 0): ?>
                                <span class="total-sale px-1">
                                    <?php echo sanitize_text_field($settings['no_sell_stats']); ?>
                                </span>
                            <?php else: ?>
                                <span class="total-sale"><?php echo $product->get_total_sales(); ?></span>
                                <span class="post-fix">
                                    <?php echo sanitize_text_field($settings['sale_stats_postfix']); ?>
                                </span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <?php if($settings['button_text']): ?>
                        <a href="<?php the_permalink(); ?>" class="product-link">
                            <?php echo sanitize_text_field($settings['button_text']); ?>
                        </a>
                    <?php endif; ?>
                </div>
            </article>
        </div>
    </div>

<?php endwhile;
wp_reset_query();
wp_reset_postdata();
?>