 const handleShopCountdownElement = function (el)
{
    var mainDate = el.attr('mm-date');
    var dState = el.attr('d-state') === 'show';
    var hState = el.attr('h-state') === 'show';
    var countDownDate = new Date(parseInt(mainDate)).getTime();
    var x = setInterval(function() {
        var now = new Date().getTime();
        var distance = parseInt(countDownDate) - parseInt(now);
        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);

        var countdownHtml = '';

        if (dState) {
            countdownHtml += `<li><span>${days}</span><span>${wsc_data.translate.day}</span></li>`;
        }

        if (hState) {
            countdownHtml += `<li><span>${hours}</span><span>${wsc_data.translate.hour}</span></li>`;
        }

        countdownHtml += `<li><span>${minutes}</span><span>${wsc_data.translate.minute}</span></li>`;
        countdownHtml += `<li><span>${seconds}</span><span>${wsc_data.translate.seconds}</span></li>`;

        el.find('.countdown-content').html(countdownHtml);

        if (distance < 0) {
            clearInterval(x);
            el.find(".countdown-content").html(wsc_data.translate.finished);
        }
    }, 1000);
}

 jQuery(window).on('elementor/frontend/init', function (){
     elementorFrontend.hooks.addAction( 'frontend/element_ready/mwcountdown.default', function($scope, $) {
         let wrap = $scope.find('.shop-countdown-element');

         handleShopCountdownElement(wrap);
     });
 });