const handleTestimonialCarousel15Element = function (params) {
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: 1,
            spaceBetween: 20,
            breakpoints: {
                640: {
                    slidesPerView: 1,
                    spaceBetween: 10,
                },
                768: {
                    slidesPerView: 2,
                    spaceBetween: 20,
                },
                1024: {
                    slidesPerView: 3,
                    spaceBetween: 20,
                },
            },
        };

        if (params.showPagination) {
            options.pagination = {
                el: `.testimonial-carousel-15-${params.widgetID} .tc-swiper-pagination`,
                clickable: true,
            };
        }

        options.navigation = {
            nextEl: `.testimonial-carousel-15-${params.widgetID} .tc-swiper-button-next`,
            prevEl: `.testimonial-carousel-15-${params.widgetID} .tc-swiper-button-prev`,
        };

        if (params.autoPlay) {
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: false,
            };
        }

        if (params.observer === true) {
            options.observer = true;
            options.observeParents = true;
        }

        let tc_swiper = new Swiper(params.container, options);

        tc_swiper.on('slideChange', function () {
            const activeSlide = tc_swiper.slides[tc_swiper.activeIndex];
            const contentText = activeSlide.getAttribute('data-content');
            document.querySelector(`.testimonial-carousel-15-${params.widgetID} .testimonial-content .desc`).textContent = contentText;
        });

        const initialContent = tc_swiper.slides[tc_swiper.activeIndex].getAttribute('data-content');
        document.querySelector(`.testimonial-carousel-15-${params.widgetID} .testimonial-content .desc`).textContent = initialContent;
    }
}

jQuery(window).on('elementor/frontend/init', function () {
    elementorFrontend.hooks.addAction('frontend/element_ready/testimonial_carousel15.default', function ($scope, $) {
        let wrap = $scope.find('.testimonial-carousel-15'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');
            content =$scope.find('.content');

        sliderData.container = slider;

        handleTestimonialCarousel15Element(sliderData);

        content.css('opacity', 1);
    });
});
