const handleShopCategory8 = function (params){
    let options = {
        slidesPerView: params.mobilePerView,
        spaceBetween: 15,
        loop: true,
        navigation: {
            nextEl: params.nextButton,
            prevEl: params.prevButton,
        },
        breakpoints: {
            640: {
                slidesPerView: params.mobilePerView,
            },
            768: {
                slidesPerView: params.tabletPerView,
            },
            1024: {
                slidesPerView: params.desktopPerView,
            },
        },
    };

    if (params.autoPlay === true){
        options.autoplay = {
            delay: params.autoplayTimeout || 4500,
            disableOnInteraction: false,
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    let swiper = new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shop_category7.default', function($scope, $) {
        let wrap = $scope.find('.shop-category7'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        handleShopCategory8(sliderData);
    });
});