const handleShopCarousel7Element = function (params){
    let is_rtl = jQuery('body').hasClass('mw_rtl') ? true : false;
    params.container.owlCarousel({
        loop: params.loop,
        autoplay: params.autoplay,
        autoplayTimeout: params.autoplayTimeout,
        center: false,
        items: params.mobileSlidesPerView,
        rtl: is_rtl,
        margin: params.margin,
        navigation: true,
        navText : ["<i class='fa fa-3x fa-chevron-left'></i>","<i class='fa fa-3x fa-chevron-right'></i>"],
        responsive:{
            0:{
                items: params.mobileSlidesPerView
            },
            768:{
                items: params.tabletSlidesPerView
            },
            1024:{
                items: params.slidesPerView
            }
        }
    });
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shop_carousel7.default', function($scope, $) {
        let wrap = $scope.find('.shop-carousel7'),
            slider = wrap.find('.products-list-carousel'),
            sliderData = slider.data('slider');

        handleShopCarousel7Element({
            container: slider,
            loop: sliderData.loop || true,
            autoplay: sliderData.autoplay || false,
            autoplayTimeout: sliderData.autoplayTimeout || 3000,
            slidesPerView: sliderData.slidesPerView || 4,
            tabletSlidesPerView: sliderData.tabletSlidesPerView || 3,
            mobileSlidesPerView: sliderData.mobileSlidesPerView || 1,
            margin: sliderData.margin || 25,
        });
    });
});