const handleShopCarousel5Element = function (params){
    let options = {
        loop: params?.loop,
        autoplay: params?.autoplay,
        autoplayTimeout: params?.autoplayTimeout,
        slidesPerView: 1,
        spaceBetween: 10,
        freeMode: true,
        rtl: jQuery('body').hasClass('rtl'),
        breakpoints: {
            640: {
                slidesPerView: 2,
            },
            768: {
                slidesPerView: 3,
            },
            1024: {
                slidesPerView: params.cols,
            },
        },
    };

    if(params.navigation){
        options.navigation = {
            nextEl: ".swiper-btn-next",
            prevEl: ".swiper-btn-prev",
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shop_carousel5.default', function($scope, $) {
        let wrap = $scope.find('.shop-carousel5-wrap'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleShopCarousel5Element(sliderData);
    });
});