const handleShopCarousel11 = function (params){
    let options = {
        slidesPerView: params.mobilePerView,
        spaceBetween: 15,
        loop: true,
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        breakpoints: {
            640: {
                slidesPerView: params.mobilePerView,
            },
            768: {
                slidesPerView: params.tabletPerView,
            },
            1024: {
                slidesPerView: params.desktopPerView,
            },
        },
    };

    if (params.autoPlay === true){
        options.autoplay = {
            delay: params.autoplayTimeout || 4500,
            disableOnInteraction: false,
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    let swiper = new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shop_carousel11.default', function($scope, $) {
        let wrap = $scope.find('.shop-carousel11'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleShopCarousel11(sliderData);
    });
});