const handleProductsCategory2Element = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: params.mobilePerView,
            spaceBetween: 20,
            breakpoints: {
                640: {
                    slidesPerView: params.mobilePerView,
                    spaceBetween: 10,
                },
                768: {
                    slidesPerView: params.tabletPerView,
                    spaceBetween: 20,
                },
                1024: {
                    slidesPerView: params.slidesPerView,
                    spaceBetween: 20,
                },
            },
        };

        if (params.navigation) {
            options.navigation = {
                nextEl: `.ahura-products-category2-${params.widgetID} .apc-swiper-button-next`,
                prevEl: `.ahura-products-category2-${params.widgetID} .apc-swiper-button-prev`,
            }
        }

        if (params.autoPlay) {
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: false,
            }
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_products_category2.default', function($scope, $) {
        let wrap = $scope.find('.ahura-products-category2'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleProductsCategory2Element(sliderData);
    });
});