const handleProductBoxCarouselElement = function (params){
    let options = {
        loop: true,
        mousewheel: true,
        navigation: {
            nextEl: '.pbc-button-next',
            prevEl: '.pbc-button-prev',
        },
        breakpoints: {
            640: {
                slidesPerView: 2,
                spaceBetween: 5,
            },
            768: {
                slidesPerView: 2,
                spaceBetween: 5,
            },
            1024: {
                slidesPerView: 3,
                spaceBetween: 10,
            },
        },
    };

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    new Swiper(params.container, options);
}
jQuery(document).ready(function ($) {
    $('body').on('mouseenter', '.product-box-carousel-1 .product', function () {
        let box = $(this);
        if (box.find('.pbc-after .features').length > 0) {
            box.find('.pbc-before').slideUp();
            box.find('.pbc-after').slideDown();
        } else {
            box.find('.pbc-after.b').slideDown();
        }
    });

    $('body').on('mouseleave', '.product-box-carousel-1 .product', function () {
        let box = $(this);
        box.find('.pbc-before').slideDown();
        box.find('.pbc-after').slideUp();
    });
});

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/product_box_carousel.default', function($scope, $) {
        let wrap = $scope.find('.product-box-carousel-1-wrap'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleProductBoxCarouselElement(sliderData);
    });
});