const handlePostCarouse3Element = function(params){
    params.container.owlCarousel({
        center: false,
        loop: true,
        items: params.mobileSlidesPerView,
        lazyLoad: true,
        margin: 20,
        navigation: true,
        navText: ["<i class='fa fa-3x fa-chevron-left'></i>", "<i class='fa fa-3x fa-chevron-right'></i>"],
        responsive: {
            0:{
                items: params.mobileSlidesPerView
            },
            768:{
                items: params.tabletSlidesPerView
            },
            1024:{
                items: params.slidesPerView
            }
        }
    });
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/postcarousel3.default', function($scope, $) {
        let wrap = $scope.find('.post-carousel-3'),
            slider = wrap.find('.owl-slider-wrap'),
            sliderData = slider.data('slider') || null;

        handlePostCarouse3Element({
            container: slider,
            slidesPerView: sliderData.slidesPerView || 4,
            tabletSlidesPerView: sliderData.tabletSlidesPerView || 3,
            mobileSlidesPerView: sliderData.mobileSlidesPerView || 1,
        });
    });
});