const handlePostCarouselElement = function (params){
    params.container.owlCarousel({
        center: false,
        loop: false,
        items: params.mobileSlidesPerView,
        lazyLoad: true,
        margin: 35,
        navigation: true,
        navText: ["<i class='fa fa-3x fa-chevron-left'></i>", "<i class='fa fa-3x fa-chevron-right'></i>"],
        rtl: document.querySelector('body').classList.contains('rtl'),
        responsive: {
            0:{
                items: params.mobileSlidesPerView
            },
            767:{
                items: params.tabletSlidesPerView
            },
            1024:{
                items: params.slidesPerView
            }
        }
    });
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/postcarousel.default', function($scope, $) {
        let wrap = $scope.find('.post-carousel-element'),
            slider = wrap.find('.owl-post-carousel'),
            sliderData = slider.data('slider') || null;

        if(sliderData){
            sliderData.container = slider;

            handlePostCarouselElement(sliderData);
        }
    });
});