jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/image_slider5.default', function($scope, $) {
        let wrap = $scope.find('.image-slider-5-slides'),
            sliderData = wrap.data('slider');

        let sliderOptions = {
            loop: sliderData.loop || false,
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            navigation: {
                nextEl: ".swiper-btn-next",
                prevEl: ".swiper-btn-prev",
            },
        };

        if (sliderData.autoPlay === true){
            sliderOptions.autoplay = {
                delay: sliderData.transitionDuration || 4500,
                disableOnInteraction: false,
            };
        }

        if(sliderData.observer === true){
            sliderOptions.observer = true;
            sliderOptions.observeParents = true;
        }

        let swiper = new Swiper(wrap, sliderOptions);
    });
});