jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_countdown.default', function($scope, $) {
        let wrap = $scope.find('.ahura-countdown-element'),
            countdownData = wrap.data('countdown');

        let clock, currentDate, diff, futureDate, setcount;
        currentDate = new Date();
        futureDate = new Date(countdownData.time);
        diff = futureDate.getTime() / 1000 - (currentDate.getTime() / 1000);
        if (diff > -1) {
            setcount = diff;
        } else {
            setcount = 0;
        }

        FlipClock.Lang.Persian = {
            'years'   : countdownData.years,
            'months'  : countdownData.months,
            'day'    : countdownData.days,
            'hour'   : countdownData.hours,
            'minute' : countdownData.minutes,
            'seconds' : countdownData.seconds
        };

        FlipClock.Lang['fa']      = FlipClock.Lang.Persian;
        FlipClock.Lang['fa-ir']   = FlipClock.Lang.Persian;
        FlipClock.Lang['persian'] = FlipClock.Lang.Persian;

        clock = $('#clock-' + countdownData.wid).FlipClock(setcount, {
            clockFace: 'DailyCounter',
            countdown: true,
            language: countdownData.lang
        });

        if (diff < setcount) {
            wrap.find('#flipclock-' + countdownData.wid).html(countdownData.finishText);
        }
    });
});
