let html = document.getElementsByTagName('html');
let radios = document.getElementsByName('theme-mode-switch');
let dropdowns = document.querySelectorAll('.option-select-theme-switcher select');

if(radios.length){
	radios.forEach(function (input){
		let inputChangeEvent = function() {
			let mode = this.dataset.mode || this.value;
			html[0].classList.remove(html[0].dataset.theme);
			html[0].dataset.theme = mode;
			html[0].classList.add(mode);
			ahuraSetCookie('ahura-theme-mode', mode, 365);
		}

		input.addEventListener('change', inputChangeEvent);

		if(input.id === html[0].dataset.theme){
			input.checked = true;
			let event = new MouseEvent('mouseover', {
				view: window,
				bubbles: true,
				cancelable: true
			});
			document.querySelector(`label[for="${input.id}"]`).dispatchEvent(event);
		}

		if(dropdowns.length){
			dropdowns.forEach(function (select){
				select.addEventListener('change', inputChangeEvent);
			});
		}
	});
}