jQuery(document).ready(function($){
    let try_count = 0;

    $('body').on('click', '.ahura-section-select-ajax-load-options + .ajax-load', function(){
        let btn = $(this),
            select = btn.parent().find('select'),
            selectVal = select.val(),
            items, selected;
        $.ajax({
            url: ahura_data.au,
            data: {
                action: 'ahura_get_sections',
                type: select.data('type'),
                template_type: select.data('template'),
                post_id: selectVal,
                nonce: ahura_data.nonce
            },
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                btn.addClass('spin');
                select.attr('disabled', true);
            },
            success: function(res){
                btn.removeClass('spin');
                select.attr('disabled', false);

                if(res.count > 0){
                    items = res.items;
                    select.empty();
                    select.append(`<option value=""></option>`);
                    $.each(items, function(key, value){
                        selected = selectVal == value.ID ? 'selected="selected"' : '';
                        select.append(`<option ${selected} value="${value.ID}">${value.post_title}</option>`);
                    });
                }
            },
            error: function () {
                btn.removeClass('spin');
                select.attr('disabled', false);
            }
        })
    });

    $(document).on('click', '.ah-license-action-btn.danger-mode', function (e) {
        e.preventDefault()

        let el = $(this),
            isReloadingMode = false

        el.addClass('disabled')
        $.ajax({
            url: ahura_data.au,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'ahura_theme_change_license_status',
                nonce: ahura_data.nonce
            },
            beforeSend: function (){
                Swal.fire({
                    text: ahura_data.translate.request_is_progress,
                    timerProgressBar: false,
                    didOpen: () => {
                        Swal.showLoading();
                    },
                    willClose: () => {},
                    allowOutsideClick: () => false
                }).then((result) => {});
            },
            success: response => {
                if (response.hasOwnProperty('status') && response.status == 'success') {
                    isReloadingMode = true

                    if(response.redirect_url)
                    {
                        window.location.href = response.redirect_url
                    }else{
                        location.reload();
                    }
                }

                Swal.fire({
                    position: 'center-center',
                    icon: response.status,
                    text: response.msg,
                    showConfirmButton: false,
                    showCancelButton: false,
                    timer: 4000
                });
            },
            error: () => {
                Swal.fire({
                    position: 'center-center',
                    icon: 'error',
                    text: ahura_data.translate.unknown_error,
                    showConfirmButton: false,
                    showCancelButton: false,
                    timer: 4000
                });
            },
            complete: () => {
                if (!isReloadingMode) {
                    el.removeClass('disabled')
                }
            }
        })
    })

    $(document).on('click', '.ah-close-license-notice', function (e) {
        e.preventDefault()

        let el = $(this),
            wrap = el.closest('.ahura_license_notice_wrapper')

        $.ajax({
            url: ahura_data.au,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'ahura_dismiss_license_notice',
                nonce: ahura_data.nonce
            },
            success: response => {
                if (response.hasOwnProperty('success') && response.success == true) {
                    wrap.fadeOut();
                    location.reload();
                }
            },
            error: (e) => {
                console.error(e);
            },
        })
    })

    $('body').on('submit', '#ah-section-builder-form', function(e){
        e.preventDefault();
        let form = $(this);

        $.ajax({
            url: ahura_data.au,
            data: "action=ahura_create_section_builder_template&" + form.serialize() + '&nonce=' + ahura_data.nonce,
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                form.addClass('blur-loading');
            },
            complete: function(res){
                if (res){
                    response = res.responseJSON;
                    if (response.success == true){
                        window.location.href = response.data.redirect;
                        return false;
                    }
                }
                form.removeClass('blur-loading');
            },
            error: function () {
                form.removeClass('blur-loading');
            }
        })
    });
});