<?php

namespace ahura\inc\widgets;

// Block direct access to the main theme file.
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class video_carousel3 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        $this->register_elementor_script('video_carousel3_js', mw_assets::get_js('elementor.video_carousel3'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('video_carousel3_css', mw_assets::get_css('elementor.video_carousel3'));
    }

    public function get_script_depends()
    {
        return [$this->get_asset_handle_name('video_carousel3_js')];
    }

    public function get_name()
    {
        return 'video_carousel3';
    }

    public function get_title()
    {
        return esc_html__('Video Carousel 3', 'ahura');
    }

    public function get_icon()
    {
        return 'aicon-svg-video-carousel-2';
    }

    public function get_categories()
    {
        return ['ahuraelements'];
    }

    public function get_keywords()
    {
        return ['ahura', 'video', 'video carousel 3', esc_html__('ahura', 'ahura'), esc_html__('Video Carousel 3', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'display_settings',
            [
                'label' => esc_html__('Layout', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'item_video',
            [
                'label' => esc_html__( 'Choose Video', 'ahura' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'media_types' => ['video'],
            ]
        );

        $repeater->add_control(
            'item_video_cover',
            [
                'label' => esc_html__( 'Choose Video Cover', 'ahura' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'media_types' => ['image'],
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'show_item_head',
            [
                'label' => esc_html__('Show Header', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'item_head_more_options',
            [
                'label' => esc_html__( 'Header', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => ['show_item_head' => 'yes']
            ]
        );

        $repeater->add_control(
            'item_head_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-video',
                    'library' => 'fa-solid',
                ],
                'condition' => ['show_item_head' => 'yes']
            ]
        );

        $repeater->add_control(
            'item_head_title',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Training Video', 'ahura' ),
                'condition' => ['show_item_head' => 'yes']
            ]
        );

        $repeater->add_control(
            'item_det_more_options',
            [
                'label' => esc_html__( 'Details', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'item_title',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Standing forearm training', 'ahura' ),
            ]
        );

        $repeater->add_control(
            'item_description',
            [
                'label' => esc_html__( 'Description', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => ahura_get_lorem_ipsum(),
            ]
        );

        $repeater->add_control(
            'show_btn',
            [
                'label' => esc_html__( 'Show Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $repeater->add_control(
            'btn_text',
            [
                'label' => esc_html__( 'Button text', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'View Post', 'ahura' ),
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $repeater->add_control(
            'btn_link',
            [
                'label' => esc_html__( 'Button Link', 'ahura' ),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'dynamic' => ['active' => true],
                'label_block' => true,
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $this->add_control(
            'videos',
            [
                'label' => esc_html__( 'Items', 'ahura' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'item_title' => esc_html__( 'Standing forearm training', 'ahura' ),
                    ],
                    [
                        'item_title' => esc_html__( 'Standing forearm training', 'ahura' ),
                    ],
                    [
                        'item_title' => esc_html__( 'Standing forearm training', 'ahura' ),
                    ],
                ],
                'title_field' => '{{{ item_title }}}',
            ]
        );

        $this->add_control(
            'show_arrows',
            [
                'label' => esc_html__('Show Arrows', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'autoplay_delay',
            [
                'label' => esc_html__('Transition Duration', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3000,
                'condition' => [
                    'autoplay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );
        $this->end_controls_section();
        /**
         *
         *
         *
         * Styles
         *
         *
         *
         */
        $this->start_controls_section(
            'video_box_styles',
            [
                'label' => esc_html__('Video Box', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'item_video_box_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'default' => [
                    'size' => 438,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'size' => 400,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'size' => 370,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .video-box' => 'height: {{SIZE}}{{UNIT}}'
                ]
            ]
        );


        $this->add_responsive_control(
            'item_video_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .video-box video' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 28,
                    'right' => 28,
                    'bottom' => 28,
                    'left' => 28,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_video_border',
                'selector' => '{{WRAPPER}} .video-box video',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'details_box_styles',
            [
                'label' => esc_html__('Details', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_item_details_bg_color',
                'label' => esc_html__('Background', 'ahura'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .item-details',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#6F4EFD'],
                ]
            ]
        );

        $this->add_responsive_control(
            'item_details_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .item-details' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 28,
                    'right' => 28,
                    'bottom' => 28,
                    'left' => 28,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_details_border',
                'selector' => '{{WRAPPER}} .item-details',
            ]
        );

        $this->add_responsive_control(
            'box_item_details_padding',
            [
                'label' => esc_html__('padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'unit' => 'rem',
                    'top' => 4,
                    'right' => 4,
                    'bottom' => 4,
                    'left' => 4
                ]
            ]
        );

        $this->add_control(
            'head_more_options',
            [
                'label' => esc_html__( 'Header', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $justifyOptions = [
            'start' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'end' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ],
        ];

        $this->add_control(
            'item_head_alignment',
            [
                'label' => esc_html__('Text Alignment', 'ahura'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $justifyOptions : array_reverse($justifyOptions),
                'default' => 'center',
                'toggle' => false,
                'selectors' => [
                    '{{WRAPPER}} .item-head' => 'justify-content: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'item_head_icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'ahura' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 48,
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-head i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .item-head svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_head_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-head i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .item-head :is(svg, path)' => 'fill: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'item_head_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-head h3' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'item_head_title_typography',
                'selector' => '{{WRAPPER}} .item-head h3',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 700],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '35',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
            'details_more_options',
            [
                'label' => esc_html__( 'Details', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $alignment = array(
            'right' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_control(
            'item_details_text_align',
            [
                'label' => esc_html__('Text Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => 'right',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .item-content' => 'text-align: {{VALUE}}',
                    '{{WRAPPER}} .item-content p' => 'text-align: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'box_item_details_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-content div' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'item_title_typography',
                'selector' => '{{WRAPPER}} .item-content div',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '25',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
            'box_item_des_title_color',
            [
                'label' => esc_html__('Description Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Description Typography', 'ahura'),
                'name' => 'item_des_typography',
                'selector' => '{{WRAPPER}} .item-content p',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 300],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '18',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'details_button_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_item_btn_color',
            [
                'label' => esc_html__('Button Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-buttons a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'ahura'),
                'name' => 'item_btn_typography',
                'selector' => '{{WRAPPER}} .item-buttons a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'box_item_btn_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-buttons a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_btn_border',
                'selector' => '{{WRAPPER}} .item-buttons a',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_paginate_style',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'nav_options',
            [
                'label' => esc_html__('Navigation', 'ahura'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_nav_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev, {{WRAPPER}} .swiper-button-next' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .swiper-button-prev:after' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .swiper-button-next:after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'page_options',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'paginate_color',
            [
                'label' => esc_html__('Normal Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2289FF',
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'paginate_active_color',
            [
                'label' => esc_html__('Active Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2289FF',
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();
    }

    /**
     *
     * Render content for display
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $items = $settings['videos'];
        $show_arrows = $settings['show_arrows'] == 'yes';
        $show_pagination = $settings['show_pagination'] === 'yes';

        $slider_data = [
          'autoplay' => $settings['autoplay'] == 'yes',
          'autoplayDelay' =>  $settings['autoplay_delay'] == 'yes',
          'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        if ($items):
            ?>
            <div class="video-carousel3-wrap">
                <div class="swiper video-carousel3" data-slider='<?php echo json_encode($slider_data) ?>'>
                    <div class="swiper-wrapper">
                        <?php foreach ($items as $item): ?>
                            <div class="swiper-slide">
                                <div class="video-item">
                                    <div class="row">
                                        <div class="col-12 col-md-6">
                                            <div class="video-box">
                                                <video preload="none" poster="<?php echo $item['item_video_cover']['url'] ?? '' ?>" controls>
                                                    <source src="<?php echo $item['item_video']['url'] ?? '' ?>" type="video/mp4" />
                                                </video>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="item-details-wrap <?php echo !$show_arrows && !$show_pagination ? 'without-nav' : '' ?>">
                                                <div class="item-details">
                                                    <?php if ($item['show_item_head'] == 'yes'): ?>
                                                    <div class="item-head">
                                                        <?php \Elementor\Icons_Manager::render_icon( $item['item_head_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                        <h3><?php echo $item['item_head_title'] ?></h3>
                                                    </div>
                                                    <?php endif; ?>
                                                    <div class="item-content">
                                                        <div><?php echo $item['item_title'] ?></div>
                                                        <p><?php echo $item['item_description'] ?></p>
                                                    </div>
                                                    <?php
                                                    if ($item['show_btn'] == 'yes'):
                                                        if (!empty($item['btn_link']['url'])) {
                                                            $this->add_link_attributes('btn_link_' . $item['_id'], $item['btn_link']);
                                                        }
                                                        ?>
                                                    <div class="item-buttons">
                                                        <a <?php echo $this->get_render_attribute_string('btn_link_' . $item['_id']); ?>><?php echo $item['btn_text'] ?></a>
                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                                <?php if ($show_arrows || $show_pagination): ?>
                                                <div class="item-slider-handle<?php echo !$show_arrows ? ' without-arrows' : '' ?> <?php echo is_rtl() ? 'flex-row' : 'flex-row-reverse'; ?>">
                                                    <?php if ($show_arrows): ?>
                                                    <div class="swiper-button-next"></div>
                                                    <?php endif; ?>
                                                    <?php if ($show_pagination): ?>
                                                        <div class="swiper-pagination"></div>
                                                    <?php endif; ?>
                                                    <?php if ($show_arrows): ?>
                                                    <div class="swiper-button-prev"></div>
                                                    <?php endif; ?>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="ahura-element-msg">
                <?php echo esc_html__('Sorry, no posts were found for display.', 'ahura'); ?>
            </div>
        <?php
        endif;
    }
}
