<?php

namespace ahura\inc\widgets;

use Elementor\Controls_Manager;
use \ahura\app\mw_assets;

defined('ABSPATH') or die('no script kiddies please!');

class timeline_5 extends \ahura\app\elementor\Elementor_Widget_Base
{

    public function __construct($data=[], $args=null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('timeline5_js', mw_assets::get_js('elementor.timeline_5'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('timeline5_css', mw_assets::get_css('elementor.timeline_5'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('timeline5_js')];
    }

    public function get_icon()
    {
        return 'aicon-svg-timeline';
    }

    public function get_name()
    {
        return 'timeline5';
    }

    public function get_title()
    {
        return esc_html__('Timeline 5', 'ahura');
    }

    public function get_categories()
    {
        return ['ahuraelements'];
    }

    public function get_keywords()
    {
        return ['ahura', 'timeline', 'timeline 5', esc_html__('ahura', 'ahura'), esc_html__('Timeline 5', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Research', 'ahura')
            ]
        );

        $repeater->add_control(
            'sec_title',
            [
                'label' => esc_html__('Secondary Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Start from 2020', 'ahura')
            ]
        );

        $this->add_control(
            'timeline_list',
            [
                'label' => esc_html__('Timeline List', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'sec_title' => sprintf(esc_html__('Year %s', 'ahura'), 2019),
                        'title' => esc_html__('Public launch', 'ahura'),
                    ],
                    [
                        'sec_title' => sprintf(esc_html__('Year %s', 'ahura'), 2020),
                        'title' => esc_html__('Attracting 21,000 users', 'ahura'),
                    ],
                    [
                        'sec_title' => sprintf(esc_html__('Year %s', 'ahura'), 2022),
                        'title' => esc_html__('Office transfer', 'ahura'),
                    ],
                    [
                        'sec_title' => sprintf(esc_html__('Year %s', 'ahura'), 2023),
                        'title' => esc_html__('Launch of VIP content section', 'ahura'),
                    ],
                ],
                'title_field' => '{{{title}}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_section',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                    5 => '5',
                    6 => '6',
                    7 => '7',
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'desktop_default' => 4,
                'tablet_default' => 3,
                'mobile_default' => 1,
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'autoplay_delay',
            [
                'label' => esc_html__( 'Autoplay delay', 'ahura' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 10000,
                'step' => 1,
                'default' => 4500,
                'condition' => ['autoplay' => 'yes']
            ]
        );

        $this->add_control(
            'overflow_visible',
            [
                'label' => esc_html__('Show Overflow', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'selectors' => [
                        '{{WRAPPER}} .swiper' => 'overflow:visible;'
                ]
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         *
         * Items style tab
         *
         *
         */
        $this->start_controls_section(
            'item_style_section',
            [
                'label' => __( 'Item', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'item_line_color',
            [
                'label' => esc_html__('Line Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#555',
                'selectors' => [
                    '{{WRAPPER}} .timeline-head' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .timeline-head::after' => 'border-top-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#555',
                'selectors' => [
                    '{{WRAPPER}} .item-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_title_typo',
                'selector' => '{{WRAPPER}} .item-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 600],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '19',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'item_sec_title_color',
            [
                'label' => esc_html__('Secondary Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#7e7e7e',
                'selectors' => [
                    '{{WRAPPER}} .sec-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_sec_title_typo',
                'selector' => '{{WRAPPER}} .sec-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ]
                    ]
                ],
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $items = $settings['timeline_list'];


        $slider_data = [
            'autoPlay' => $settings['autoplay'] == 'yes',
            'autoplayTimeout' => $settings['autoplay_delay'] ? $settings['autoplay_delay'] : 4500,
            'observer' => $settings['use_observer_slider'] == 'yes',
            'desktopPerView' => (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 4,
            'tabletPerView' => (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 3,
            'mobilePerView' => (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
        ];

        if ($items): ?>
        <div class="timeline5-element">
            <div class="swiper" data-slider='<?php echo json_encode($slider_data) ?>'>
                <div class="swiper-wrapper">
                    <?php foreach ($items as $item): ?>
                        <div class="swiper-slide">
                            <div class="timeline-item">
                                <div class="timeline-head"></div>
                                <div class="timeline-content">
                                    <?php if (!empty($item['sec_title'])): ?>
                                        <h4 class="sec-title"><?php echo $item['sec_title'] ?></h4>
                                    <?php endif; ?>
                                    <h3 class="item-title"><?php echo $item['title'] ?></h3>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php
        endif;
    }
}