<?php
namespace ahura\inc\widgets;

use ahura\app\mw_assets;
use ahura\app\Post_Meta;
use Elementor\Controls_Manager;

// Block direct access to the main plugin file.
defined('ABSPATH') or die('No script kiddies please!');


class suggestion_post extends \ahura\app\elementor\Elementor_Widget_Base
{
    public function __register_assets()
    {
        $this->register_elementor_style('suggestion_post', mw_assets::get_css('elementor.suggestion_post'));
    }

    public function get_name()
    {
        return 'suggestion_post';
    }

    public function get_title()
    {
        return __('Suggestion Post', 'ahura');
    }

    public function get_icon()
    {
        return 'eicon-post';
    }

    public function get_categories()
    {
        return ['ahuraelements', 'ahura_posts'];
    }

    public function get_keywords()
    {
        return ['ahura', 'post', 'suggestion post', esc_html__('ahura' , 'ahura'), esc_html__( 'Suggestion Post' , 'ahura')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ahura'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $posts_list = [];
        $posts = get_posts(['numberposts' => -1]);

        if(!empty($posts)){
            foreach ($posts as $post){
                $posts_list[$post->ID] = $post->post_title;
            }
        }

        $this->add_control(
            'post_id',
            [
                'label' => esc_html__( 'Post', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => $posts_list,
                'default' => key($posts_list),
            ]
        );

        $this->add_control(
            'user_custom_img',
            [
                'label' => esc_html__('Use Custom Image', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'custom_image',
            [
                'label' => esc_html__( 'Choose Image', 'ahura' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => ['user_custom_img' => 'yes']
            ]
        );

        $this->add_control(
            'show_excerpt',
            [
                'label' => esc_html__('Excerpt', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'excerpt_chars_count',
            [
                'label'   => __( 'Excerpt Characters', 'ahura' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 60,
                'condition' => [
                    'show_excerpt' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'excerpt_title',
            [
                'label'   => __( 'Excerpt Title', 'ahura' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('Movie Story', 'ahura'),
                'condition' => [
                    'show_excerpt' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_button',
            [
                'label' => esc_html__('Show Button', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'button_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'show_button' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label'   => __( 'Button Text', 'ahura' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('Download Movie', 'ahura'),
                'condition' => [
                    'show_button' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-cover-box img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_control('div1', ['type' => Controls_Manager::DIVIDER]);

        $this->add_control(
            'show_box_title',
            [
                'label' => esc_html__('Show Box Title', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'box_title',
            [
                'label'   => __( 'Box Title', 'ahura' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __('This week recommended movies', 'ahura'),
                'condition' => [
                    'show_box_title' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();
        /**
         *
         * styles
         *
         *
         */
        $this->start_controls_section(
            'img_styles',
            [
                'label' => __( 'Image', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'img_height',
            [
                'label' => esc_html__( 'Image Height', 'ahura' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 460,
                ],
                'mobile_default' => [
                    'unit' => 'px',
                    'size' => 350,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-cover-box img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'img_border',
                'selector' => '{{WRAPPER}} .post-cover-box img',
            ]
        );

        $this->add_responsive_control(
            'img_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 40,
                    'right' => 40,
                    'bottom' => 40,
                    'left' => 40,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-cover-box img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'img_margin',
            [
                'label' => esc_html__( 'Margin', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .post-cover-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'img_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .post-cover-box img',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 25,
                            'blur' => 50,
                            'spread' => 0,
                            'color' => '#e2ab92'
                        ]
                    ]
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'post_styles',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'post_title_color',
            [
                'label' => esc_html__( 'Title Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .post-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => esc_html__('Title Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .post-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '600'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '27',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
            'post_meta_color',
            [
                'label' => esc_html__( 'Meta Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .post-metas .meta' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'post_meta_typography',
                'label' => esc_html__('Meta Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .post-metas .meta',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '300'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '14',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
            'post_excerpt_color',
            [
                'label' => esc_html__( 'Excerpt Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .post-excerpt-wrap' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_excerpt' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'post_excerpt_typography',
                'label' => esc_html__('Excerpt Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .post-excerpt-wrap',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '400'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
                'condition' => ['show_excerpt' => 'yes']
            ]
        );

        $this->add_control(
            'button_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->start_controls_tabs('btn_style_tabs');
        $this->start_controls_tab('btn_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' ), 'condition' => ['show_button' => 'yes']]);

        $this->add_responsive_control(
            'btn_icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 5,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-buttons a i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .post-buttons a :is(svg,path)' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_control(
            'btn_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .post-buttons a i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .post-buttons a :is(svg,path)' => 'fill: {{VALUE}}',
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_control(
            'btn_text_color',
            [
                'label' => esc_html__( 'Text Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .post-buttons a' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg',
                'selector' => '{{WRAPPER}} .post-buttons a',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => [
                        'default' => 'classic'
                    ],
                    'color' => [
                        'default' => '#ff2942'
                    ],
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'label' => esc_html__('Button Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .post-buttons a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '400'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20',
                        ]
                    ]
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} .post-buttons a',
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_responsive_control(
            'btn_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                  'unit' => 'px',
                  'top' => 10,
                  'right' => 10,
                  'bottom' => 10,
                  'left' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-buttons a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .post-buttons a',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 5,
                            'blur' => 10,
                            'spread' => 0,
                            'color' => '#ff294273'
                        ]
                    ]
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('btn_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' ), 'condition' => ['show_button' => 'yes']]);

        $this->add_control(
            'btn_icon_color_hover',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-buttons a:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .post-buttons a:hover :is(svg,path)' => 'fill: {{VALUE}}',
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_control(
            'btn_text_color_hover',
            [
                'label' => esc_html__( 'Text Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-buttons a:hover' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_hover',
                'selector' => '{{WRAPPER}} .post-buttons a:hover',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_hover',
                'selector' => '{{WRAPPER}} .post-buttons a:hover',
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_responsive_control(
            'btn_radius_hover',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .post-buttons a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_shadow_hover',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .post-buttons a:hover',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 10,
                            'blur' => 25,
                            'spread' => 0,
                            'color' => '#ff294273'
                        ]
                    ]
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'box_styles',
            [
                'label' => __( 'Box', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_height',
            [
                'label' => esc_html__( 'Box Height', 'ahura' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .suggestion-post-content' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box_title_color',
            [
                'label' => esc_html__( 'Title Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .box-title' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_box_title' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_title_typography',
                'label' => esc_html__('Title Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .box-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 'bold'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '30',
                        ]
                    ]
                ],
                'condition' => ['show_box_title' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_cover_color',
                'label' => __('Cover Color', 'ahura'),
                'selector' => '{{WRAPPER}} .suggestion-post-content',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => [
                        'default' => 'classic'
                    ],
                    'color' => [
                        'default' => '#0000009e'
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
            'box_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .suggestion-post-element-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .suggestion-post-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'top' => 3,
                    'right' => 2,
                    'bottom' => 3,
                    'left' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .suggestion-post-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'dot_margin',
            [
                'label' => esc_html__( 'Dot margin', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 0,
                    'right' => is_rtl() ? 0 : 15,
                    'bottom' => 0,
                    'left' => is_rtl() ? 15 : 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .suggestion-post-element .box-title:before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $button_icon = $settings['button_icon'];
        $chars_num = $settings['excerpt_chars_count'];

        $post_id = $settings['post_id'];
        $post_id = ahura_sanitize_posts($post_id);
        $post = get_post($post_id);

        if (!$post)
            return false;

        $likes_percent = ahura_get_post_likes_percent($post_id);
        $categories = Post_Meta::get_category_names($post_id);
        $large_cover = Post_Meta::get_post_large_cover($post_id);
        $thumb_url = !empty($large_cover) ? $large_cover : get_the_post_thumbnail_url($post_id, 'full');
        ?>
        <div class="suggestion-post-element">
            <div class="suggestion-post-element-wrap" style="background-image:url(<?php echo $thumb_url ?>)">
                <div class="suggestion-post-content">
                    <div class="row">
                        <div class="col-12 col-md-6">
                            <div class="post-details-box">
                                <?php if ($settings['show_box_title'] == 'yes'): ?>
                                    <div class="box-title"><span><?php echo $settings['box_title'] ?></span></div>
                                <?php endif; ?>
                                <a href="<?php echo get_the_permalink($post_id) ?>"><h3 class="post-title"><?php echo get_the_title($post_id) ?></h3></a>
                                <div class="post-metas">
                                    <?php if (!empty($likes_percent)): ?>
                                        <span class="movie-rate"><i class="fas fa-thumbs-up"></i>%<?php echo $likes_percent ?> <?php echo __('User Satisfaction', 'ahura') ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($categories)): ?>
                                        <div class="post-categories meta"><?php echo implode((is_rtl() ? '، ' : ', '), $categories) ?></div>
                                    <?php endif; ?>
                                </div>
                                <?php if ($settings['show_excerpt'] === 'yes'): ?>
                                    <div class="post-excerpt-wrap">
                                        <div class="box-icon">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M16 2H8C4 2 2 4 2 8V21C2 21.55 2.45 22 3 22H16C20 22 22 20 22 16V8C22 4 20 2 16 2Z" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M7 9.5H17" stroke="white" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M7 14.5H14" stroke="white" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                            </svg>
                                        </div>
                                        <div class="post-excerpt">
                                            <div class="wrap-title"><?php echo $settings['excerpt_title'] ?></div>
                                            <?php
                                            if($chars_num){
                                                echo '<p>' . wp_trim_words(get_the_excerpt($post_id), $chars_num, '...') . '</p>';
                                            } else {
                                                echo get_the_excerpt($post_id);
                                            }
                                            ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if ($settings['show_button'] == 'yes'): ?>
                                <div class="post-buttons">
                                    <a href="<?php echo get_the_permalink($post_id) ?>">
                                        <?php \Elementor\Icons_Manager::render_icon($button_icon, [ 'aria-hidden' => 'true' ]); ?>
                                        <span><?php echo $settings['button_text'] ?></span>
                                    </a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-12 col-md-6">
                            <div class="post-cover-box">
                                <a href="<?php echo get_the_permalink($post_id) ?>">
                                    <?php
                                    if($settings['user_custom_img'] == 'yes'){
                                        $img = $settings['custom_image'];
                                        if(!empty($img['url'])){
                                            echo '<img src="' . $img['url'] . '" alt="suggestion post">';
                                        } else {
                                            echo wp_get_attachment_image($img['id'], 'full');
                                        }
                                    } else {
                                        echo get_the_post_thumbnail($post_id);
                                    }
                                    ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
