<?php
use Elementor\Controls_Manager;
use Elementor\Plugin;

class ahura_post_comments extends \ahura\app\elementor\Elementor_Widget_Base {

    public function get_name() {
        return 'ahura_post_comments';
    }

    public function get_title() {
        return esc_html__( 'Post Comments', 'ahura' );
    }

    public function get_icon() {
        return 'eicon-comments';
    }

    public function get_categories() {
        return [ 'ahura_single' ];
    }

    public function get_keywords() {
        return [ 'ahura', 'comments', 'post', 'response', 'form', esc_html__( 'ahura', 'ahura' ), esc_html__( 'comment', 'ahura' ), esc_html__( 'form', 'ahura' ) ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__( 'Comments', 'ahura' ),
            ]
        );

        $this->add_control(
            '_skin',
            [
                'type' => Controls_Manager::HIDDEN,
            ]
        );

        $this->add_control(
            'skin_temp',
            [
                'label' => esc_html__( 'Skin', 'ahura' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'Theme Comments', 'ahura' ),
                ],
            ]
        );

        $this->add_control(
            'source_type',
            [
                'label' => esc_html__( 'Source', 'ahura' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'current_post' => esc_html__( 'Current Post', 'ahura' ),
                ],
                'default' => 'current_post',
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();
    }

    public function render() {
        $settings = $this->get_settings();
        ?>
        <div class="ahura-post-comments-element">
            <?php
            if (!comments_open()):
                $this->renderElementorNotice(
                    __( 'Comments are closed.', 'ahura' ),
                    __( 'Switch on comments from either the discussion box on the WordPress post edit screen or from the WordPress discussion settings.', 'ahura' )
                );
            else :
                comments_template();
            endif;
            ?>
        </div>
        <?php
    }
}
