<?php
namespace ahura\inc\widgets;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

class shop_countdown extends \ahura\app\elementor\Elementor_Widget_Base {
    function __construct($data=[], $args=null)
    {
        parent::__construct($data, $args);
        mw_assets::register_script('ahura_shopcountdown_js', mw_assets::get_js('widget_shopcountdown'));
        wp_localize_script(mw_assets::get_handle_name('ahura_shopcountdown_js'), 'wsc_data', array(
            'translate' => [
                'day' => __('Day', 'ahura'),
                'hour' => __('Hour', 'ahura'),
                'minute' => __('Minute', 'ahura'),
                'seconds' => __('Seconds', 'ahura'),
                'finished' => __('Finished!', 'ahura'),
            ]
        ));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('ahura_shopcountdown_css', mw_assets::get_css('elementor.shop_countdown'));
    }

    function get_script_depends()
    {
        return [ mw_assets::get_handle_name('ahura_shopcountdown_js') ];
    }

	public function get_name() {
		return 'mwcountdown';
	}

	public function get_title() {
		return __( 'Shop CountDown', 'ahura' );
	}

	public function get_icon() {
		return 'aicon-svg-shop-countdown';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}
	function get_keywords()
	{
		return ['ahura', 'countdown', 'shop countdown', esc_html__( 'ahura' , 'ahura'), esc_html__( 'Shop CountDown' , 'ahura')];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __("Title Here", 'ahura')
			]
		);
		$this->add_control(
            'time',
            [
                'label' => __( 'Time', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DATE_TIME,
                'default' => date('Y-m-d H:i:s', strtotime('+1 month'))
            ]
		);

        $this->add_control(
			'show_days',
			[
				'label' => esc_html__( 'Show days', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'show_hours',
			[
				'label' => esc_html__( 'Show hours', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();
        /**
         *
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'title_styles',
            [
                'label' => __( 'Title', 'ahura' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .shop-countdown-element.countdownbox > span' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .shop-countdown-element.countdownbox > span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 30,
                    'left' => 0,
                ]
            ]
        );
        
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typo',
				'selector' => '{{WRAPPER}} .shop-countdown-element.countdownbox > span',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'nums_styles',
            [
                'label' => __( 'Numbers', 'ahura' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('num_color_tabs');
        $this->start_controls_tab('num_color_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'numbers_color',
            [
                'label' => __( 'Numbers color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} li span:first-child' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'numbers_backcolor',
            [
                'label' => __( 'Numbers backcolor', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'transparent',
                'selectors' => [
                    '{{WRAPPER}} li span:first-child' => 'background-color: {{VALUE}}',
                ]
            ]
        );
        
        $this->end_controls_tab();
        $this->start_controls_tab('num_hovercolor_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'numbers_hover_color',
            [
                'label' => __( 'Numbers hover color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} li span:first-child:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'number_hover_backcolor',
            [
                'label' => __( 'Numbers hover backcolor', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'transparent',
                'selectors' => [
                    '{{WRAPPER}} li span:first-child:hover' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'number_typo',
				'selector' => '{{WRAPPER}} li span:first-child',
			]
		);

        $this->add_responsive_control(
			'number_padding',
			[
				'label' => esc_html__( 'Numbers padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} li span:first-child' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'number_margin',
			[
				'label' => esc_html__( 'Numbers margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 2,
					'right' => 20,
					'bottom' => 2,
					'left' => 20,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} li span:first-child' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'number_borderradius',
			[
				'label' => esc_html__( 'Numbers border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 2,
					'right' => 2,
					'bottom' => 2,
					'left' => 2,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} li span:first-child' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'numbers_fix_width',
			[
				'label' => esc_html__( 'Numbers fix width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_responsive_control(
			'numbers_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} ul li span:first-child' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'numbers_fix_width' => 'yes' ]
			]
		);
		
		$this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'numbers_border',
                'selector' => '{{WRAPPER}} ul li span:first-child',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'subtitle_styles',
            [
                'label' => __( 'subtitle', 'ahura' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('subtitle_color_tabs');
        $this->start_controls_tab('subtitle_color_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);
        
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Subtitle color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} li span:last-child' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'subtitle_backcolor',
            [
                'label' => __( 'Subtitle backcolor', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'transparent',
                'selectors' => [
                    '{{WRAPPER}} li span:last-child' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('subtitle_hovercolor_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'subtitle_hover_color',
            [
                'label' => __( 'Subtitle hover color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} li span:last-child:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'subtitle_hover_backcolor',
            [
                'label' => __( 'Subtitle hover backcolor', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'transparent',
                'selectors' => [
                    '{{WRAPPER}} li span:last-child:hover' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typo',
				'selector' => '{{WRAPPER}} li span:last-child',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'box_styles',
            [
                'label' => __( 'Box', 'ahura' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'color',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .countdownbox',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#4054B2'],
                ]
            ]
        );

        $this->add_control(
			'num_text_alignment',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'row' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-h-align-right',
					],
					'row-reverse' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-h-align-left',
					],
					'column' => [
						'title' => esc_html__( 'Top', 'ahura' ),
						'icon' => 'eicon-v-align-top',
					],
					'column-reverse' => [
						'title' => esc_html__( 'Bottom', 'ahura' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'default' => 'column',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} li' => 'flex-direction: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'counter_boxes_alignment',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'row' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-h-align-right',
					],
					'row-reverse' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-h-align-left',
					],
				],
				'default' => 'row',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .shop-countdown-element .countdown-content' => 'flex-direction: {{VALUE}};',
				],
			]
		);

        $this->add_control(
            'box_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .countdownbox' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 7,
                    'right' => 7,
                    'bottom' => 7,
                    'left' => 7,
                ]
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .countdownbox' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'wrap_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .countdownbox',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 5,
                            'blur' => 10,
                            'spread' => 0,
                            'color' => '#00000054'
                        ]
                    ]
                ],
            ]
        );

        $this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$this->add_inline_editing_attributes('title', 'none');
		$el_id = $this->get_id();
        ?>
        <div class="d-flex justify-content-center align-items-center flex-column shop-countdown-element countdownbox countdownbox-<?php echo $el_id?>" mm-date="<?php echo strtotime($settings['time']) . '000'?>" d-state="<?php echo $settings['show_days'] === 'yes' ? 'show' : 'hide'; ?>" h-state="<?php echo $settings['show_hours'] === 'yes' ? 'show' : 'hide'; ?>">
            <?php if($settings['title']): ?>
                <span <?php echo $this->get_render_attribute_string('title');?>><?php echo $settings['title'];?></span>
            <?php endif; ?>
            <ul class="countdown-content"></ul>
        </div>
        <?php $this->fixedEmptyContentInEditor() ?>
	   <?php
  }
}
