<?php
namespace ahura\inc\widgets;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\traits\WoocommerceMethods;
use ahura\app\woocommerce;
use Elementor\Controls_Manager;

use ahura\app\mw_assets;

class shop_carousel10 extends \ahura\app\elementor\Elementor_Widget_Base {
    use WoocommerceMethods;

    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('shop_carousel10_js', mw_assets::get_js('elementor.shop_carousel10'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('shop_carousel10_css', mw_assets::get_css('elementor.shop_carousel10'));
        if(!is_rtl()){
            $this->register_elementor_style('shop_carousel10_ltr_css', mw_assets::get_css('elementor.ltr.shop_carousel10_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('shop_carousel10_js')];
    }

    public function get_name() {
        return 'shop_carousel10';
    }

    public function get_title() {
        return __( 'Products Carousel 10', 'ahura' );
    }

    public function get_icon() {
        return 'eicon-slides';
    }

    public function get_categories() {
        return ['ahuraelements','ahura_woocommerce'];
    }

    function get_keywords()
    {
		return ['ahura', 'shop', 'product', 'products carousel', 'shop carousel 10', esc_html__( 'ahura' , 'ahura'), esc_html__( 'Products' , 'ahura'), esc_html__( 'Shop Carousel 10' , 'ahura')];
    }

    protected function register_controls() {
        if(!woocommerce::is_active()) {
            return false;
        }

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $options = [];

        $products = $this->get_products_array();

        if($products){
            foreach($products as $product) {
                $options[$product['ID']] = $product['post_title'];
            }
        }

        $default = ($options) ? key($options) : 0;

        $repeater->add_control(
            'pid',
            [
                'label' => esc_html__('Product', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => $options,
                'default' => $default
            ]
        );

        $this->add_control(
            'products',
            [
                'label' => esc_html__('Products', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    ['pid' => $default],
                ],
                'title_field' => '{{{pid}}}',
                'condition' => [
                    'only_discounted_products!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'only_discounted_products',
            [
                'label' => esc_html__('Only Discounted Products', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'items_num',
            [
                'label' => esc_html__('Products Number', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 5,
                'min' => 1,
                'condition' => [
                    'only_discounted_products' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'item_btn_title',
            [
                'label' => esc_html__( 'Button Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'View Details', 'ahura' ),
            ]
        );

        $this->add_control(
            'show_review_btn',
            [
                'label' => esc_html__('Show Review Button', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'btn_review_icon',
            [
                'label' => esc_html__('Icon', 'ahura'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-comment-dots',
                    'library' => 'fa-solid',
                ],
                'condition' => ['show_review_btn' => 'yes']
            ]
        );

        $this->add_control(
            'show_buy_btn',
            [
                'label' => esc_html__('Show Buy Button', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'btn_buy_icon',
            [
                'label' => esc_html__('Icon', 'ahura'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-cart-plus',
                    'library' => 'fa-solid',
                ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_control(
            'item_excerpt_show',
            [
                'label' => esc_html__('Excerpt', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'excerpt_chars_count',
            [
                'label'   => __( 'Excerpt Characters', 'ahura' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 40,
                'condition' => [
                    'item_excerpt_show' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'item_category_show',
            [
                'label' => esc_html__('Category', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'head_section',
            [
                'label' => __( 'Head', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_head',
            [
                'label' => esc_html__('Show Header', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'box_title',
            [
                'label' => esc_html__( 'Box Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Weekly Choice', 'ahura' ),
                'condition' => ['show_head' => 'yes']
            ]
        );

        $this->add_control(
            'show_box_btn',
            [
                'label' => esc_html__('Box Button', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['show_head' => 'yes']
            ]
        );

        $this->add_control(
            'box_btn_icon',
            [
                'label' => esc_html__('Icon', 'ahura'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'fa-solid',
                ],
                'condition' => ['show_box_btn' => 'yes', 'show_head' => 'yes']
            ]
        );

        $this->add_control(
            'box_btn_link',
            [
                'label'      => __('Button Link', 'ahura'),
                'type'       => \Elementor\Controls_Manager::URL,
                'label_block' => true,
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => '#',
                ],
                'condition' => ['show_box_btn' => 'yes', 'show_head' => 'yes']
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'settings_section',
            [
                'label' => __( 'Settings', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_paginate',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'transition_duration',
            [
                'label' => esc_html__('Transition Duration', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 4500,
                'condition' => [
                    'autoplay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label' => esc_html__('Infinite Loop', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );



        $this->end_controls_section();

        /**
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'item_styles',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__( 'Title Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0d1321',
                'selectors' => [
                    '{{WRAPPER}} .product-item .item-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'ahura'),
                'name' => 'item_title_typo',
                'selector' => '{{WRAPPER}} .product-item .item-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 700],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '43',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'item_cat_color',
            [
                'label' => esc_html__( 'Category Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(55, 55, 66, 1)',
                'selectors' => [
                    '{{WRAPPER}} .item-cats a' => 'color: {{VALUE}}',
                ],
                'condition' => ['item_category_show' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Category Typography', 'ahura'),
                'name' => 'item_cat_typo',
                'selector' => '{{WRAPPER}} .item-cats a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
                'condition' => ['item_category_show' => 'yes']
            ]
        );

        $this->add_control(
            'item_excerpt_color',
            [
                'label' => esc_html__( 'Excerpt Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(139, 139, 139, 1)',
                'selectors' => [
                    '{{WRAPPER}} .item-excerpt p' => 'color: {{VALUE}}',
                ],
                'condition' => ['item_excerpt_show' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Excerpt Typography', 'ahura'),
                'name' => 'item_excerpt_typo',
                'selector' => '{{WRAPPER}} .item-excerpt p',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
                'condition' => ['item_excerpt_show' => 'yes']
            ]
        );

        $this->add_control(
            'item_btn_style_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'item_btn_color',
            [
                'label' => esc_html__( 'Button Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-btns .item-main-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_btn_bg',
                'selector' => '{{WRAPPER}} .item-btns .item-main-btn',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => 'rgba(139, 138, 52, 1)']
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Button Typography', 'ahura'),
                'name' => 'item_btn_typo',
                'selector' => '{{WRAPPER}} .item-btns .item-main-btn',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
            ]
        );

        $this->add_responsive_control(
            'item_btn_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'default' => [
                    'top' => 10,
                    'right' => 20,
                    'bottom' => 10,
                    'left' => 20,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-btns .item-main-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_btn_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'default' => [
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-btns .item-main-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_btn_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .item-btns .item-main-btn',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'head_styles',
            [
                'label' => esc_html__('Header', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_head' => 'yes']
            ]
        );

        $this->add_control(
            'head_title_color',
            [
                'label' => esc_html__( 'Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(251, 193, 81, 1)',
                'selectors' => [
                    '{{WRAPPER}} .box-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'ahura'),
                'name' => 'head_title_typo',
                'selector' => '{{WRAPPER}} .box-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 700],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '35',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'head_btn_icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .box-head a i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .box-head a :is(svg, svg path)' => 'fill: {{VALUE}}',
                ],
                'condition' => ['show_box_btn' => 'yes']
            ]
        );


        $this->add_responsive_control(
            'head_margin',
            [
                'label' => esc_html__( 'Margin', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'allowed_dimensions' => ['top', 'bottom'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 20,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .box-head' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'paginate_styles',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_paginate' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'paginate_bg',
                'selector' => '{{WRAPPER}} .slider-pagination',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#e7e7e7']
                ]
            ]
        );

        $this->add_responsive_control(
            'paginate_item_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'default' => [
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-pagination span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('paginate_style_tabs');
        $this->start_controls_tab('paginate_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' ),]);

        $this->add_control(
            'paginate_item_color',
            [
                'label' => esc_html__( 'Item Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .slider-pagination span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'paginate_item_bg',
                'selector' => '{{WRAPPER}} .slider-pagination span',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => 'rgba(251, 193, 81, 1)']
                ]
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('paginate_style_active_tab', ['label' => esc_html__( 'Active', 'ahura' ),]);

        $this->add_control(
            'paginate_item_active_color',
            [
                'label' => esc_html__( 'Active Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .slider-pagination .active' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'paginate_item_active_bg',
                'selector' => '{{WRAPPER}} .slider-pagination .active',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => 'rgba(139, 138, 52, 1)']
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    public function get_item($product_id)
    {
        $settings = $this->get_settings_for_display();
        $products = $settings['products'];

        if(!empty($products)){
            foreach ($products as $product){
                if ($product['pid'] == $product_id)
                    return $product;
            }
        }

        return false;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if (\ahura\app\woocommerce::is_active()) {
            $only_discounted = ($settings['only_discounted_products'] == 'yes');

            if(isset($settings['products']) && is_array($settings['products'])){
                $ids = array_map(function($p){
                    return $p['pid'];
                }, $settings['products']);
            } else {
                $ids = [0];
            }

            $products = $settings['products'] ? $this->get_products(['post__in' => $ids]) : false;

            if($only_discounted){
                $products = $this->get_discounted_products(['per_page' => ($settings['items_num'] ? $settings['items_num'] : -1)]);
            }

            if (!$products->have_posts())
                return false;

            $has_paginate = $settings['show_paginate'] == 'yes' && $products->post_count > 1;
            $show_review_btn = $settings['show_review_btn'] == 'yes';
            $show_buy_btn = $settings['show_buy_btn'] == 'yes';


            $slider_data = [
                'autoPlay' => $settings['autoplay'] == 'yes',
                'transitionDuration' => (intval($settings['transition_duration'])) ? $settings['transition_duration'] : 4500,
                'loop' => $settings['infinite_loop'] == 'yes',
                'observer' => $settings['use_observer_slider'] == 'yes'
            ];
            ?>
            <div class="shop-carousel10-element <?php echo $has_paginate ? 'has-paginate' : '' ?>">
                <div class="slider-wrap">
                    <div class="swiper slider-items" data-slider='<?php echo json_encode($slider_data) ?>'>
                        <?php if ($settings['show_head'] == 'yes'): ?>
                        <div class="box-head">
                            <div class="box-title"><?php echo $settings['box_title']; ?></div>
                            <?php
                            if ($settings['show_box_btn'] == 'yes'):
                                if ( ! empty( $settings['box_btn_link']['url'] ) ) {
                                    $this->add_link_attributes( 'box_btn_link', $settings['box_btn_link'] );
                                }
                                ?>
                                <a <?php echo $this->get_render_attribute_string( 'box_btn_link' ); ?>>
                                    <?php if (!empty($settings['box_btn_icon']['value'])): ?>
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['box_btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    <?php else: ?>
                                        <svg width="56" height="56" viewBox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg"> <rect x="0.5" y="0.5" width="55" height="55" rx="27.5" stroke="#8B8A34"/> <path d="M21.9 35.5L20.5 34.1L32.1 22.5H25.5V20.5H35.5V30.5H33.5V23.9L21.9 35.5Z" fill="#8B8A34"/> </svg>
                                    <?php endif; ?>
                                </a>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        <div class="swiper-wrapper">
                            <?php
                            while($products->have_posts()): $products->the_post();
                                $cats = $this->get_product_categories(get_the_ID());
                                ?>
                                <div class="swiper-slide swiper-slide-<?php echo esc_attr(get_the_ID()) ?>">
                                    <div class="product-item" data-id="<?php echo esc_attr(get_the_ID()) ?>">
                                        <h3 class="item-title"><?php the_title() ?></h3>
                                        <?php if ($cats && $settings['item_category_show'] == 'yes'): ?>
                                            <div class="item-cats">
                                                <?php foreach ($cats as $cat): ?>
                                                    <a href="<?php echo get_term_link($cat->term_id, $cat->taxonomy) ?>"><?php echo $cat->name ?></a>
                                                <?php endforeach; ?>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (has_excerpt() && $settings['item_excerpt_show'] == 'yes'): ?>
                                            <div class="item-excerpt"><?php
                                                if(!empty($settings['excerpt_chars_count'])){
                                                    echo '<p>' . wp_trim_words(get_the_excerpt(), $settings['excerpt_chars_count'], '...') . '</p>';
                                                } else {
                                                    the_excerpt();
                                                }
                                                ?></div>
                                        <?php endif; ?>
                                        <div class="item-btns">
                                            <?php if ($show_buy_btn || $show_review_btn): ?>
                                            <div class="icon-btns">
                                                <?php if ($show_review_btn): ?>
                                                    <a href="<?php the_permalink() ?>#tab-reviews" class="item-reviews-btn">
                                                        <?php if (!empty($settings['btn_review_icon']['value'])): ?>
                                                            <?php \Elementor\Icons_Manager::render_icon( $settings['btn_review_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                        <?php else: ?>
                                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="800px" height="800px" viewBox="0 0 24 24" version="1.1"> <g id="Comments" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"> <rect id="Container" x="0" y="0" width="24" height="24"> </rect> <path d="M10,4 L14,4 C17.3137085,4 20,6.6862915 20,10 L20,14 C20,17.3137085 17.3137085,20 14,20 L4,20 L4,20 L4,10 C4,6.6862915 6.6862915,4 10,4 Z" id="shape-1" stroke="#030819" stroke-width="2" stroke-linecap="round" stroke-dasharray="0,0"> </path> <line x1="9" y1="14" x2="12" y2="14" id="shape-2" stroke="#030819" stroke-width="2" stroke-linecap="round" stroke-dasharray="0,0"> </line> <line x1="9" y1="10" x2="15" y2="10" id="shape-3" stroke="#030819" stroke-width="2" stroke-linecap="round" stroke-dasharray="0,0"> </line> </g> </svg>
                                                        <?php endif; ?>
                                                    </a>
                                                <?php endif; ?>
                                                <?php if($show_buy_btn): ?>
                                                    <a href="<?php echo esc_attr($this->get_add_to_cart_link(get_the_ID(), true)) ?>" class="item-buy-btn">
                                                        <?php if (!empty($settings['btn_buy_icon']['value'])): ?>
                                                            <?php \Elementor\Icons_Manager::render_icon( $settings['btn_buy_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                        <?php else: ?>
                                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="800px" height="800px" viewBox="0 0 24 24" version="1.1"> <g id="Free-Icons" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round"> <g transform="translate(-451.000000, -452.000000)" id="Group" stroke="#000000" stroke-width="2"> <g transform="translate(449.000000, 450.000000)" id="Shape"> <path d="M5.00999474,6 L21,6 L19.7276973,13.1746098 C19.6430247,13.6520853 19.2279846,14 18.7430596,14 L6.0012509,14 C5.48841428,14 5.06574296,13.6139598 5.00797785,13.1166211 L5.0012509,12.9987507 L5.0012509,12.9987507 L5.00999474,6 Z"> </path> <polyline points="3 3 4.99005496 3 5 7"> </polyline> <path d="M14.5000376,19.000047 C14.5000376,17.8954774 15.3954513,17.000047 16.5,17.000047 C17.6045487,17.000047 18.4999624,17.8954774 18.4999624,19.000047 C18.4999624,20.1046166 17.6045487,21.000047 16.5,21.000047 C15.4293838,21.000047 14.5527352,20.0576005 14.5000376,19.000047 Z"> </path> <path d="M7.5,21.000047 C6.39545136,21.000047 5.5000376,20.1046166 5.5000376,19.000047 C5.5000376,17.8954774 6.39545136,17.000047 7.5,17.000047 C8.60454864,17.000047 9.4999624,17.8954774 9.4999624,19.000047 C9.4999624,20.1046166 8.60454864,21.000047 7.5,21.000047 Z"> </path> <line x1="7.5" y1="14" x2="7.5" y2="17"> </line> <line x1="14" y1="19" x2="10" y2="19"> </line> </g> </g> </g> </svg>
                                                        <?php endif; ?>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                            <?php endif; ?>
                                            <a href="<?php the_permalink() ?>" class="item-main-btn">
                                                <?php echo $settings['item_btn_title'] ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php
                            endwhile;
                            wp_reset_query();
                            ?>
                        </div>
                        <?php if ($has_paginate): ?>
                        <div class="slider-pagination">
                            <?php $i = 1; foreach ($products->get_posts() as $post): ?>
                                <span class="slide-btn slide-btn-<?php echo esc_attr($post->ID) ?> <?php echo $i == 1 ? 'active' : '' ?>" data-index="<?php echo esc_attr($i) ?>">
                                    <?php echo $i; ?>
                                </span>
                            <?php $i++; endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php
        }
    }
}