<?php
namespace ahura\inc\widgets;
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\woocommerce;
use ahura\app\elementor\woocommerce\Shop_Carousel_Price_Render;
use ahura\app\elementor\woocommerce\Variations_Color;
use ahura\app\mw_assets;
use Elementor\Controls_Manager;

class shop_carousel extends \ahura\app\elementor\Elementor_Widget_Base {
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_owlcarousel_assets();
        mw_assets::register_script('shop_carousel_js', mw_assets::get_js('elementor.shop_carousel'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('shop_carousel_css', mw_assets::get_css('elementor.shop_carousel'));
        if(!is_rtl()){
            $this->register_elementor_style('shop_carousel_ltr_css', mw_assets::get_css('elementor.ltr.shop_carousel_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('shop_carousel_js')];
    }

	public function get_name() {
		return 'shopcarousel';
	}

	public function get_title() {
		return __( 'Products Carousel', 'ahura' );
	}

	public function get_icon() {
		return 'aicon-svg-shop-carousel';
	}

	public function get_categories() {
		return [ 'ahuraelements','ahura_woocommerce' ];
	}
	function get_keywords()
	{
		return ['ahura', 'shop', 'product', 'products carousel', 'shop carousel', esc_html__( 'ahura' , 'ahura'), esc_html__( 'Products' , 'ahura'), esc_html__( 'Shop Carousel' , 'ahura')];
	}

	protected function register_controls() {
		if(!woocommerce::is_active())
		    return false;

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$categories = get_terms( array(
			'taxonomy' => 'product_cat',
			'hide_empty' => false,
		));
		$cats       = array();
		foreach ( $categories as $category ) {
			$cats[ $category->slug ] = $category->name;
		}
		$default = key($cats);
		$this->add_control(
			'catsid',
			[
				'label'    => __( 'Categories', 'ahura' ),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'options'  => array_merge(
					[ 'allproducts'  => esc_html__( 'All Products', 'ahura' ) ],
					[ 'discountedproducts'  => esc_html__( 'Discounted Products', 'ahura' ) ],
					[ 'randomproducts'  => esc_html__( 'Random Products', 'ahura' ) ],
					$cats ),
				'label_block' => true,
				'multiple' => true,
				'default' => $default
			]
		);

		$stock_options = (function_exists('wc_get_product_stock_status_options')) ? wc_get_product_stock_status_options() : [];

        $this->add_control(
            'products_stock_status',
            [
                'label'   => esc_html__('Stock status of products', 'ahura'),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options' => array_merge(['none'  => esc_html__('None', 'ahura')], $stock_options),
                'default' => 'instock'
            ]
        );

        $this->add_control(
            'fully_show_title',
            [
                'label'   => __( 'Fully Show Title', 'ahura' ),
                'type'    => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
                    'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-editor-close' ]
                ],
                'default' => 'no'
            ]
        );

		$this->add_control(
			'price',
			[
				'label'   => __( 'Show Price', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-editor-close' ]
				],
				'default' => 'yes'
			]
		);

        $this->add_control(
            'show_price_label',
            [
                'label'   => __( 'Price Label', 'ahura' ),
                'type'    => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
                    'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-editor-close' ]
                ],
                'default' => 'no',
                'condition' => ['price' => 'yes']
            ]
        );

		$this->add_control(
			'count',
			[
				'label'      => __( 'Number of posts', 'ahura' ),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'default'    => 8
			]
		);

		$this->add_control(
			'product_order',
			[
				'label' => __('Sort', 'ahura'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'default' => 'DESC',
				'options' => [
					'ASC' => [
						'title' => __('Ascending', 'ahura'),
						'icon' => 'eicon-sort-up'
					],
					'DESC' => [
						'title' => __('Descending', 'ahura'),
						'icon' => 'eicon-sort-down'
					],
				],
				'toggle' => true
			]
		);

		$this->add_control(
			'outofstock_text',
			[
				'label' => __( 'Out of stock text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'out of stock', 'ahura' ),
			]
		);

		$this->add_control(
			'stock_status',
			[
				'label'   => __( 'Show product stock status', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-editor-close' ]
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'sale_price_product',
			[
				'label'   => __( 'Show only discounted products', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					null  => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no' => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-editor-close' ]
				],
				'default' => 'no',
				'condition' => [
					'catsid!' => 'discountedproducts',
				],
			]
		);
        
        $this->add_control(
            'show_variation_colors',
            [
                'label' => esc_html__( 'Variations colors', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'title_seperator',
            [
                'label' => esc_html__( 'Title seperator', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_buy_btn',
            [
                'label' => esc_html__('Product Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'full_width_button',
            [
                'label' => esc_html__( 'Full-width button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [ 'show_buy_btn' => 'yes' ]
            ]
        );

        $this->add_control(
            'buy_button_text',
            [
                'label'      => __('Button Text', 'ahura'),
                'type'       => \Elementor\Controls_Manager::TEXT,
                'default'    => __('Buy Product', 'ahura'),
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_control(
            'buy_button_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_control(
            'regular_price_strikethrough',
            [
                'label' => esc_html__('Regular price strikethrough', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'title_price_same_line',
            [
                'label' => esc_html__('Title/Price same line', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-cover img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 'h3',
                'options' => [
                    'h1' => 'h1',
                    'h2' => 'h2',
                    'h3' => 'h3',
                    'h4' => 'h4',
                    'h5' => 'h5',
                    'h6' => 'h6',
                ],
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'header_section',
            [
                'label' => __( 'Header', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_header',
            [
                'label' => esc_html__('Show Header', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_box_title',
            [
                'label' => esc_html__('Show Title', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->add_control(
            'box_title',
            [
                'label'      => __('Title', 'ahura'),
                'type'       => \Elementor\Controls_Manager::TEXT,
                'default'    => __('Latest Products', 'ahura'),
                'condition' => ['show_header' => 'yes', 'show_box_title' => 'yes']
            ]
        );

        $this->add_control(
            'show_box_btn',
            [
                'label' => esc_html__('Show Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->add_control(
            'box_btn_link',
            [
                'label' => esc_html__( 'Link', 'ahura' ),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
                'condition' => ['show_header' => 'yes', 'show_box_btn' => 'yes']
            ]
        );

        $this->add_control(
            'box_btn_title',
            [
                'label'      => __('Button Text', 'ahura'),
                'type'       => \Elementor\Controls_Manager::TEXT,
                'default'    => __('View All', 'ahura'),
                'condition' => ['show_header' => 'yes', 'show_box_btn' => 'yes']
            ]
        );

        $this->add_control(
            'show_header_slider_buttons',
            [
                'label' => esc_html__('Slider Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_section',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'layout_col',
            [
                'label' => esc_html__('Slides Per View', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 4,
                'tablet_default' => 3,
                'mobile_default' => 1,
                'options' => [
                    '1' => 1,
                    '2' => 2,
                    '3' => 3,
                    '4' => 4,
                    '5' => 5,
                    '6' => 6,
                    '7' => 7,
                    '8' => 8,
                ]
            ]
        );

        $this->add_control(
            'show_slider_btn',
            [
                'label' => esc_html__('Slider Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'selectors' => [
                    '{{WRAPPER}} .owl-carousel .owl-nav' => 'display:flex;'
                ],
                'condition' => ['show_header_slider_buttons!' => 'yes']
            ]
        );

        $this->add_control(
			'autoplay',
			[
				'label' => esc_html__( 'Autoplay', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'autoplay_delay',
			[
				'label' => esc_html__( 'Autoplay delay', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 100,
				'max' => 10000,
				'step' => 1,
				'default' => 2500,
                'condition' => ['autoplay' => 'yes']
			]
		);

        $this->add_control(
            'slide_margin',
            [
                'label' => esc_html__( 'Slides Space', 'ahura' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 200,
                'step' => 1,
                'default' => 25,
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'selectors' => [
                    '{{WRAPPER}} .owl-dots' => 'display: block;',
                ],
            ],
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'header_styles',
            [
                'label' => __( 'Header', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->add_responsive_control(
            'heading_height',
            [
                'label' => esc_html__( 'Height', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .box-heading' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'heading_margin',
            [
                'label' => esc_html__( 'Margin', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'top' => 0,
                    'bottom' => 15,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'allowed_dimensions' => ['top', 'bottom'],
                'selectors' => [
                    '{{WRAPPER}} .box-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box_title_styles',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_title_color',
            [
                'label' => esc_html__( 'Text Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff633b',
                'selectors' => [
                    '{{WRAPPER}} .box-heading .box-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .box-heading .box-title span:after' => 'background-color: {{VALUE}}1c',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Title Typography', 'ahura'),
                'name' => 'box_title_typography',
                'selector' => '{{WRAPPER}} .box-heading .box-title',
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '20',
                            ]
                        ],
                        'font_weight' => [
                            'default' => '600'
                        ],
                    ],
            ]
        );

        $this->add_control(
            'box_btn_styles',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_link_color',
            [
                'label' => esc_html__( 'Text Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff633b',
                'selectors' => [
                    '{{WRAPPER}} .box-buttons a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .box-buttons :is(svg,path)' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Button Typography', 'ahura'),
                'name' => 'box_link_typography',
                'selector' => '{{WRAPPER}} .box-buttons a',
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '20',
                            ]
                        ],
                        'font_weight' => [
                            'default' => '600'
                        ],
                    ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .box-buttons a i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .box-buttons a svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'item_section',
            [
                'label' => __( 'Item', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		// start tabs
		$this->start_controls_tabs(
			'item_style_tabs',
		);

		// start normal tab
		$this->start_controls_tab(
			'item_style_normal_tab',
			[
				'label' => __('Normal Item', 'ahura')
			]
		);
		$this->add_control(
            'item_style_normal_mode_heading',
            [
                'label' => esc_html__( 'Normal', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $alignment = array(
            'right' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_responsive_control(
            'item_alignment',
            [
                'label' => esc_html__( 'Text alignment', 'ahura' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'toggle' => false,
                'selectors' => [
                    '{{WRAPPER}} .product-title' => 'text-align: {{VALUE}}',
                ],
            ]
        );

		$this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#555',
                'selectors' => [
                    '{{WRAPPER}} .owl-item .product-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Title Typography', 'ahura'),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .owl-item .product-title',
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '16',
                            ]
                        ],
                        'font_weight' => [
                            'default' => '400'
                        ],
                    ],
            ]
        );
		
        $this->add_control(
            'price_label_color',
            [
                'label' => esc_html__('Price label color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#555',
                'selectors' => [
                    '{{WRAPPER}} .price-label' => 'color: {{VALUE}}',
                ],
            ]
        );
		
        $this->add_control(
            'price_color',
            [
                'label' => esc_html__('Regular price color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#555',
                'selectors' => [
                    '{{WRAPPER}} .mwprprice .regular-price' => 'color: {{VALUE}}',
                ],
            ]
        );
		
        $this->add_control(
            'main_price_color',
            [
                'label' => esc_html__('Final price color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#555',
                'selectors' => [
                    '{{WRAPPER}} .mwprprice .main-price' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Price label typography', 'ahura'),
                'name' => 'price_label_typography',
                'selector' => '{{WRAPPER}} .price-label',
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '15',
                            ]
                        ],
                        'font_weight' => [
                            'default' => '400'
                        ],
                    ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Regular price typography', 'ahura'),
                'name' => 'regular_price_typography',
                'selector' => '{{WRAPPER}} .mwprprice .regular-price *',
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '15',
                            ]
                        ],
                        'font_weight' => [
                            'default' => '400'
                        ],
                    ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Sale price typography', 'ahura'),
                'name' => 'sale_price_typography',
                'selector' => '{{WRAPPER}} .mwprprice .sale-price *, {{WRAPPER}} .mwprprice .regular-price.main-price *',
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '15',
                            ]
                        ],
                        'font_weight' => [
                            'default' => '400'
                        ],
                    ],
            ]
        );

		// border line color
		$this->add_control(
            'border_line_color',
            [
                'label' => esc_html__('Border line color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#00000014',
                'selectors' => [
                    '{{WRAPPER}} .owl-item .product-title' => 'border-color: {{VALUE}};',
                ],
                'condition' => [ 'title_seperator' => 'yes' ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_bg',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .owl-item',
                'fields_options' =>
                    [
                        'background' =>
                            [
                                'default' => 'classic'
                            ],
                        'color' =>
                            [
                                'default' => '#fff'
                            ],
                    ]
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .owl-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .owl-item',
            ]
        );

		$this->end_controls_tab();

		// start hover tab
		$this->start_controls_tab(
			'item_style_hover_tab',
			[
				'label' => __('Hover Item', 'ahura')
			]
		);
		$this->add_control(
            'item_style_hover_mode_heading',
            [
                'label' => esc_html__( 'Hover', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

		$this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#555',
                'selectors' => [
                    '{{WRAPPER}} .owl-item:hover .product-title' => 'color: {{VALUE}}',
                ],
            ]
        );
		
        $this->add_control(
            'price_color_hover',
            [
                'label' => esc_html__('Price label color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#555',
                'selectors' => [
                    '{{WRAPPER}} .owl-item:hover .price-label' => 'color: {{VALUE}}',
                ],
            ]
        );
		
        $this->add_control(
            'regular_price_color_hover',
            [
                'label' => esc_html__('Regular price color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#555',
                'selectors' => [
                    '{{WRAPPER}} .owl-item:hover .mwprprice .regular-price' => 'color: {{VALUE}}',
                ],
            ]
        );
		
        $this->add_control(
            'main_price_color_hover',
            [
                'label' => esc_html__('Final price color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#555',
                'selectors' => [
                    '{{WRAPPER}} .owl-item:hover .mwprprice .main-price' => 'color: {{VALUE}}',
                ],
            ]
        );

		// border line color
		$this->add_control(
            'border_line_color_hover',
            [
                'label' => esc_html__('Border line color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#00000014',
                'selectors' => [
                    '{{WRAPPER}} .owl-item:hover .product-title' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_hover',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .owl-item:hover',
                'fields_options' =>
                    [
                        'background' =>
                            [
                                'default' => 'classic'
                            ],
                        'color' =>
                            [
                                'default' => '#fff'
                            ],
                    ]
            ]
        );

        $this->add_control(
            'item_radius_hover',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .owl-item:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border_hover',
                'selector' => '{{WRAPPER}} .owl-item:hover',
            ]
        );

		$this->end_controls_tab();

        $this->add_control(
            'title_padding',
            [
                'label' => esc_html__( 'Title padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .product-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'price_padding',
            [
                'label' => esc_html__( 'Price area padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .mwprprice' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'regular_price_padding',
            [
                'label' => esc_html__( 'Regular price padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .regular-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'sale_price_padding',
            [
                'label' => esc_html__( 'Sale price padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .sale-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_tabs();

        $this->add_control(
            'item_image_styles',
            [
                'label' => esc_html__( 'Image', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
			'image_backcolor',
			[
				'label' => esc_html__( 'Image background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product-cover img' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
            'product_img_width',
            [
                'label' => esc_html__('Image Width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .product-cover img' => 'width: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_responsive_control(
            'product_img_height',
            [
                'label' => esc_html__('Image Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .product-cover img' => 'height: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_responsive_control(
            'product_img_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .product-cover, {{WRAPPER}} .product-cover img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'	=>	'product_cover_bg',
                'type' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .product-cover',
            ]
        );

        $this->add_responsive_control(
            'product_cover_margin',
            [
                'label' => esc_html__( 'Margin', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .product-cover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'product_cover_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .product-cover a img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'buy_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->start_controls_tabs('buy_style_tabs');
        $this->start_controls_tab('buy_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' ), 'condition' => ['show_buy_btn' => 'yes']]);

        $this->add_responsive_control(
            'item_btn_alignment',
            [
                'label' => esc_html__( 'Text alignment', 'ahura' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'toggle' => false,
                'selectors' => [
                    '{{WRAPPER}} .item-buttons' => 'text-align: {{VALUE}}',
                ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_control(
            'buy_icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 80,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .add-to-cart-btn svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_control(
            'buy_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#505050',
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .add-to-cart-btn svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .add-to-cart-btn svg path' => 'fill: {{VALUE}}',
                ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_control(
            'buy_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#505050',
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'buy_typography',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '400'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ]
                    ]
                ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'buy_bg',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                        'background' =>
                            [
                                'default' => 'classic'
                            ],
                        'color' =>
                            [
                                'default' => '#fff'
                            ],
                    ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'buy_border',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => [
                        'default' => [
                            'unit' => 'px',
                            'top' => 1,
                            'bottom' => 1,
                            'right' => 1,
                            'left' => 1,
                        ]
                    ],
                    'color' => [
                        'default' => '#7e7e7e',
                    ],
                ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_control(
            'buy_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'buy_box_shadow',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('buy_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' ), 'condition' => ['show_buy_btn' => 'yes']]);

        $this->add_control(
            'buy_icon_color_hover',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .add-to-cart-btn:hover svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .add-to-cart-btn:hover svg path' => 'fill: {{VALUE}}',
                ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_control(
            'buy_text_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn:hover' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'buy_bg_hover',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'buy_border_hover',
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_control(
            'buy_border_radius_hover',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'buy_box_shadow_hover',
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->end_controls_tab();

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => esc_html__( 'Button margin', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'top' => 0,
                    'right' => 10,
                    'bottom' => 0,
                    'left' => 10,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-buttons' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tabs();

        $this->add_control(
			'variation_options',
			[
				'label' => esc_html__( 'Color variations', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'show_variation_colors' => 'yes' ]
			]
		);

        $color_alignment = [
            'vr' => [
                'title' => __('Vertical', 'ahura'),
                'icon' => 'eicon-navigation-vertical'
            ],
            'hr' => [
                'title' => __('Horizontal', 'ahura'),
                'icon' => 'eicon-navigation-horizontal'
            ]
        ];

        $this->add_control(
            'colors_mode',
            [
                'label' => esc_html__('Display Mode', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => $color_alignment,
                'default' => 'vr',
                'condition' => [ 'show_variation_colors' => 'yes' ]
            ]
        );

        $this->add_responsive_control(
			'variations_list_hr',
			[
				'label' => esc_html__( 'Color variations HR position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .color-variations-list' => 'right: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_variation_colors' => 'yes' ]
			]
		);
        
        $this->add_responsive_control(
			'variations_list_vr',
			[
				'label' => esc_html__( 'Color variations VR position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .color-variations-list' => 'top: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_variation_colors' => 'yes' ]
			]
		);

        $this->add_control(
			'variations_circle_size',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .color-variations-list li' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_variation_colors' => 'yes' ]
			]
		);

        $this->add_control(
            'variations_circle_margin',
            [
                'label' => esc_html__( 'Margin', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .color-variations-list li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [ 'show_variation_colors' => 'yes' ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_style',
            [
                'label' => esc_html__('Slider', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'slider_width',
            [
                'label' => esc_html__('Slider fixed width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 1500
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .shop-carousel-element' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slider_btn_text_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .owl-nav i.fa' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .carousel-buttons span' => 'color: {{VALUE}};'
                ],
                'default' => '#181522',
            ]
        );

        $this->add_control(
            'slider_btn_bg_color',
            [
                'label' => esc_html__('Background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .owl-nav i' => 'background-color: {{VALUE}};'
                ],
                'default' => '#ffffff',
            ]
        );

        $this->add_control(
            'slider_btn_border_color',
            [
                'label' => esc_html__('Boder color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .owl-nav i' => 'border:1px solid {{VALUE}};'
                ],
            ]
        );

        $this->add_responsive_control(
            'slider_btn_size',
            [
                'label' => esc_html__('Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 23,
                ],
                'selectors' => [
                    '{{WRAPPER}} .owl-nav i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .owl-nav svg' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .carousel-buttons span' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .carousel-buttons span svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slider_next_btn_border_radius',
            [
                'label' => esc_html__( 'Next button border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .owl-nav i.fa' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .carousel-buttons .next-slide-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 50,
                    'bottom' => 50,
                    'right' => 50,
                    'left' => 50,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_control(
            'slider_prev_btn_border_radius',
            [
                'label' => esc_html__( 'Previous button border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .owl-prev i.fa' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .carousel-buttons .prev-slide-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 50,
                    'bottom' => 50,
                    'right' => 50,
                    'left' => 50,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_control(
            'slider_buttons_popover_toggle',
            [
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label' => esc_html__( 'Buttons Position', 'ahura' ),
                'label_off' => esc_html__( 'Default', 'ahura' ),
                'label_on' => esc_html__( 'Custom', 'ahura' ),
                'return_value' => 'yes',
            ]
        );
        $this->start_popover();
        
        $this->add_responsive_control(
			'slider_next_btns_bottom',
			[
				'label' => esc_html__( 'Next bottom', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .owl-next' => 'top: initial;',
					'{{WRAPPER}} .owl-next' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'slider_next_btns_right',
			[
				'label' => esc_html__( 'Next right', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .owl-next' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'slider_prev_btns_bottom',
			[
				'label' => esc_html__( 'Previous bottom', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .owl-prev' => 'top: initial;',
					'{{WRAPPER}} .owl-prev' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'slider_prev_btns_left',
			[
				'label' => esc_html__( 'Previous left', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .owl-prev' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_popover();

        $this->add_control(
            'slider_slides_margin',
            [
                'label' => esc_html__( 'Slides margin', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .owl-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_popover();

        $this->add_responsive_control(
            'slider_buttons_top_position',
            [
                'label' => esc_html__( 'Top', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slider_buttons_right_position',
            [
                'label' => esc_html__( 'Right', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons' => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slider_buttons_bottom_position',
            [
                'label' => esc_html__( 'Bottom', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slider_buttons_left_position',
            [
                'label' => esc_html__( 'Left', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_popover();

        $this->add_control(
			'slider_pagination_style',
			[
				'label' => __( 'Pagination', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'after',
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);

        $pagination_style_default = 'border-radius: 100%';
        $pagination_style1 = 'border-radius: 5px;';

        $this->add_control(
			'pagination_styles',
			[
				'label' => esc_html__( 'Active pagination style', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => $pagination_style_default,
				'options' => [
					$pagination_style_default => esc_html__( 'Default', 'ahura' ),
					$pagination_style1 => esc_html__( 'Style 1', 'ahura' ),
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .owl-dots .owl-dot.active' => '{{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_style1_width',
			[
				'label' => esc_html__( 'Style1 width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
						'step' => 1,
					],
				],
				'condition' => [ 'show_pagination' => 'yes', 'pagination_styles' => $pagination_style1 ],
				'selectors' => [
					'{{WRAPPER}} .owl-dots .owl-dot.active' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
            'pagination_margin',
            [
                'label' => esc_html__( 'Pagination margin', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .owl-dots' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition' => [ 'show_pagination' => 'yes' ],
            ]
        );

        $this->add_responsive_control(
			'pagination_width',
			[
				'label' => esc_html__( 'Pagination size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .owl-dots .owl-dot' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'active_pagination_width',
			[
				'label' => esc_html__( 'Active pagination size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .owl-dots .owl-dot.active' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'active_pagination_color',
			[
				'label' => esc_html__( 'Active pagination color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .owl-dots .owl-dot.active' => 'background-color:{{VALUE}};color:{{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'notactive_pagination_color',
			[
				'label' => esc_html__( 'Not-Active pagination color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .owl-dots .owl-dot' => 'background-color:{{VALUE}};opacity:1',
				],
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'outofstock_color',
			[
				'label' => esc_html__( 'Of of stock color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => 'white',
				'selectors' => [
					'{{WRAPPER}} .out-of-stock' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'outofstock_background_color',
			[
				'label' => esc_html__( 'Of of stock background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => 'red',
				'selectors' => [
					'{{WRAPPER}} .out-of-stock' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__( 'Box Padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .owl-shop-carousel' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 40,
                    'right' => 40,
                    'bottom' => 40,
                    'left' => 40,
                ]
            ]
        );

		$this->end_controls_section();

        $this->register_additional_controls();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( class_exists( 'WooCommerce' ) ) {
            $strikethrough = $settings['regular_price_strikethrough'] === 'yes' ? true : false;
            $title_price_same_line = $settings['title_price_same_line'] === 'yes';
            $title_tag = $settings['title_tag'];
            $has_price = isset($settings['price']) && $settings['price'] == 'yes';
            $show_price_label = $settings['show_price_label'] == 'yes';
			$field_is_term = (is_array($settings['catsid']) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);

			if( ( $settings[ 'catsid' ][ 0 ] == 'allproducts' ) || $settings[ 'catsid' ][ 0 ] == 'randomproducts' ) {
				$args = [
					'post_type'		 => 'product',
					'post_status'	 => 'publish',
					'posts_per_page' => $settings[ 'count' ],
					'order' 		 => $settings[ 'product_order' ],
					'orderby' 		 => $settings[ 'catsid' ][ 0 ] == 'randomproducts' ? 'rand' : $settings[ 'product_order' ]
				];
			} elseif( $settings[ 'catsid' ][ 0 ] == 'discountedproducts' ) {
				$args = [
					'post_type'		 => 'product',
					'post_status'	 => 'publish',
					'posts_per_page' => $settings[ 'count' ],
					'order' 		 => $settings[ 'product_order' ],
					'meta_key' 		 => '_sale_price',
					'meta_value' 	 => '0',
					'meta_compare'   => '>='
				];
			} else {
				$args = [
					'post_type'		 => 'product',
					'post_status'	 => 'publish',
					'posts_per_page' => $settings[ 'count' ],
					'tax_query'		 => [ [
						'taxonomy'   => 'product_cat',
						'field'		 => $field_is_term ? 'term_id' : 'slug',
						'terms'		 => $settings[ 'catsid' ],
					] ],
					'order' 		 => $settings[ 'product_order' ]
				];
			}

            $products_stock_status = $settings['products_stock_status'];

            if ($products_stock_status && $products_stock_status !== 'none') {
                $args['meta_query'] = array(array(
                    'key' => '_stock_status',
                    'value' => $products_stock_status,
                    'compare' => '==',
                ));
            }

            $slider_data = [
                'autoplay' => isset($settings['autoplay']) && $settings['autoplay'] == 'yes',
                'autoplayTimeout' => $settings['autoplay_delay'],
                'spacing' => $settings['slide_margin'] ?? 25,
                'cols' => [
                    'desktop' => $settings['layout_col'] ?? 4,
                    'tablet' => $settings['layout_col_tablet'] ?? 3,
                    'mobile' => $settings['layout_col_mobile'] ?? 1
                ],
                'show_pagination' => isset($settings['show_pagination']) && $settings['show_pagination'] == 'yes',
            ];

			$wc_query = new \WP_Query($args);
			if ( $wc_query->have_posts() ) : ?>
                <div class="shop-carousel-element<?php echo !$has_price ? ' without-price' : '' ?>">
                    <?php if ($settings['show_header'] == 'yes'): ?>
                    <div class="box-heading">
                        <div class="box-title">
                            <?php if ($settings['show_box_title'] == 'yes'): ?>
                                <span><?php echo $settings['box_title'] ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="box-buttons">
                            <?php
                            if ($settings['show_box_btn'] == 'yes'):
                            if ( ! empty( $settings['box_btn_link']['url'] ) ) {
                                $this->add_link_attributes( 'box_btn_link', $settings['box_btn_link'] );
                            }
                            ?>
                            <a <?php echo $this->get_render_attribute_string( 'box_btn_link' ); ?>>
                                <span><?php echo $settings['box_btn_title'] ?></span>
                                <svg width="25" height="21" viewBox="0 0 25 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M25 10.4114C25 10.981 24.5768 11.4517 24.0277 11.5262L23.875 11.5364L4.099 11.5355L11.2435 18.6508C11.6838 19.0892 11.6853 19.8015 11.2469 20.2418C10.8484 20.6421 10.2235 20.6797 9.78233 20.3539L9.65592 20.2452L0.580921 11.2092C0.522884 11.1515 0.472475 11.0889 0.429691 11.0229C0.417608 11.003 0.405308 10.9827 0.393646 10.9619C0.382919 10.9441 0.373228 10.9257 0.364082 10.907C0.351383 10.8798 0.338974 10.8518 0.327709 10.8231C0.318554 10.801 0.310911 10.7796 0.30394 10.7579C0.29565 10.7311 0.287598 10.7025 0.28067 10.6734C0.27552 10.6532 0.271442 10.6337 0.267883 10.6141C0.262882 10.5849 0.258623 10.5548 0.255585 10.5242C0.252962 10.501 0.251383 10.4779 0.250509 10.4548C0.250284 10.4408 0.25 10.4262 0.25 10.4114L0.250565 10.3679C0.251427 10.3458 0.252934 10.3237 0.255089 10.3017L0.25 10.4114C0.25 10.3404 0.256577 10.271 0.269152 10.2036C0.272068 10.1876 0.275543 10.1711 0.279392 10.1546C0.287382 10.1207 0.296618 10.0881 0.307251 10.0562C0.312471 10.0403 0.318552 10.0233 0.32505 10.0065C0.338198 9.9726 0.352486 9.94033 0.368206 9.9089C0.375509 9.89412 0.383688 9.87865 0.392254 9.86333C0.406311 9.83834 0.420795 9.8146 0.43611 9.79145C0.446915 9.77507 0.458879 9.75802 0.471375 9.74124L0.48111 9.72827C0.511419 9.68868 0.5443 9.65115 0.579504 9.61595L0.580854 9.6149L9.65585 0.577402C10.0961 0.138973 10.8084 0.140447 11.2468 0.580696C11.6454 0.980922 11.6804 1.60599 11.3527 2.04573L11.2435 2.17168L4.102 9.28554L23.875 9.28644C24.4963 9.28644 25 9.79012 25 10.4114Z" fill="#FF5023"/>
                                </svg>
                            </a>
                            <?php endif; ?>
                            <?php if($settings['show_header_slider_buttons'] == 'yes'): ?>
                                <div class="carousel-buttons">
                                    <span class="next-slide-btn">
                                        <i class='fa fa-arrow-right'></i>
                                    </span>
                                    <span class="prev-slide-btn">
                                        <i class='fa fa-arrow-left'></i>
                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="owl-carousel owl-theme owl-shop-carousel ah-has-inner-secondary-bg" data-slider='<?php echo json_encode($slider_data) ?>'>
                        <?php while ( $wc_query->have_posts() ) : $wc_query->the_post(); global $wpdb, $product; ?>
                            <?php if (get_post_meta(get_the_ID(), '_sale_price', true) != $settings['sale_price_product'] ): ?>
                                <div class="sc-item-content">
                                    <div class="sc-items-top">
                                        <div class="product-cover-wrap">
                                            <div class="product-cover">
                                                <?php 
                                                if ($product->is_type('variable') && $settings['show_variation_colors'] == 'yes'):
                                                    $variationListColors = Variations_Color::getVariationColors($product);
                                                    if ($variationListColors): ?>
                                                        <ul class="color-variations-list mode-<?php echo $settings['colors_mode'] ?>">
                                                            <?php foreach ($variationListColors as $colorHex): ?>
                                                                <li style="background-color:<?php echo $colorHex; ?>;"></li>
                                                            <?php endforeach; ?>
                                                        </ul>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <a class="fimage" href="<?php echo get_permalink(); ?>"><?php the_post_thumbnail('woocommerce_thumbnail'); ?></a>
                                            </div>
                                        </div>
                                        <a href="<?php echo get_permalink(); ?>" class="<?php echo $title_price_same_line ? 'd-flex justify-content-center align-items-center title-price ' : ''; ?>ah-has-text">
                                            <<?php echo $title_tag; ?> class="product-title"<?php echo $settings['title_seperator'] != 'yes' ? ' style="border:none;"' : ''; ?>><?php echo $settings['fully_show_title'] == 'yes' ? get_the_title() : wp_trim_words( get_the_title(), 6, '...' ); ?></<?php echo $title_tag; ?>>
                                            <?php if ($has_price && $title_price_same_line) : ?>
                                                <div class="product-price-wrap <?php echo $show_price_label ? 'with-label' : '' ?>">
                                                    <?php if ($show_price_label) :
                                                        $price_prefix = '<span class="price-label ' . (is_rtl() ? 'pl-2' : 'pr-2') . '">'
                                                            . __('Price:', 'ahura') .
                                                            '</span>';
                                                    endif; ?>
                                                    <div class="mwprprice ah-has-text ah-text-center">
                                                        <?php echo Shop_Carousel_Price_Render::renderPrice($product, (isset($price_prefix) ? $price_prefix : ''), $strikethrough); ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </a>
                                    </div>
                                    <div class="sc-items-bottom">
                                        <?php if ($has_price && !$title_price_same_line) : ?>
                                            <div class="product-price-wrap <?php echo $show_price_label ? 'with-label' : '' ?>">
                                                <?php if ($show_price_label) :
                                                    $price_prefix = '<span class="price-label ' . (is_rtl() ? 'pl-2' : 'pr-2') . '">'
                                                        . __('Price:', 'ahura') .
                                                        '</span>';
                                                endif; ?>
                                                <div class="mwprprice ah-has-text ah-text-center">
                                                    <?php echo Shop_Carousel_Price_Render::renderPrice($product, (isset($price_prefix) ? $price_prefix : ''), $strikethrough); ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php
                                            if ( ( $settings['stock_status'] == 'yes' && wc_get_product( get_the_ID() )->get_stock_status() == "outofstock" ) ) {
                                            echo '<p class="out-of-stock">'.$settings['outofstock_text'].'</p>';
                                            }
                                        ?>
                                        <?php if ($settings['show_buy_btn'] == 'yes'): ?>
                                        <div class="item-buttons">
                                            <a href="<?php echo get_permalink(); ?>?add-to-cart=<?php the_ID(); ?>" class="add-to-cart-btn ah-is-button"<?php echo $settings['full_width_button'] == 'yes' ? ' style="width:100%"' : ''; ?>>
                                                <?php \Elementor\Icons_Manager::render_icon($settings['buy_button_icon'], [ 'aria-hidden' => 'true' ]); ?>
                                                <?php echo $settings['buy_button_text'] ?>
                                            </a>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endwhile; ?>
                    </div>
                    <?php wp_reset_postdata(); ?>
                </div>
                <?php endif; ?>                                                                         
                <div class="clear"></div>
			<?php
		} elseif(is_admin()) {
			?>
			<div class="productcategorybox mw_elem_empty_box"><h3><?php _e('To use this element you must install woocommerce plugin.', 'ahura'); ?></h3></div>
			<?php
		}
	}
}
