<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.
defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\mw_assets;
use ahura\app\Post_Meta;
use Elementor\Controls_Manager;

class post_carousel10 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('post_carousel10_js', mw_assets::get_js('elementor.post_carousel10'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('post_carousel10_css', mw_assets::get_css('elementor.post_carousel10'));
        if(!is_rtl()){
            $this->register_elementor_style('post_carousel10_ltr_css', mw_assets::get_css('elementor.ltr.post_carousel10_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('post_carousel10_js')];
    }

    public function get_name()
    {
        return 'ahura_post_carousel_10';
    }

    public function get_title()
    {
        return __('Post Carousel 10', 'ahura');
    }

    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return ['ahuraelements', 'ahura_posts'];
    }

    public function get_keywords()
    {
        return ['ahura', 'post', 'post carousel 10', esc_html__('ahura', 'ahura'), esc_html__( 'Post Carousel 10' , 'ahura')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ahura'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_type',
            [
                'label'    => __('Show Type', 'ahura'),
                'type'     => \Elementor\Controls_Manager::SELECT,
                'options'  => [
                    'latest' => __('Latest Posts', 'ahura'),
                    'category' => __('Categories', 'ahura'),
                ],
                'label_block' => true,
                'default' => 'latest'
            ]
        );

        $categories = get_categories();
        $cats       = array();
        if ($categories){
            foreach ($categories as $category) {
                $cats[$category->term_id] = $category->name;
            }
        }
        $default = key($cats);

        $this->add_control(
            'cat_ids',
            [
                'label'    => __('Categories', 'ahura'),
                'type'     => \Elementor\Controls_Manager::SELECT2,
                'options'  => $cats,
                'label_block' => true,
                'multiple' => true,
                'default' => $default,
                'condition' => ['show_type' => 'category']
            ]
        );

        $this->add_control(
            'posts_order',
            [
                'label' => __('Sort', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'DESC',
                'options' => [
                    'ASC' => [
                        'title' => __('Ascending', 'ahura'),
                        'icon' => 'eicon-sort-up'
                    ],
                    'DESC' => [
                        'title' => __('Descending', 'ahura'),
                        'icon' => 'eicon-sort-down'
                    ],
                ],
                'toggle' => true,
            ]
        );

        $this->add_control(
            'post_count',
            [
                'label'      => __('Number of posts', 'ahura'),
                'type'       => \Elementor\Controls_Manager::NUMBER,
                'default'    => 4
            ]
        );

		$this->add_control(
			'readmore_text',
			[
				'label' => esc_html__( 'Read more text', 'ahura' ),
                'default' => esc_html__( 'Read more', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

        $this->add_control(
            'excerpt_chars_count',
            [
                'label'   => __( 'Excerpt Characters', 'ahura' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 30,
            ]
        );

		$this->add_control(
			'use_gregorian_calendar',
			[
				'label' => esc_html__( 'Gregorian calendar', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'ahura' ),
				'label_off' => esc_html__( 'No', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_section',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay_delay',
            [
                'label' => esc_html__( 'Autoplay delay', 'ahura' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 10000,
                'step' => 1,
                'default' => 4000,
                'condition' => ['autoplay' => 'yes']
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'content_styles',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'content_box_option',
			[
				'label' => esc_html__( 'Box', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'content_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .slider-content .thumbnail-container' => 'width: {{SIZE}}%;',
                    '{{WRAPPER}} .post-carousel-10 .slider-content .content-container' => 'width: calc(100% - {{SIZE}}%);',
                    '{{WRAPPER}} .post-carousel-10 .post-footer-container' => 'width: calc(100% - {{SIZE}}%);',
                    '{{WRAPPER}} .post-carousel-10 .swiper-nav' => 'width: {{SIZE}}%;',
                    '{{WRAPPER}} .post-carousel-10 .swiper-controller-wrapper' => 'width: {{SIZE}}%;',
                    '{{WRAPPER}} .post-carousel-10 .swiper-progress-bar' => 'width: {{SIZE}}%;',
				],
			]
		);

        $this->add_responsive_control(
			'content_area_margin',
			[
				'label' => esc_html__( 'Area margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 30,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .slider-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'content_margin',
			[
				'label' => esc_html__( 'Content margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .slider-content .content-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'thumbnail_option',
			[
				'label' => esc_html__( 'Thumbnail', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_responsive_control(
			'thumbnail_height',
			[
				'label' => esc_html__( 'height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 245,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .slider-content .thumbnail-container' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .post-carousel-10 .slider-content .content-container' => 'max-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'thumbnail_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 0 : 26,
					'bottom' => 0,
					'left' => is_rtl() ? 26 : 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .slider-content .thumbnail-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 15,
					'right' => 15,
					'bottom' => 15,
					'left' => 15,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'.post-carousel-10 .slider-content img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'title_option',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .slider-content .post-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '20'
						]
                    ],
					'line_height' => [
						'default' => [
							'unit' => 'px',
							'size' => '25'
						]
                    ],
                    'font_weight' => [
                        'default' => 600
                    ]
                ],
				'selector' => '{{WRAPPER}} .post-carousel-10 .slider-content .post-title',
			]
		);

        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 25,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'tablet_default' => [
					'top' => 20,
					'right' => 0,
					'bottom' => 25,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'mobile_default' => [
					'top' => 20,
					'right' => 0,
					'bottom' => 25,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'.post-carousel-10 .slider-content .post-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'desc_option',
			[
				'label' => esc_html__( 'Description', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'desc_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .content-container .post-desc' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '18'
						]
                    ],
					'line_height' => [
						'default' => [
							'unit' => 'px',
							'size' => '31'
						]
                    ],
                ],
				'selectors' => '{{WRAPPER}} .post-carousel-10 .content-container .post-desc',
			]
		);

        $this->add_responsive_control(
			'desc_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'.post-carousel-10 .slider-content .post-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'meta_option',
			[
				'label' => esc_html__( 'Meta', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'meta_typography',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '14'
						]
                    ],
                    'font_weight' => [
                        'default' => 600
                    ]
                ],
				'selector' => '{{WRAPPER}} .post-carousel-10 .slider-meta span',
			]
		);

        $this->add_control(
			'meta_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .post-carousel-10 .slider-meta span' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'meta_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'.post-carousel-10 .post-carousel-10 .slider-meta span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'button_option',
			[
				'label' => esc_html__( 'Button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '14'
						]
                    ],
                    'font_weight' => [
                        'default' => 600
                    ]
                ],
				'selector' => '{{WRAPPER}} .post-carousel-10 .slider-meta a.post-button',
			]
		);

        $this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .post-button' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'button_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .post-button' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '1',
							'right' => '1',
							'bottom' => '1',
							'left' => '1',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#D4D4D4',
					],
				],
				'selector' => '{{WRAPPER}} .post-carousel-10 .post-button',
			]
		);

        $this->add_responsive_control(
			'button_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 18,
					'bottom' => 10,
					'left' => 18,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'.post-carousel-10 .post-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'button_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 0 : 20,
					'bottom' => 0,
					'left' => is_rtl() ? 20 : 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'.post-carousel-10 .post-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'button_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .post-button' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'slider_styles',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'nav_options',
			[
				'label' => esc_html__( 'Navigation area', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'nav_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-controller-wrapper' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .post-carousel-10 .swiper-nav' => 'background-color: {{VALUE}}',
				],
			]
		);
        
        $this->add_responsive_control(
			'nav_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-controller-wrapper' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .post-carousel-10 .swiper-nav' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'nav_area_margin',
			[
				'label' => esc_html__( 'Area margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 0 : 26,
					'bottom' => 0,
					'left' => is_rtl() ? 26 : 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'.post-carousel-10 .swiper-controller-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'nav_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => -60,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'.post-carousel-10 .swiper-nav' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'nav_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 40,
					'bottom' => 0,
					'left' => 40,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'.post-carousel-10 .swiper-nav' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'nav_button_options',
			[
				'label' => esc_html__( 'Navigaion button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'nav_button_border',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '2',
							'right' => '2',
							'bottom' => '2',
							'left' => '2',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#292D32',
					],
				],
				'selector' => '{{WRAPPER}} .post-carousel-10 .swiper-nav .swiper-nav-button',
			]
		);
        
        $this->add_responsive_control(
			'nav_button_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 4,
					'right' => 8,
					'bottom' => 4,
					'left' => 8,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'.post-carousel-10 .swiper-nav .swiper-nav-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'nav_button_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-nav .swiper-nav-button' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'bullet_options',
			[
				'label' => esc_html__( 'Bullet', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_responsive_control(
			'bullet_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 28,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-pagination .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'bullet_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 2,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-pagination .swiper-pagination-bullet' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'bullet_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 3,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-pagination .swiper-pagination-bullet' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'bullet_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 3,
					'bottom' => 5,
					'left' => 3,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'.post-carousel-10 .swiper-pagination .swiper-pagination-bullet' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'bullet_active_color',
			[
				'label' => esc_html__( 'Active color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#D72121',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'bar_options',
			[
				'label' => esc_html__( 'Progress bar', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_responsive_control(
			'bar_bottom_position',
			[
				'label' => esc_html__( 'Vertical position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'default' => [
					'size' => 65,
					'unit' => '%',
				],
				'tablet_default' => [
					'size' => 45,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 35,
					'unit' => '%',
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-progress-bar' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		
        
        $this->add_responsive_control(
			'bar_hr_position',
			[
				'label' => esc_html__( 'Horizontal position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-progress-bar' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'bar_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 3,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-progress-bar .slide_progress-bar' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'bar_backcolor',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF80',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-progress-bar .slide_progress-bar' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'bar_active_backcolor',
			[
				'label' => esc_html__( 'Active color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgb(255, 0, 119)',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-10 .swiper-progress-bar .slide_progress-bar span' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $cat_ids   = $settings['cat_ids'];
        $show_type = $settings['show_type'];
        $chars_num = isset($settings['excerpt_chars_count']) && intval($settings['excerpt_chars_count']) ? $settings['excerpt_chars_count'] : 35;

        $args = [
            'posts_per_page' => $settings['post_count'],
            'post_status' => 'publish',
            'order' => $settings['posts_order'] ?? 'DESC'
        ];

        if($show_type == 'category'){
            $args['cat'] = ahura_sanitize_categories($cat_ids);
        }

        $posts = new \WP_Query($args);

        if (!$posts->have_posts())
            return false;

        $slider_data = [
            'widgetID' => $wid,
            'autoPlay' => $settings['autoplay'] == 'yes',
            'delay' => (intval($settings['autoplay_delay'])) ? $settings['autoplay_delay'] : 2500,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];
        ?>
        <div class="post-carousel-10 post-carousel-10-<?php echo $wid; ?> is-<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
            <div class="carousel-items">
                <div class="swiper swiper-container items-slider" dir="<?php echo is_rtl() ? 'rtl' : 'ltr' ?>" data-slider='<?php echo json_encode($slider_data) ?>'>
                    <div class="swiper-wrapper">
                        <?php while ($posts->have_posts()) : $posts->the_post(); ?>
                            <div class="swiper-slide">
                                <div class="d-flex slider-content">
                                    <div class="thumbnail-container">
                                        <?php echo get_the_post_thumbnail(); ?>
                                    </div>
                                    <div class="content-container">
                                        <h3 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        <p class="post-desc">
                                            <?php
                                            if(!get_the_excerpt()){
                                                echo wp_trim_words(get_the_content(), $chars_num, '...');
                                            } else {
												echo wp_trim_words(get_the_excerpt(), $chars_num, '...');
                                            }
                                            ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center slider-meta">
                                    <div class="d-flex justify-content-center align-items-center swiper-controller-wrapper"></div>
                                    <div class="d-flex align-items-center post-footer-container">
                                    <?php if(!empty($settings['readmore_text'])): ?>
                                        <a href="<?php the_permalink(); ?>" class="post-button"><?php echo sanitize_text_field($settings['readmore_text']); ?></a>
                                    <?php endif;
                                        $post_date = get_the_date('j F Y');
                                        if (function_exists('ahura_jdate') && $settings['use_gregorian_calendar'] !== 'yes') {
                                            $post_date = ahura_jdate('l j F');
                                        }
                                        echo '<span>' . $post_date . '</span>';
                                    ?>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                    <div class="d-flex align-items-center justify-content-between swiper-nav">
                        <div class="d-flex align-items-center swiper-nav-button swiper-btn-prev"><i class="fas fa-angle-right"></i></div>
                        <div class="d-flex align-items-center flex-wrap justify-content-center swiper-pagination"></div>
                        <div class="d-flex align-items-center swiper-nav-button swiper-btn-next"><i class="fas fa-angle-left"></i></div>
                    </div>
                    <?php if($settings['autoplay'] === 'yes'): ?>
                        <div class="swiper-progress-bar">
                            <span class="slide_progress-bar"><span></span></span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php wp_reset_postdata(); ?>
        <?php
    }
}
