<?php

namespace ahura\inc\widgets;
// Block direct access to the main plugin file.

use Elementor\Controls_Manager;
use \ahura\app\mw_assets;

defined('ABSPATH') or die('No script kiddies please!');

class items_carousel2 extends \ahura\app\elementor\Elementor_Widget_Base
{
    use \ahura\app\traits\mw_elementor;

    function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('items_carousel2_js', mw_assets::get_js('elementor.items_carousel2'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('items_carousel2_css', mw_assets::get_css('elementor.items_carousel2'));
    }

    function get_script_depends()
    {
        return [mw_assets::get_handle_name('items_carousel2_js')];
    }

    public function get_name()
    {
        return 'ahura_items_carousel2';
    }
    function get_title()
    {
        return esc_html__('Items carousel 2', 'ahura');
    }
    public function get_icon() {
        return 'aicon-svg-items-carousel';
    }
    function get_categories()
    {
        return ['ahuraelements'];
    }
    function get_keywords()
    {
        return ['ahura', 'carousel', esc_html__('ahura', 'ahura'), esc_html__('Items carousel 2', 'ahura')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'conetent_section',
            [
                'label' => esc_html__('Content', 'ahura'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'show_image',
            [
                'label' => esc_html__( 'Show Image', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'yes', 'ahura' ),
                'label_off' => esc_html__( 'no', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $repeater->add_control(
            'item_image',
            [
                'label' => __('Image', 'ahura'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => ['show_image' => 'yes']
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __('Title', 'ahura'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Title', 'ahura'),
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label' => esc_html__( 'Description', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => esc_html__( 'Default description', 'ahura' ),
                'placeholder' => esc_html__( 'Type your description here', 'ahura' ),
            ]
        );

        $repeater->add_control(
            'show_button',
            [
                'label' => esc_html__( 'Show Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'yes', 'ahura' ),
                'label_off' => esc_html__( 'no', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'link_text',
            [
                'label' => __('Button Title', 'ahura'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Read more', 'ahura'),
                'condition' => ['show_button' => 'yes']
            ]
        );

        $repeater->add_control(
            'link_url',
            [
                'label' => __('Button url', 'ahura'),
                'type' => \Elementor\Controls_Manager::URL,
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => '#'
                ],
                'condition' => ['show_button' => 'yes']
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => __('Slides', 'ahura'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => __('Title','ahura')
                    ],[
                        'title' => __('Title','ahura')
                    ],[
                        'title' => __('Title','ahura')
                    ]
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'header_section',
            [
                'label' => __( 'Header', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_header',
            [
                'label' => esc_html__('Show Header', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_box_title',
            [
                'label' => esc_html__('Show Title', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->add_control(
            'box_title',
            [
                'label'      => __('Title', 'ahura'),
                'type'       => \Elementor\Controls_Manager::TEXT,
                'default'    => __('Latest Products', 'ahura'),
                'condition' => ['show_header' => 'yes', 'show_box_title' => 'yes']
            ]
        );

        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__( 'Show Arrows', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'yes', 'ahura' ),
                'label_off' => esc_html__( 'no', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'setting_section',
            [
                'label' => esc_html__('Settings', 'ahura'),
            ]
        );

        $this->add_control(
            'auto_play',
            [
                'label' => esc_html__( 'Auto Play', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'yes', 'ahura' ),
                'label_off' => esc_html__( 'no', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'auto_play_speed',
            [
                'label' => esc_html__( 'Auto Play Speed', 'ahura' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 10000,
                'step' => 1,
                'default' => 4500,
                'condition' => ['auto_play' => 'yes']
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'desktop_default' => 3,
                'tablet_default' => 2,
                'mobile_default' => 1,
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'head_styles',
            [
                'label' => esc_html__('Header', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->add_control(
            'box_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .box-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'box_title_typo',
                'selector' => '{{WRAPPER}} .box-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 600],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '27',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'slider_btns_style_options',
            [
                'label' => esc_html__( 'Buttons', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('slider_btn_style_tabs');
        $this->start_controls_tab('slider_btn_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'slider_btn_color',
            [
                'label' => esc_html__('Button Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#939393',
                'selectors' => [
                    '{{WRAPPER}} .slider-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'slider_btn_bg_color',
                'label' => esc_html__('Button Background', 'ahura'),
                'exclude' => ['image'],
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .slider-btn',
            ]
        );

        $this->add_responsive_control(
            'slider_btn_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .slider-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'slider_btn_border',
                'selector' => '{{WRAPPER}} .slider-btn',
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'default' => [
                            'unit' => 'px',
                            'top' => 2,
                            'bottom' => 2,
                            'right' => 2,
                            'left' => 2,
                        ]
                    ],
                    'color' => [
                        'default' => '#afafaf',
                    ],
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('slider_btn_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'slider_des_color_hover',
            [
                'label' => esc_html__('Button Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'slider_btn_bg_color_hover',
                'label' => esc_html__('Button Background', 'ahura'),
                'exclude' => ['image'],
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .slider-btn:hover',
            ]
        );

        $this->add_responsive_control(
            'slider_btn_border_radius_hover',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .slider-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'slider_btn_border_hover',
                'selector' => '{{WRAPPER}} .slider-btn:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'item_img_styles',
            [
                'label' => esc_html__('Image', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-image img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_img_width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-image img' => 'width: {{SIZE}}{{UNIT}}',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 700
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 150
                ],
            ]
        );

        $this->add_responsive_control(
            'item_img_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-image img' => 'height: {{SIZE}}{{UNIT}}',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 700
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 70
                ],
            ]
        );

        $this->add_responsive_control(
            'item_img_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'item_styles',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $alignment = array(
            'right' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_responsive_control(
            'item_text_alignment',
            [
                'label' => esc_html__('Text Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => (is_rtl()) ? 'right' : 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .item-content' => 'text-align: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .item-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'item_title_typo',
                'selector' => '{{WRAPPER}} .item-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '18',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'item_des_color',
            [
                'label' => esc_html__('Description Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .item-description' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Description Typography', 'ahura'),
                'name' => 'item_des_typo',
                'selector' => '{{WRAPPER}} .item-description',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'btn_style_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('btn_style_tabs');
        $this->start_controls_tab('btn_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'item_btn_color',
            [
                'label' => esc_html__('Button Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .item-button .item-link' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_btn_bg_color',
                'label' => esc_html__('Button Background', 'ahura'),
                'exclude' => ['image'],
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .item-button .item-link',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#fff'],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Button Typography', 'ahura'),
                'name' => 'item_btn_typo',
                'selector' => '{{WRAPPER}} .item-button .item-link',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ]
                    ]
                ],
            ]
        );

        $this->add_responsive_control(
            'item_btn_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-button .item-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 7,
                    'right' => 7,
                    'bottom' => 7,
                    'left' => 7,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_btn_border',
                'selector' => '{{WRAPPER}} .item-button .item-link',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('btn_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'item_des_color_hover',
            [
                'label' => esc_html__('Button Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-button .item-link:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_btn_bg_color_hover',
                'label' => esc_html__('Button Background', 'ahura'),
                'exclude' => ['image'],
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .item-button .item-link:hover',
            ]
        );

        $this->add_responsive_control(
            'item_btn_border_radius_hover',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-button .item-link:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_btn_border_hover',
                'selector' => '{{WRAPPER}} .item-button .item-link:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $has_arrows = ($settings['show_arrow'] == 'yes');
        $wid = $this->get_id();

        $slider_data = [
            'widgetID' => $wid,
            'spaceBetween' => (isset($settings['slides_space']) && intval($settings['slides_space'])) ? $settings['slides_space'] : 60,
            'spaceBetweenTablet' => (isset($settings['slides_space_tablet']) && intval($settings['slides_space_tablet'])) ? $settings['slides_space_tablet'] : 30,
            'spaceBetweenMobile' => (isset($settings['slides_space_mobile']) && intval($settings['slides_space_mobile'])) ? $settings['slides_space_mobile'] : 15,
            'autoPlayStatus' => $settings['auto_play'] === 'yes',
            'playDelay' => $settings['auto_play'] === 'yes' ? $settings['auto_play_speed'] : 4500,
            'desktopPerView' => (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 3,
            'tabletPerView' => (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 2,
            'mobilePerView' => (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
            'arrows' => $has_arrows,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];
        ?>
        <div class="items-carousel2 items-carousel2-<?php echo $wid ?> is-<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
            <?php if ($settings['show_header'] == 'yes'): ?>
                <div class="box-head">
                    <?php if ($settings['show_box_title'] == 'yes'): ?>
                        <div class="box-title"><?php echo $settings['box_title'] ?></div>
                    <?php endif; ?>
                    <?php if($has_arrows): ?>
                        <div class="swiper-slider-buttons">
                            <div class="swiper-button-next slider-btn"></div>
                            <div class="swiper-button-prev slider-btn"></div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="swiper" data-slider='<?php echo json_encode($slider_data) ?>'>
                <div class="swiper-wrapper">
                    <?php if ($settings['items']):
                        foreach ($settings['items'] as $item):
                            $item_id = !empty($item['_id']) ? $item['_id'] : uniqid();
                            if ( ! empty( $item['link_url']['url'] ) ) {
                                $this->add_link_attributes( 'link_url_' . $item_id, $item['link_url'] );
                            }
                            ?>
                            <div class="swiper-slide elementor-repeater-item-<?php echo $item_id; ?>">
                                <div class="item-content">
                                    <?php if($item['show_image'] == 'yes'): ?>
                                        <div class="item-image">
                                            <?php if (!empty($item['item_image']['id'])): ?>
                                                <?php echo wp_get_attachment_image($item['item_image']['id'], 'full'); ?>
                                            <?php elseif(!empty($item['item_image']['url'])): ?>
                                                <img src="<?php echo $item['item_image']['url'] ?>" alt="item image">
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($item['title']): ?>
                                        <div class="item-title-wrap w-100">
                                            <h6 class="item-title"><?php echo $item['title']; ?></h6>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($item['description']): ?>
                                        <div class="item-description w-100">
                                            <p><?php echo $item['description']; ?></p>
                                        </div>
                                    <?php endif; ?>
                                    <?php if('yes' === $item['show_button']): ?>
                                        <div class="item-button w-100">
                                            <a <?php echo $this->get_render_attribute_string( 'link_url_' . $item_id ); ?> class="item-link">
                                                <?php echo $item['link_text']; ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
    }
}
